/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2e.core.ui.internal.wizards;

import java.util.Arrays;
import java.util.Properties;
import org.apache.maven.execution.ExecutionListener;
import org.apache.maven.execution.MavenExecutionRequest;
import org.apache.maven.execution.MavenExecutionResult;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.m2e.core.MavenPlugin;
import org.eclipse.m2e.core.embedder.IMaven;
import org.eclipse.m2e.core.embedder.IMavenExecutionContext;
import org.eclipse.m2e.core.embedder.MonitorExecutionListener;
import org.eclipse.m2e.core.ui.internal.Messages;
import org.eclipse.m2e.core.ui.internal.actions.OpenMavenConsoleAction;
import org.eclipse.m2e.core.ui.internal.wizards.MavenInstallFileArtifactWizardPage;
import org.eclipse.ui.IImportWizard;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.progress.IProgressConstants;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MavenInstallFileWizard
extends Wizard
implements IImportWizard {
    private static final Logger log = LoggerFactory.getLogger(MavenInstallFileWizard.class);
    private IFile selectedFile;
    private MavenInstallFileArtifactWizardPage artifactPage;

    public MavenInstallFileWizard() {
        this.setNeedsProgressMonitor(true);
        this.setWindowTitle(Messages.MavenInstallFileWizard_title);
    }

    public void addPages() {
        this.artifactPage = new MavenInstallFileArtifactWizardPage(this.selectedFile);
        this.addPage((IWizardPage)this.artifactPage);
    }

    public boolean performFinish() {
        Properties properties = new Properties();
        properties.setProperty("file", this.artifactPage.getArtifactFileName());
        properties.setProperty("groupId", this.artifactPage.getGroupId());
        properties.setProperty("artifactId", this.artifactPage.getArtifactId());
        properties.setProperty("version", this.artifactPage.getVersion());
        properties.setProperty("packaging", this.artifactPage.getPackaging());
        if (this.artifactPage.getClassifier().length() > 0) {
            properties.setProperty("classifier", this.artifactPage.getClassifier());
        }
        if (this.artifactPage.getPomFileName().length() > 0) {
            properties.setProperty("pomFile", this.artifactPage.getPomFileName());
        }
        if (this.artifactPage.isGeneratePom()) {
            properties.setProperty("generatePom", "true");
        }
        if (this.artifactPage.isCreateChecksum()) {
            properties.setProperty("createChecksum", "true");
        }
        Job job = Job.create((String)Messages.MavenInstallFileWizard_job, monitor -> {
            try {
                IMaven maven = MavenPlugin.getMaven();
                IMavenExecutionContext executionContext = maven.createExecutionContext();
                MavenExecutionRequest request = executionContext.getExecutionRequest();
                request.setGoals(Arrays.asList("install:install-file"));
                request.setUserProperties(properties);
                request.setExecutionListener((ExecutionListener)new MonitorExecutionListener(monitor));
                MavenExecutionResult executionResult = executionContext.execute(request);
                for (Throwable exception : executionResult.getExceptions()) {
                    log.error(String.valueOf(Messages.MavenInstallFileWizard_error) + "; " + exception, exception);
                }
            }
            catch (CoreException ex) {
                log.error("Failed to install artifact:" + ex.getMessage(), (Throwable)ex);
            }
            return Status.OK_STATUS;
        });
        job.setProperty(IProgressConstants.ACTION_PROPERTY, (Object)new OpenMavenConsoleAction());
        job.schedule();
        return true;
    }

    public void init(IWorkbench workbench, IStructuredSelection selection) {
        Object element = selection.getFirstElement();
        if (element instanceof IFile var4_5) {
            this.selectedFile = file;
        }
    }
}

