/*
 * Decompiled with CFR 0.152.
 */
package de.drazil.nerdsuite.wizard;

import de.drazil.nerdsuite.model.GraphicFormat;
import de.drazil.nerdsuite.model.GraphicFormatVariant;
import de.drazil.nerdsuite.model.SimpleEntity;
import de.drazil.nerdsuite.model.TargetPlatform;
import de.drazil.nerdsuite.widget.GraphicFormatFactory;
import de.drazil.nerdsuite.widget.PlatformFactory;
import de.drazil.nerdsuite.widget.ProjectTypeFactory;
import de.drazil.nerdsuite.wizard.AbstractBoundWizardPage;
import java.util.List;
import java.util.Map;
import org.apache.commons.io.FilenameUtils;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Spinner;
import org.eclipse.swt.widgets.Text;

public class GraphicsProjectWizardPage
extends AbstractBoundWizardPage {
    private Label projectNameLabel;
    private Label targetPlatformLabel;
    private Label gfxFormatLabel;
    private Label gfxFormatVariantLabel;
    private Label separatorLabel;
    private Label maxItemsLabel;
    private Label widthLabel;
    private Label heightLabel;
    private Label rowsLabel;
    private Label columnsLabel;
    private Text projectNameText;
    private Spinner tileWidthSpinner;
    private Spinner tileHeightSpinner;
    private Spinner tileColumnsSpinner;
    private Spinner tileRowsSpinner;
    private Spinner maxItemsSpinner;
    private ComboViewer targetPlatformCombo;
    private ComboViewer gfxFormatCombo;
    private ComboViewer gfxFormatVariantCombo;
    private SimpleEntity projectType;
    private GraphicFormat gf;
    private GraphicFormatVariant gfv;

    public GraphicsProjectWizardPage(Map<String, Object> userData) {
        super("wizardPage", userData);
        this.projectType = ProjectTypeFactory.getProjectTypeByName((String)userData.get("PROJECT_TYPE_ID"));
        this.setTitle("New " + this.projectType.getName());
        this.setDescription("Please enter a Project Name");
    }

    public void createControl(Composite parent) {
        Composite container = new Composite(parent, 0);
        this.setControl((Control)container);
        container.setLayout((Layout)new FormLayout());
        this.separatorLabel = new Label(container, 258);
        this.maxItemsLabel = new Label(container, 0);
        this.maxItemsLabel.setText("Max items");
        this.maxItemsSpinner = new Spinner(container, 2048);
        this.projectNameLabel = new Label(container, 0);
        this.projectNameLabel.setText("Project Name");
        this.targetPlatformLabel = new Label(container, 0);
        this.targetPlatformLabel.setText("Target Platform");
        this.gfxFormatLabel = new Label(container, 0);
        this.gfxFormatLabel.setText("Format");
        this.gfxFormatVariantLabel = new Label(container, 0);
        this.gfxFormatVariantLabel.setText("Format Variant");
        this.widthLabel = new Label(container, 0);
        this.widthLabel.setEnabled(false);
        this.widthLabel.setText("Width");
        this.heightLabel = new Label(container, 0);
        this.heightLabel.setEnabled(false);
        this.heightLabel.setText("Height");
        this.columnsLabel = new Label(container, 0);
        this.columnsLabel.setEnabled(false);
        this.columnsLabel.setText("Columns");
        this.rowsLabel = new Label(container, 0);
        this.rowsLabel.setEnabled(false);
        this.rowsLabel.setText("Rows");
        List<TargetPlatform> targetPlatformList = PlatformFactory.getTargetPlatFormList();
        this.userData.put("TARGET_PLATFORM", targetPlatformList.get(0).getId());
        List<GraphicFormat> graphicFormatList = GraphicFormatFactory.getFormatByPrefix(targetPlatformList.get(0).getId());
        this.gf = graphicFormatList.get(0);
        this.userData.put("PROJECT_TYPE", graphicFormatList.get(0).getId().split("_")[1]);
        List<GraphicFormatVariant> graphicFormatVariantList = GraphicFormatFactory.getFormatVariantListByPrefix(graphicFormatList.get(0).getId());
        this.gfv = graphicFormatVariantList.get(0);
        this.userData.put("PROJECT_VARIANT", graphicFormatVariantList.get(0).getId());
        int maxItems = graphicFormatList.get(0).getMaxItems();
        this.userData.put("PROJECT_MAX_ITEMS", maxItems);
        this.maxItemsSpinner.setValues(maxItems, maxItems == -1 ? -1 : 1, maxItems, 0, 1, 1);
        this.projectNameText = new Text(container, 2048);
        this.projectNameText.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyReleased(KeyEvent e) {
                GraphicsProjectWizardPage.this.setText(GraphicsProjectWizardPage.this.projectNameText.getText());
            }
        });
        this.targetPlatformCombo = new ComboViewer(container, 0);
        this.targetPlatformCombo.setContentProvider((IContentProvider)ArrayContentProvider.getInstance());
        this.targetPlatformCombo.setInput(targetPlatformList);
        this.targetPlatformCombo.setSelection((ISelection)new StructuredSelection((Object)targetPlatformList.get(0)));
        this.targetPlatformCombo.setLabelProvider((IBaseLabelProvider)new LabelProvider(){

            public String getText(Object element) {
                if (element instanceof TargetPlatform) {
                    TargetPlatform current = (TargetPlatform)element;
                    return current.getName();
                }
                return super.getText(element);
            }
        });
        this.targetPlatformCombo.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                StructuredSelection selection = (StructuredSelection)event.getSelection();
                TargetPlatform targetPlatform = (TargetPlatform)selection.getFirstElement();
                List<GraphicFormat> l = GraphicFormatFactory.getFormatByPrefix(targetPlatform.getId());
                GraphicsProjectWizardPage.this.gfxFormatCombo.setInput(l);
                if (l.size() > 0) {
                    GraphicsProjectWizardPage.this.gfxFormatCombo.getCombo().setEnabled(true);
                    GraphicsProjectWizardPage.this.gfxFormatCombo.setSelection((ISelection)new StructuredSelection((Object)l.get(0)));
                } else {
                    GraphicsProjectWizardPage.this.gfxFormatCombo.getCombo().setEnabled(false);
                }
            }
        });
        this.gfxFormatCombo = new ComboViewer(container, 0);
        this.gfxFormatCombo.setContentProvider((IContentProvider)ArrayContentProvider.getInstance());
        this.gfxFormatCombo.setInput(graphicFormatList);
        this.gfxFormatCombo.setSelection((ISelection)new StructuredSelection((Object)graphicFormatList.get(0)));
        this.gfxFormatCombo.setLabelProvider((IBaseLabelProvider)new LabelProvider(){

            public String getText(Object element) {
                return ((GraphicFormat)element).getName();
            }
        });
        this.gfxFormatCombo.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                StructuredSelection selection = (StructuredSelection)event.getSelection();
                GraphicsProjectWizardPage.this.gf = (GraphicFormat)selection.getFirstElement();
                GraphicsProjectWizardPage.this.userData.put("PROJECT_TYPE", GraphicsProjectWizardPage.this.gf.getId().split("_")[1]);
                List<GraphicFormatVariant> l = GraphicFormatFactory.getFormatVariantListByPrefix(GraphicsProjectWizardPage.this.gf.getId());
                GraphicsProjectWizardPage.this.gfxFormatVariantCombo.setInput(l);
                GraphicsProjectWizardPage.this.gfxFormatVariantCombo.setSelection((ISelection)new StructuredSelection((Object)l.get(0)));
                int maxItems = GraphicsProjectWizardPage.this.gf.getMaxItems() == -1 ? 1 : GraphicsProjectWizardPage.this.gf.getMaxItems();
                GraphicsProjectWizardPage.this.maxItemsSpinner.setValues(maxItems, 1, maxItems, 0, 1, 16);
                GraphicsProjectWizardPage.this.userData.put("PROJECT_MAX_ITEMS", maxItems);
            }
        });
        this.gfxFormatVariantCombo = new ComboViewer(container, 0);
        this.gfxFormatVariantCombo.setContentProvider((IContentProvider)ArrayContentProvider.getInstance());
        this.gfxFormatVariantCombo.setInput(graphicFormatVariantList);
        this.gfxFormatVariantCombo.setSelection((ISelection)new StructuredSelection((Object)graphicFormatVariantList.get(0)));
        this.gfxFormatVariantCombo.setLabelProvider((IBaseLabelProvider)new LabelProvider(){

            public String getText(Object element) {
                return ((GraphicFormatVariant)element).getName();
            }
        });
        this.gfxFormatVariantCombo.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                StructuredSelection selection = (StructuredSelection)event.getSelection();
                GraphicsProjectWizardPage.this.gfv = (GraphicFormatVariant)selection.getFirstElement();
                GraphicsProjectWizardPage.this.userData.put("PROJECT_VARIANT", GraphicsProjectWizardPage.this.gfv.getId());
                boolean enable = GraphicsProjectWizardPage.this.gfv.getId().equals("CUSTOM");
                boolean isASCII = GraphicsProjectWizardPage.this.gf.getId().matches("^(.*PETSCII|.*SCREENSET)$");
                GraphicsProjectWizardPage.this.widthLabel.setEnabled(enable && isASCII);
                GraphicsProjectWizardPage.this.heightLabel.setEnabled(enable && isASCII);
                GraphicsProjectWizardPage.this.rowsLabel.setEnabled(enable);
                GraphicsProjectWizardPage.this.columnsLabel.setEnabled(enable);
                GraphicsProjectWizardPage.this.tileWidthSpinner.setEnabled(enable && isASCII);
                GraphicsProjectWizardPage.this.tileHeightSpinner.setEnabled(enable && isASCII);
                GraphicsProjectWizardPage.this.tileColumnsSpinner.setEnabled(enable);
                GraphicsProjectWizardPage.this.tileRowsSpinner.setEnabled(enable);
                GraphicsProjectWizardPage.this.setSpinnerValues();
            }
        });
        this.tileWidthSpinner = new Spinner(container, 2048);
        this.tileWidthSpinner.setEnabled(false);
        this.tileWidthSpinner.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                GraphicsProjectWizardPage.this.putSpinnerValues();
            }
        });
        this.tileHeightSpinner = new Spinner(container, 2048);
        this.tileHeightSpinner.setEnabled(false);
        this.tileHeightSpinner.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                GraphicsProjectWizardPage.this.putSpinnerValues();
            }
        });
        this.tileColumnsSpinner = new Spinner(container, 2048);
        this.tileColumnsSpinner.setEnabled(false);
        this.tileColumnsSpinner.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                GraphicsProjectWizardPage.this.putSpinnerValues();
            }
        });
        this.tileRowsSpinner = new Spinner(container, 2048);
        this.tileRowsSpinner.setEnabled(false);
        this.tileRowsSpinner.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                GraphicsProjectWizardPage.this.putSpinnerValues();
            }
        });
        FormData formData = new FormData();
        formData.top = new FormAttachment((Control)container, 0);
        formData.left = new FormAttachment((Control)container, 0);
        this.projectNameLabel.setLayoutData((Object)formData);
        formData = new FormData();
        formData.top = new FormAttachment((Control)this.projectNameLabel, 15, 1024);
        formData.left = new FormAttachment((Control)this.projectNameLabel, 0, 16384);
        this.targetPlatformLabel.setLayoutData((Object)formData);
        formData = new FormData();
        formData.top = new FormAttachment((Control)this.targetPlatformLabel, 15, 1024);
        formData.left = new FormAttachment((Control)this.targetPlatformLabel, 0, 16384);
        this.gfxFormatLabel.setLayoutData((Object)formData);
        formData = new FormData();
        formData.top = new FormAttachment((Control)this.gfxFormatLabel, 15, 1024);
        formData.left = new FormAttachment((Control)this.gfxFormatLabel, 0, 16384);
        this.gfxFormatVariantLabel.setLayoutData((Object)formData);
        formData = new FormData();
        formData.top = new FormAttachment((Control)this.gfxFormatVariantLabel, 15, 1024);
        formData.left = new FormAttachment((Control)this.gfxFormatVariantLabel, 0, 16384);
        this.widthLabel.setLayoutData((Object)formData);
        formData = new FormData();
        formData.top = new FormAttachment((Control)this.widthLabel, 15, 1024);
        formData.left = new FormAttachment((Control)this.widthLabel, 0, 16384);
        this.heightLabel.setLayoutData((Object)formData);
        formData = new FormData();
        formData.top = new FormAttachment((Control)this.heightLabel, 15, 1024);
        formData.left = new FormAttachment((Control)this.heightLabel, 0, 16384);
        this.columnsLabel.setLayoutData((Object)formData);
        formData = new FormData();
        formData.top = new FormAttachment((Control)this.columnsLabel, 15, 1024);
        formData.left = new FormAttachment((Control)this.columnsLabel, 0, 16384);
        this.rowsLabel.setLayoutData((Object)formData);
        formData = new FormData();
        formData.top = new FormAttachment((Control)this.projectNameLabel, 0, 128);
        formData.left = new FormAttachment((Control)container, 140, 131072);
        formData.right = new FormAttachment((Control)container, 300);
        this.projectNameText.setLayoutData((Object)formData);
        formData = new FormData();
        formData.top = new FormAttachment((Control)this.targetPlatformLabel, 0, 128);
        formData.left = new FormAttachment((Control)container, 140, 131072);
        formData.right = new FormAttachment((Control)container, 300);
        this.targetPlatformCombo.getControl().setLayoutData((Object)formData);
        formData = new FormData();
        formData.top = new FormAttachment((Control)this.gfxFormatLabel, 0, 128);
        formData.left = new FormAttachment((Control)container, 140, 131072);
        formData.right = new FormAttachment((Control)container, 300);
        this.gfxFormatCombo.getControl().setLayoutData((Object)formData);
        formData = new FormData();
        formData.top = new FormAttachment((Control)this.gfxFormatVariantLabel, 0, 128);
        formData.left = new FormAttachment((Control)container, 140, 131072);
        formData.right = new FormAttachment((Control)container, 300);
        this.gfxFormatVariantCombo.getControl().setLayoutData((Object)formData);
        formData = new FormData();
        formData.top = new FormAttachment((Control)this.widthLabel, 0, 128);
        formData.left = new FormAttachment((Control)container, 140, 131072);
        formData.right = new FormAttachment((Control)container, 300);
        this.tileWidthSpinner.setLayoutData((Object)formData);
        formData = new FormData();
        formData.top = new FormAttachment((Control)this.heightLabel, 0, 128);
        formData.left = new FormAttachment((Control)container, 140, 131072);
        formData.right = new FormAttachment((Control)container, 300);
        this.tileHeightSpinner.setLayoutData((Object)formData);
        formData = new FormData();
        formData.top = new FormAttachment((Control)this.columnsLabel, 0, 128);
        formData.left = new FormAttachment((Control)container, 140, 131072);
        formData.right = new FormAttachment((Control)container, 300);
        this.tileColumnsSpinner.setLayoutData((Object)formData);
        formData = new FormData();
        formData.top = new FormAttachment((Control)this.rowsLabel, 0, 128);
        formData.left = new FormAttachment((Control)container, 140, 131072);
        formData.right = new FormAttachment((Control)container, 300);
        this.tileRowsSpinner.setLayoutData((Object)formData);
        formData = new FormData();
        formData.top = new FormAttachment((Control)this.rowsLabel, 15, 1024);
        formData.left = new FormAttachment(0, 0);
        formData.right = new FormAttachment(100, 0);
        this.separatorLabel.setLayoutData((Object)formData);
        formData = new FormData();
        formData.top = new FormAttachment((Control)this.separatorLabel, 15, 1024);
        formData.left = new FormAttachment((Control)this.separatorLabel, 0, 16384);
        this.maxItemsLabel.setLayoutData((Object)formData);
        formData = new FormData();
        formData.top = new FormAttachment((Control)this.maxItemsLabel, 0, 128);
        formData.left = new FormAttachment((Control)container, 140, 131072);
        formData.right = new FormAttachment((Control)container, 300);
        this.maxItemsSpinner.setLayoutData((Object)formData);
        this.setSpinnerValues();
    }

    private void setSpinnerValues() {
        this.tileWidthSpinner.setValues(this.gf.getWidth(), 1, 1000, 0, 1, 1);
        this.tileHeightSpinner.setValues(this.gf.getHeight(), 1, 1000, 0, 1, 1);
        this.tileColumnsSpinner.setValues(this.gfv.getTileColumns(), 1, 1000, 0, 1, 1);
        this.tileRowsSpinner.setValues(this.gfv.getTileRows(), 1, 1000, 0, 1, 1);
        this.userData.put("width", this.tileWidthSpinner.getSelection());
        this.userData.put("height", this.tileHeightSpinner.getSelection());
        this.userData.put("columns", this.tileColumnsSpinner.getSelection());
        this.userData.put("rows", this.tileRowsSpinner.getSelection());
    }

    private void putSpinnerValues() {
        this.userData.put("width", this.tileWidthSpinner.getSelection());
        this.userData.put("height", this.tileHeightSpinner.getSelection());
        this.userData.put("columns", this.tileColumnsSpinner.getSelection());
        this.userData.put("rows", this.tileRowsSpinner.getSelection());
    }

    private void setText(String fileName) {
        this.userData.put("PROJECT_ID", this.projectNameText.getText().toUpperCase());
        this.userData.put("PROJECT_NAME", this.projectNameText.getText());
        this.setPageComplete(!this.projectNameText.getText().isEmpty());
    }

    public void setVisible(boolean visible) {
        String fileName;
        super.setVisible(visible);
        if (visible && (fileName = FilenameUtils.getBaseName((String)((String)this.userData.get("FILE_NAME")))) != null && !fileName.equals("")) {
            this.projectNameText.setText(fileName);
            this.setText(fileName);
        }
    }
}

