/*
 * Decompiled with CFR 0.152.
 */
package de.drazil.nerdsuite.wizard;

import com.fasterxml.jackson.databind.ObjectMapper;
import de.drazil.nerdsuite.model.ProgrammingLanguage;
import de.drazil.nerdsuite.model.ProjectFolder;
import de.drazil.nerdsuite.model.SimpleEntity;
import de.drazil.nerdsuite.model.TargetPlatform;
import de.drazil.nerdsuite.validator.IValidatable;
import de.drazil.nerdsuite.widget.PlatformFactory;
import de.drazil.nerdsuite.widget.ProjectTypeFactory;
import de.drazil.nerdsuite.wizard.AbstractBoundWizardPage;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.io.FilenameUtils;
import org.eclipse.core.databinding.AggregateValidationStatus;
import org.eclipse.core.databinding.observable.ChangeEvent;
import org.eclipse.core.databinding.observable.IChangeListener;
import org.eclipse.core.databinding.observable.IObservableCollection;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.osgi.framework.Bundle;

public class CodingProjectWizardPage
extends AbstractBoundWizardPage {
    private boolean enableAssembler = false;
    private Label projectNameLabel;
    private Label targetPlatformLabel;
    private Label languageTypeLabel;
    private Label assemblerLabel;
    private Label separatorLabel;
    private Label basePathLabel;
    private Label sourcePathLabel;
    private Label binaryPathLabel;
    private Label includePathLabel;
    private Label symbolPathLabel;
    private Text projectNameText;
    private Text basePathText;
    private Text sourcePathText;
    private Text binaryPathText;
    private Text includePathText;
    private Text symbolPathText;
    private ComboViewer targetPlatformCombo;
    private ComboViewer languageTypeCombo;
    private ComboViewer builderCombo;
    private Button createExampleButton;
    private SimpleEntity projectType;
    private List<TargetPlatform> targetPlatformList;
    private List<ProgrammingLanguage> programmingLanguageList;

    public CodingProjectWizardPage(Map<String, Object> userData) {
        super("wizardPage", userData);
        this.projectType = ProjectTypeFactory.getProjectTypeByName((String)userData.get("PROJECT_TYPE_ID"));
        this.setTitle("Create new " + this.projectType.getName());
        this.setDescription("Please enter a Project Name");
    }

    public void createControl(Composite parent) {
        Composite container = new Composite(parent, 0);
        this.setControl((Control)container);
        container.setLayout((Layout)new FormLayout());
        this.projectNameLabel = new Label(container, 0);
        this.projectNameLabel.setText("Project Name");
        this.targetPlatformLabel = new Label(container, 0);
        this.targetPlatformLabel.setText("Target Platform");
        this.languageTypeLabel = new Label(container, 0);
        this.languageTypeLabel.setText("Coding Language");
        this.assemblerLabel = new Label(container, 0);
        this.assemblerLabel.setText("Assembler/Compiler");
        this.assemblerLabel.setEnabled(this.enableAssembler);
        List<TargetPlatform> targetPlatformList = PlatformFactory.getTargetPlatFormList();
        this.userData.put("TARGET_PLATFORM", targetPlatformList.get(0).getId());
        List<ProgrammingLanguage> programmingLanguageList = this.getProgrammingLanguageList(targetPlatformList.get(0));
        String[] s = programmingLanguageList.get(0).getId().split("_");
        String type = "";
        if (s.length == 3) {
            type = s[1];
            this.userData.put("PROJECT_TYPE", s[1]);
            this.userData.put("PROJECT_VARIANT", s[2]);
        } else {
            int cfr_ignored_0 = s.length;
        }
        List<SimpleEntity> builderList = programmingLanguageList.get(0).getBuilder();
        if (builderList != null) {
            this.userData.put("PROJECT_VARIANT", builderList.get(0).getId());
        }
        this.createExampleButton = new Button(container, 32);
        this.createExampleButton.setText("Create example file");
        this.createExampleButton.setEnabled(programmingLanguageList.get(0).isSupportsExampleFile());
        this.projectNameText = new Text(container, 2048);
        this.projectNameText.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyReleased(KeyEvent e) {
                CodingProjectWizardPage.this.setText(CodingProjectWizardPage.this.projectNameText.getText());
            }
        });
        this.targetPlatformCombo = new ComboViewer(container, 0);
        this.targetPlatformCombo.setContentProvider((IContentProvider)ArrayContentProvider.getInstance());
        this.targetPlatformCombo.setInput(targetPlatformList);
        this.targetPlatformCombo.setSelection((ISelection)new StructuredSelection((Object)targetPlatformList.get(0)));
        this.targetPlatformCombo.setLabelProvider((IBaseLabelProvider)new LabelProvider(){

            public String getText(Object element) {
                if (element instanceof TargetPlatform) {
                    TargetPlatform current = (TargetPlatform)element;
                    return current.getName();
                }
                return super.getText(element);
            }
        });
        this.targetPlatformCombo.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                StructuredSelection selection = (StructuredSelection)event.getSelection();
                TargetPlatform targetPlatform = (TargetPlatform)selection.getFirstElement();
                List<ProgrammingLanguage> l = CodingProjectWizardPage.this.getProgrammingLanguageList(targetPlatform);
                CodingProjectWizardPage.this.languageTypeCombo.setInput(l);
                if (l.size() > 0) {
                    CodingProjectWizardPage.this.languageTypeCombo.getCombo().setEnabled(true);
                    CodingProjectWizardPage.this.languageTypeCombo.setSelection((ISelection)new StructuredSelection((Object)l.get(0)));
                } else {
                    CodingProjectWizardPage.this.languageTypeCombo.getCombo().setEnabled(false);
                }
            }
        });
        this.languageTypeCombo = new ComboViewer(container, 0);
        this.languageTypeCombo.setContentProvider((IContentProvider)ArrayContentProvider.getInstance());
        this.languageTypeCombo.setInput(programmingLanguageList);
        this.languageTypeCombo.setSelection((ISelection)new StructuredSelection((Object)programmingLanguageList.get(0)));
        this.languageTypeCombo.setLabelProvider((IBaseLabelProvider)new LabelProvider(){

            public String getText(Object element) {
                if (element instanceof ProgrammingLanguage) {
                    ProgrammingLanguage current = (ProgrammingLanguage)element;
                    return current.getName();
                }
                return super.getText(element);
            }
        });
        this.languageTypeCombo.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                StructuredSelection selection = (StructuredSelection)event.getSelection();
                ProgrammingLanguage subType = (ProgrammingLanguage)selection.getFirstElement();
                CodingProjectWizardPage.this.createExampleButton.setEnabled(subType.isSupportsExampleFile());
            }
        });
        this.builderCombo = new ComboViewer(container, 0);
        this.builderCombo.getCombo().setEnabled(this.enableAssembler);
        this.builderCombo.setContentProvider((IContentProvider)ArrayContentProvider.getInstance());
        this.builderCombo.setLabelProvider((IBaseLabelProvider)new LabelProvider(){

            public String getText(Object element) {
                if (element instanceof SimpleEntity) {
                    SimpleEntity current = (SimpleEntity)element;
                    return current.getName();
                }
                return super.getText(element);
            }
        });
        this.builderCombo.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                StructuredSelection selection = (StructuredSelection)event.getSelection();
                SimpleEntity subType = (SimpleEntity)selection.getFirstElement();
                CodingProjectWizardPage.this.userData.put("PROJECT_VARIANT", subType.getId());
            }
        });
        this.separatorLabel = new Label(container, 258);
        this.basePathLabel = new Label(container, 0);
        this.basePathLabel.setText("Base Path");
        this.sourcePathLabel = new Label(container, 0);
        this.sourcePathLabel.setText("Source Path");
        this.binaryPathLabel = new Label(container, 0);
        this.binaryPathLabel.setText("Binary Path");
        this.includePathLabel = new Label(container, 0);
        this.includePathLabel.setText("Include Path");
        this.symbolPathLabel = new Label(container, 0);
        this.symbolPathLabel.setText("Symbol Path");
        this.basePathText = new Text(container, 2048);
        this.basePathText.setEditable(false);
        this.sourcePathText = new Text(container, 2048);
        this.binaryPathText = new Text(container, 2048);
        this.includePathText = new Text(container, 2048);
        this.symbolPathText = new Text(container, 2048);
        FormData formData = new FormData();
        formData.top = new FormAttachment((Control)container, 0);
        formData.left = new FormAttachment((Control)container, 0);
        this.projectNameLabel.setLayoutData((Object)formData);
        formData = new FormData();
        formData.top = new FormAttachment((Control)this.projectNameLabel, 15, 1024);
        formData.left = new FormAttachment((Control)this.projectNameLabel, 0, 16384);
        this.targetPlatformLabel.setLayoutData((Object)formData);
        formData = new FormData();
        formData.top = new FormAttachment((Control)this.targetPlatformLabel, 15, 1024);
        formData.left = new FormAttachment((Control)this.targetPlatformLabel, 0, 16384);
        this.languageTypeLabel.setLayoutData((Object)formData);
        formData = new FormData();
        formData.top = new FormAttachment((Control)this.languageTypeLabel, 15, 1024);
        formData.left = new FormAttachment((Control)this.languageTypeLabel, 0, 16384);
        this.assemblerLabel.setLayoutData((Object)formData);
        formData = new FormData();
        formData.top = new FormAttachment((Control)this.projectNameLabel, 0, 128);
        formData.left = new FormAttachment((Control)container, 140, 131072);
        formData.right = new FormAttachment((Control)container, 300);
        this.projectNameText.setLayoutData((Object)formData);
        formData = new FormData();
        formData.top = new FormAttachment((Control)this.targetPlatformLabel, 0, 128);
        formData.left = new FormAttachment((Control)container, 140, 131072);
        formData.right = new FormAttachment((Control)container, 300);
        this.targetPlatformCombo.getControl().setLayoutData((Object)formData);
        formData = new FormData();
        formData.top = new FormAttachment((Control)this.languageTypeLabel, 0, 128);
        formData.left = new FormAttachment((Control)container, 140, 131072);
        formData.right = new FormAttachment((Control)container, 300);
        this.languageTypeCombo.getControl().setLayoutData((Object)formData);
        formData = new FormData();
        formData.top = new FormAttachment((Control)this.assemblerLabel, 0, 128);
        formData.left = new FormAttachment((Control)container, 140, 131072);
        formData.right = new FormAttachment((Control)container, 300);
        this.builderCombo.getControl().setLayoutData((Object)formData);
        formData = new FormData();
        formData.top = new FormAttachment(this.builderCombo.getControl(), 10, 1024);
        formData.left = new FormAttachment(this.builderCombo.getControl(), 0, 16384);
        this.createExampleButton.setLayoutData((Object)formData);
        formData = new FormData();
        formData.top = new FormAttachment((Control)this.createExampleButton, 15, 1024);
        formData.left = new FormAttachment(0, 0);
        formData.right = new FormAttachment(140, 0);
        this.separatorLabel.setLayoutData((Object)formData);
        formData = new FormData();
        formData.top = new FormAttachment((Control)this.separatorLabel, 15, 1024);
        formData.left = new FormAttachment((Control)this.separatorLabel, 0, 16384);
        this.basePathLabel.setLayoutData((Object)formData);
        formData = new FormData();
        formData.top = new FormAttachment((Control)this.basePathLabel, 15, 1024);
        formData.left = new FormAttachment((Control)this.basePathLabel, 0, 16384);
        this.sourcePathLabel.setLayoutData((Object)formData);
        formData = new FormData();
        formData.top = new FormAttachment((Control)this.sourcePathLabel, 15, 1024);
        formData.left = new FormAttachment((Control)this.sourcePathLabel, 0, 16384);
        this.binaryPathLabel.setLayoutData((Object)formData);
        formData = new FormData();
        formData.top = new FormAttachment((Control)this.binaryPathLabel, 15, 1024);
        formData.left = new FormAttachment((Control)this.binaryPathLabel, 0, 16384);
        this.includePathLabel.setLayoutData((Object)formData);
        formData = new FormData();
        formData.top = new FormAttachment((Control)this.includePathLabel, 15, 1024);
        formData.left = new FormAttachment((Control)this.includePathLabel, 0, 16384);
        this.symbolPathLabel.setLayoutData((Object)formData);
        formData = new FormData();
        formData.top = new FormAttachment((Control)this.basePathLabel, 0, 128);
        formData.left = new FormAttachment((Control)container, 140, 131072);
        formData.right = new FormAttachment((Control)container, 300);
        this.basePathText.setLayoutData((Object)formData);
        formData = new FormData();
        formData.top = new FormAttachment((Control)this.sourcePathLabel, 0, 128);
        formData.left = new FormAttachment((Control)container, 140, 131072);
        formData.right = new FormAttachment((Control)container, 300);
        this.sourcePathText.setLayoutData((Object)formData);
        formData = new FormData();
        formData.top = new FormAttachment((Control)this.binaryPathLabel, 0, 128);
        formData.left = new FormAttachment((Control)container, 140, 131072);
        formData.right = new FormAttachment((Control)container, 300);
        this.binaryPathText.setLayoutData((Object)formData);
        formData = new FormData();
        formData.top = new FormAttachment((Control)this.includePathLabel, 0, 128);
        formData.left = new FormAttachment((Control)container, 140, 131072);
        formData.right = new FormAttachment((Control)container, 300);
        this.includePathText.setLayoutData((Object)formData);
        formData = new FormData();
        formData.top = new FormAttachment((Control)this.symbolPathLabel, 0, 128);
        formData.left = new FormAttachment((Control)container, 140, 131072);
        formData.right = new FormAttachment((Control)container, 300);
        this.symbolPathText.setLayoutData((Object)formData);
        this.initDataBindings();
    }

    protected void initDataBindings() {
    }

    private Optional<ProjectFolder> getFolder(List<ProjectFolder> folderList, String folderName) {
        return folderList.stream().filter(c -> c.getId().equals(folderName)).findFirst();
    }

    private List<TargetPlatform> getTargetPlatFormList() {
        Bundle bundle = Platform.getBundle((String)"de.drazil.nerdsuite");
        ObjectMapper mapper = new ObjectMapper();
        try {
            this.targetPlatformList = Arrays.asList((TargetPlatform[])mapper.readValue(bundle.getEntry("configuration/platform.json"), TargetPlatform[].class)).stream().filter(c -> c.isEnabled()).collect(Collectors.toList());
        }
        catch (Exception e) {
            this.targetPlatformList = null;
        }
        return this.targetPlatformList;
    }

    private List<ProgrammingLanguage> getProgrammingLanguageList(TargetPlatform targetPlatform) {
        Bundle bundle = Platform.getBundle((String)"de.drazil.nerdsuite");
        ObjectMapper mapper = new ObjectMapper();
        try {
            this.programmingLanguageList = Arrays.asList((ProgrammingLanguage[])mapper.readValue(bundle.getEntry("configuration/programming_languages.json"), ProgrammingLanguage[].class)).stream().filter(c -> c.getId().startsWith(targetPlatform.getId())).collect(Collectors.toList());
        }
        catch (Exception e) {
            this.programmingLanguageList = null;
        }
        return this.programmingLanguageList;
    }

    private void setText(String fileName) {
        this.userData.put("PROJECT_ID", this.projectNameText.getText().toUpperCase());
        this.userData.put("PROJECT_NAME", this.projectNameText.getText());
        this.setPageComplete(!this.projectNameText.getText().isEmpty());
    }

    public void setVisible(boolean visible) {
        String fileName;
        super.setVisible(visible);
        if (visible && (fileName = FilenameUtils.getBaseName((String)((String)this.userData.get("FILE_NAME")))) != null && !fileName.equals("")) {
            this.projectNameText.setText(fileName);
            this.setText(fileName);
        }
    }

    private static class AggregatedValidationChangeListener
    implements IChangeListener {
        private IObservableCollection oc;
        IValidatable validatable;

        public AggregatedValidationChangeListener(IObservableCollection oc, IValidatable validatable) {
            this.setOc(oc);
            this.setValidatable(validatable);
        }

        public void handleChange(ChangeEvent event) {
            AggregateValidationStatus as = (AggregateValidationStatus)event.getSource();
            as.getValue();
            this.validatable.setValidated(AggregateValidationStatus.getStatusMerged((Collection)this.getOc()).isOK());
        }

        public void setOc(IObservableCollection oc) {
            this.oc = oc;
        }

        public IObservableCollection getOc() {
            return this.oc;
        }

        public void setValidatable(IValidatable validatable) {
            this.validatable = validatable;
        }

        public IValidatable getValidatable() {
            return this.validatable;
        }
    }
}

