/*
 * Decompiled with CFR 0.152.
 */
package de.drazil.nerdsuite.widget;

import com.fasterxml.jackson.databind.ObjectMapper;
import de.drazil.nerdsuite.Constants;
import de.drazil.nerdsuite.model.Key;
import de.drazil.nerdsuite.model.KeyMatrix;
import de.drazil.nerdsuite.model.KeyRow;
import de.drazil.nerdsuite.model.PlatformColor;
import de.drazil.nerdsuite.widget.IHitKeyListener;
import de.drazil.nerdsuite.widget.KeyboardElement;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.Platform;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Composite;
import org.osgi.framework.Bundle;

public class VirtualKeyboard
extends Composite
implements IHitKeyListener {
    private List<PlatformColor> colorList;
    private List<IHitKeyListener> list;
    private int optionState;
    private KeyMatrix matrix = null;
    private List<KeyboardElement> keyList;

    public VirtualKeyboard(Composite parent, int style, List<PlatformColor> colorList) {
        super(parent, style);
        this.colorList = colorList;
        this.list = new ArrayList<IHitKeyListener>();
        this.keyList = new ArrayList<KeyboardElement>();
        this.setBackground(Constants.GREY3);
        this.initLayout();
    }

    public void initLayout() {
        Bundle bundle = Platform.getBundle((String)"de.drazil.nerdsuite");
        ObjectMapper mapper = new ObjectMapper();
        try {
            this.matrix = (KeyMatrix)mapper.readValue(bundle.getEntry("configuration/keyboard_layout.json"), KeyMatrix.class);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.setLayout(null);
        int y = 0;
        int s = 30;
        int index = 0;
        for (KeyRow row : this.matrix.getKeyRows()) {
            int x = 0;
            for (Key key : row.getKeys()) {
                key.setId(index);
                KeyboardElement ke = new KeyboardElement(this, 0, key, this.colorList);
                this.keyList.add(ke);
                ke.addHitKeyListener(this);
                Point p = ke.getDimension();
                ke.setBounds(x, y, p.x, p.y);
                x += ke.getDimension().x;
                ++index;
            }
            y += s;
        }
    }

    @Override
    public void keyPressed(Key key) {
        this.fireHitKey(key);
    }

    public Point computeSize(int wHint, int hHint, boolean changed) {
        return new Point(750, 210);
    }

    public void addHitKeyListener(IHitKeyListener listener) {
        this.list.add(listener);
    }

    public void removeHitKeyListener(IHitKeyListener listener) {
        this.list.remove(listener);
    }

    private void fireHitKey(Key key) {
        if (key.getType().equals("OPTION")) {
            if (key.isToggleState()) {
                key.setOptionState(1);
                this.optionState |= key.getIndex().intValue();
            } else {
                this.optionState &= (key.getIndex() ^ 0xFF) & 0xFF;
                key.setOptionState(0);
            }
            System.out.printf("%d\n", this.optionState);
            for (KeyRow row : this.matrix.getKeyRows()) {
                for (Key k2 : row.getKeys()) {
                    if (!k2.getType().equals("KEY") && !k2.getType().equals("COLOR")) continue;
                    k2.setOptionState(this.optionState);
                    this.keyList.get(k2.getId()).redraw();
                }
            }
        }
        this.list.forEach(k -> k.keyPressed(key));
    }
}

