/*
 * Decompiled with CFR 0.152.
 */
package de.drazil.nerdsuite.widget;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import de.drazil.nerdsuite.enums.RedrawMode;
import de.drazil.nerdsuite.imaging.service.ITileManagementListener;
import de.drazil.nerdsuite.imaging.service.ITileUpdateListener;
import de.drazil.nerdsuite.model.GraphicMetadata;
import de.drazil.nerdsuite.widget.Tile;
import java.util.ArrayList;
import java.util.List;

public class TileContainer {
    @JsonProperty(value="metadata")
    private GraphicMetadata metadata = null;
    @JsonProperty(value="tiles")
    private List<Tile> tileList = null;
    @JsonProperty(value="tileIndexOrder")
    private List<Integer> tileIndexOrderList = null;
    @JsonProperty(value="selectedTiles")
    private List<Integer> selectedTileIndexList = null;
    @JsonIgnore
    private List<ITileManagementListener> tileServiceManagementListener = null;
    @JsonIgnore
    private List<ITileUpdateListener> tileUpdateListener = null;
    @JsonIgnore
    private int tileSize;

    public TileContainer() {
        this.tileServiceManagementListener = new ArrayList<ITileManagementListener>();
        this.tileUpdateListener = new ArrayList<ITileUpdateListener>();
    }

    public void setMetadata(GraphicMetadata metadata) {
        this.metadata = metadata;
        this.tileSize = metadata.getWidth() * metadata.getHeight() * metadata.getColumns() * metadata.getRows();
    }

    @JsonIgnore
    public void addInitialTiles(int tileCount) {
        this.initList();
        int i = 0;
        while (i < tileCount) {
            this.addTile();
            ++i;
        }
        this.setSelectedTileIndex(0);
    }

    private void initList() {
        if (this.tileList == null) {
            this.tileList = new ArrayList<Tile>();
        }
        if (this.tileIndexOrderList == null) {
            this.tileIndexOrderList = new ArrayList<Integer>();
        }
        if (this.selectedTileIndexList == null) {
            this.selectedTileIndexList = new ArrayList<Integer>();
        }
    }

    @JsonIgnore
    public Tile addTile() {
        this.initList();
        String id = String.format("T%03X", this.getTileList().size() + 1);
        Integer blankValue = this.metadata.getBlankValue();
        return this.addTile(id, id, this.tileSize, blankValue);
    }

    @JsonIgnore
    private Tile addTile(String id, String name, int tileSize, Integer defaultBrush) {
        this.initList();
        Tile tile = new Tile(id, name, tileSize);
        String layerId = String.format("L%03X", this.getTileList().size() + 1, tile.getSize() + 1);
        tile.addLayer(layerId, layerId, tileSize, defaultBrush);
        this.getTileList().add(tile);
        this.getTileIndexOrderList().add(this.getTileList().indexOf(tile));
        this.fireTileAdded();
        return tile;
    }

    @JsonIgnore
    public void removeLast() {
        if (this.getTileIndexOrderList().size() > 0) {
            ArrayList<Integer> l = new ArrayList<Integer>();
            l.add(this.getTileIndexOrderList().size() - 1);
            this.removeTile(l);
        }
    }

    @JsonIgnore
    public void removeSelected() {
        this.removeTile(this.getSelectedTileIndexList());
    }

    @JsonIgnore
    public void removeTile(List<Integer> tileIndexList) {
        if (this.getTileIndexOrderList().size() > 0) {
            int i = 0;
            while (i < tileIndexList.size()) {
                int tileIndex = this.getTileIndexOrderList().get(i);
                this.getTileList().remove(tileIndex);
                this.getTileIndexOrderList().remove(i);
                ++i;
            }
            this.fireTileRemoved();
        }
    }

    @JsonIgnore
    public void moveTile(int from, int to) {
        int v = this.getTileIndexOrderList().get(from);
        if (to < from) {
            this.getTileIndexOrderList().remove(from);
            this.getTileIndexOrderList().add(to, v);
        } else {
            this.getTileIndexOrderList().add(to, v);
            this.getTileIndexOrderList().remove(from);
        }
        this.fireTileReordered();
    }

    @JsonIgnore
    public int getTileIndex(int index) {
        return this.getTileIndexOrderList().get(index);
    }

    @JsonIgnore
    public void setSelectedTileIndex(int index) {
        if (index != -1) {
            this.initList();
            this.getSelectedTileIndexList().clear();
            this.getSelectedTileIndexList().add(index);
            this.fireTileRedraw(this.getSelectedTileIndexList(), 1, false);
        }
    }

    @JsonIgnore
    public void setSelectedTileIndexList(List<Integer> tileIndexList) {
        this.selectedTileIndexList = tileIndexList;
        this.fireTileRedraw(tileIndexList, 1, false);
    }

    @JsonIgnore
    public List<Integer> getSelectedTileIndexList() {
        return this.selectedTileIndexList;
    }

    @JsonIgnore
    public Tile getSelectedTile() {
        return this.getTile(this.getSelectedTileIndex(false));
    }

    @JsonIgnore
    public int getSelectedTileIndex(boolean natural) {
        int index = 1;
        index = natural ? this.tileList.indexOf(this.getSelectedTile()) : this.getSelectedTileIndexList().get(0).intValue();
        return index;
    }

    @JsonIgnore
    public void resetActiveLayer(int index) {
        this.getTile(index).getActiveLayer().reset(0, 0);
    }

    @JsonIgnore
    public Tile getTile(int index) {
        return this.getTile(index, false);
    }

    @JsonIgnore
    public Tile getTile(int index, boolean naturalOrder) {
        return this.getTileList().get(naturalOrder ? index : this.getTileIndexOrderList().get(index));
    }

    @JsonIgnore
    public int getSize() {
        return this.getTileList().size();
    }

    @JsonIgnore
    public void setDirty(boolean dirty) {
        this.getSelectedTile().setDirty(dirty);
        this.fireTileRedraw(this.getSelectedTileIndexList(), -1, false);
    }

    @JsonIgnore
    private void fireTileAdded() {
        this.tileServiceManagementListener.forEach(listener -> listener.tileAdded(this.getSelectedTile()));
    }

    @JsonIgnore
    public void addTileManagementListener(ITileManagementListener listener) {
        this.tileServiceManagementListener.add(listener);
    }

    @JsonIgnore
    public void removeTileManagementListener(ITileManagementListener listener) {
        this.tileServiceManagementListener.remove(listener);
    }

    @JsonIgnore
    private void fireTileRemoved() {
        this.tileServiceManagementListener.forEach(listener -> listener.tileRemoved());
    }

    @JsonIgnore
    private void fireTileReordered() {
        this.tileServiceManagementListener.forEach(listener -> listener.tileReordered());
    }

    @JsonIgnore
    public void addTileManagementListener(ITileManagementListener ... listeners) {
        ITileManagementListener[] iTileManagementListenerArray = listeners;
        int n = listeners.length;
        int n2 = 0;
        while (n2 < n) {
            ITileManagementListener listener = iTileManagementListenerArray[n2];
            this.addTileManagementListener(listener);
            ++n2;
        }
    }

    @JsonIgnore
    public void addTileUpdateListener(ITileUpdateListener ... listeners) {
        ITileUpdateListener[] iTileUpdateListenerArray = listeners;
        int n = listeners.length;
        int n2 = 0;
        while (n2 < n) {
            ITileUpdateListener listener = iTileUpdateListenerArray[n2];
            this.addTileUpdateListener(listener);
            ++n2;
        }
    }

    @JsonIgnore
    public void addTileUpdateListener(ITileUpdateListener listener) {
        this.tileUpdateListener.add(listener);
    }

    @JsonIgnore
    public void removeTileUpdateListener(ITileUpdateListener listener) {
        this.tileUpdateListener.remove(listener);
    }

    @JsonIgnore
    private void fireTileRedraw(List<Integer> selectedTileIndexList, int action, boolean temporary) {
        if (selectedTileIndexList != null) {
            if (selectedTileIndexList.size() == 1) {
                this.tileUpdateListener.forEach(listener -> listener.redrawTiles(selectedTileIndexList, temporary ? RedrawMode.DrawTemporarySelectedTile : RedrawMode.DrawSelectedTile, action));
            } else {
                this.tileUpdateListener.forEach(listener -> listener.redrawTiles(selectedTileIndexList, RedrawMode.DrawSelectedTiles, action));
            }
        }
    }

    @JsonIgnore
    public void redrawTileViewer(List<Integer> selectedTileIndexList, int action, boolean temporary) {
        this.fireTileRedraw(selectedTileIndexList, action, temporary);
    }

    public GraphicMetadata getMetadata() {
        return this.metadata;
    }

    public List<Tile> getTileList() {
        return this.tileList;
    }

    public List<Integer> getTileIndexOrderList() {
        return this.tileIndexOrderList;
    }

    public List<ITileManagementListener> getTileServiceManagementListener() {
        return this.tileServiceManagementListener;
    }

    public List<ITileUpdateListener> getTileUpdateListener() {
        return this.tileUpdateListener;
    }

    public int getTileSize() {
        return this.tileSize;
    }

    @JsonProperty(value="tiles")
    public void setTileList(List<Tile> tileList) {
        this.tileList = tileList;
    }

    @JsonProperty(value="tileIndexOrder")
    public void setTileIndexOrderList(List<Integer> tileIndexOrderList) {
        this.tileIndexOrderList = tileIndexOrderList;
    }

    @JsonIgnore
    public void setTileServiceManagementListener(List<ITileManagementListener> tileServiceManagementListener) {
        this.tileServiceManagementListener = tileServiceManagementListener;
    }

    @JsonIgnore
    public void setTileUpdateListener(List<ITileUpdateListener> tileUpdateListener) {
        this.tileUpdateListener = tileUpdateListener;
    }

    @JsonIgnore
    public void setTileSize(int tileSize) {
        this.tileSize = tileSize;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TileContainer)) {
            return false;
        }
        TileContainer other = (TileContainer)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getTileSize() != other.getTileSize()) {
            return false;
        }
        GraphicMetadata this$metadata = this.getMetadata();
        GraphicMetadata other$metadata = other.getMetadata();
        if (this$metadata == null ? other$metadata != null : !((Object)this$metadata).equals(other$metadata)) {
            return false;
        }
        List<Tile> this$tileList = this.getTileList();
        List<Tile> other$tileList = other.getTileList();
        if (this$tileList == null ? other$tileList != null : !((Object)this$tileList).equals(other$tileList)) {
            return false;
        }
        List<Integer> this$tileIndexOrderList = this.getTileIndexOrderList();
        List<Integer> other$tileIndexOrderList = other.getTileIndexOrderList();
        if (this$tileIndexOrderList == null ? other$tileIndexOrderList != null : !((Object)this$tileIndexOrderList).equals(other$tileIndexOrderList)) {
            return false;
        }
        List<Integer> this$selectedTileIndexList = this.getSelectedTileIndexList();
        List<Integer> other$selectedTileIndexList = other.getSelectedTileIndexList();
        if (this$selectedTileIndexList == null ? other$selectedTileIndexList != null : !((Object)this$selectedTileIndexList).equals(other$selectedTileIndexList)) {
            return false;
        }
        List<ITileManagementListener> this$tileServiceManagementListener = this.getTileServiceManagementListener();
        List<ITileManagementListener> other$tileServiceManagementListener = other.getTileServiceManagementListener();
        if (this$tileServiceManagementListener == null ? other$tileServiceManagementListener != null : !((Object)this$tileServiceManagementListener).equals(other$tileServiceManagementListener)) {
            return false;
        }
        List<ITileUpdateListener> this$tileUpdateListener = this.getTileUpdateListener();
        List<ITileUpdateListener> other$tileUpdateListener = other.getTileUpdateListener();
        return !(this$tileUpdateListener == null ? other$tileUpdateListener != null : !((Object)this$tileUpdateListener).equals(other$tileUpdateListener));
    }

    protected boolean canEqual(Object other) {
        return other instanceof TileContainer;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getTileSize();
        GraphicMetadata $metadata = this.getMetadata();
        result = result * 59 + ($metadata == null ? 43 : ((Object)$metadata).hashCode());
        List<Tile> $tileList = this.getTileList();
        result = result * 59 + ($tileList == null ? 43 : ((Object)$tileList).hashCode());
        List<Integer> $tileIndexOrderList = this.getTileIndexOrderList();
        result = result * 59 + ($tileIndexOrderList == null ? 43 : ((Object)$tileIndexOrderList).hashCode());
        List<Integer> $selectedTileIndexList = this.getSelectedTileIndexList();
        result = result * 59 + ($selectedTileIndexList == null ? 43 : ((Object)$selectedTileIndexList).hashCode());
        List<ITileManagementListener> $tileServiceManagementListener = this.getTileServiceManagementListener();
        result = result * 59 + ($tileServiceManagementListener == null ? 43 : ((Object)$tileServiceManagementListener).hashCode());
        List<ITileUpdateListener> $tileUpdateListener = this.getTileUpdateListener();
        result = result * 59 + ($tileUpdateListener == null ? 43 : ((Object)$tileUpdateListener).hashCode());
        return result;
    }

    public String toString() {
        return "TileContainer(metadata=" + this.getMetadata() + ", tileList=" + this.getTileList() + ", tileIndexOrderList=" + this.getTileIndexOrderList() + ", selectedTileIndexList=" + this.getSelectedTileIndexList() + ", tileServiceManagementListener=" + this.getTileServiceManagementListener() + ", tileUpdateListener=" + this.getTileUpdateListener() + ", tileSize=" + this.getTileSize() + ")";
    }

    public TileContainer(GraphicMetadata metadata, List<Tile> tileList, List<Integer> tileIndexOrderList, List<Integer> selectedTileIndexList, List<ITileManagementListener> tileServiceManagementListener, List<ITileUpdateListener> tileUpdateListener, int tileSize) {
        this.metadata = metadata;
        this.tileList = tileList;
        this.tileIndexOrderList = tileIndexOrderList;
        this.selectedTileIndexList = selectedTileIndexList;
        this.tileServiceManagementListener = tileServiceManagementListener;
        this.tileUpdateListener = tileUpdateListener;
        this.tileSize = tileSize;
    }
}

