/*
 * Decompiled with CFR 0.152.
 */
package de.drazil.nerdsuite.widget;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import de.drazil.nerdsuite.model.DirtyableImage;
import de.drazil.nerdsuite.widget.ITileListener;
import de.drazil.nerdsuite.widget.Layer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.swt.graphics.Point;

public class Tile {
    @JsonProperty(value="id")
    private String id = null;
    @JsonProperty(value="name")
    private String name = null;
    @JsonProperty(value="showOnlyActiveLayer")
    private boolean showOnlyActiveLayer = true;
    @JsonProperty(value="showInactiveLayerTranslucent")
    private boolean showInactiveLayerTranslucent = false;
    @JsonProperty(value="multicolor")
    private boolean multicolorEnabled = false;
    @JsonProperty(value="backgroundColor")
    private int backgroundColorIndex = 0;
    @JsonProperty(value="originX")
    private int originX;
    @JsonProperty(value="originY")
    private int originY;
    @JsonProperty(value="deleted")
    private boolean deleted = false;
    @JsonProperty(value="layers")
    private List<Layer> layerList = new ArrayList<Layer>();
    @JsonProperty(value="layerIndexOrder")
    private List<Integer> layerIndexOrderList = new ArrayList<Integer>();
    @JsonIgnore
    private List<ITileListener> tileListenerList = null;
    @JsonIgnore
    private int size;
    @JsonIgnore
    private Map<String, DirtyableImage> imagePool = null;

    public Tile() {
        this.imagePool = new HashMap<String, DirtyableImage>();
    }

    public Tile(String id, String name, int size) {
        this();
        this.id = id;
        this.name = name;
        this.size = size;
    }

    @JsonIgnore
    public void putImage(DirtyableImage image) {
        this.putImage(this.id, image);
    }

    @JsonIgnore
    public void putImage(String id, DirtyableImage image) {
        this.imagePool.put(id, image);
    }

    @JsonIgnore
    public void removeImage() {
        this.removeImage(this.id);
    }

    @JsonIgnore
    public void removeImage(String id) {
        this.imagePool.get(id).getImage().dispose();
        this.imagePool.remove(id);
    }

    @JsonIgnore
    public DirtyableImage getImage() {
        return this.getImage(this.id);
    }

    @JsonIgnore
    public DirtyableImage getImage(String id) {
        return this.imagePool.get(id);
    }

    @JsonIgnore
    public boolean isDirty() {
        return this.getActiveLayer().isDirty();
    }

    @JsonIgnore
    public void setDirty(boolean isDirty) {
        this.getActiveLayer().setDirty(isDirty);
    }

    @JsonIgnore
    public Layer getLayer(int index) {
        return this.layerList.get(index);
    }

    @JsonIgnore
    public int getSize() {
        return this.layerList.size();
    }

    @JsonIgnore
    public Layer addLayer(String id, String name, int size, Integer brushValue) {
        Layer layer = new Layer(id, name, size, brushValue);
        layer.getColorPalette().add(0);
        layer.getColorPalette().add(1);
        layer.getColorPalette().add(2);
        layer.getColorPalette().add(3);
        this.layerList.add(layer);
        this.layerIndexOrderList.add(this.layerList.indexOf(layer));
        this.layerList.forEach(l -> l.setActive(false));
        this.layerList.get(this.layerIndexOrderList.size() - 1).setActive(true);
        layer.setSelectedColorIndex(0);
        this.fireLayerAdded();
        return layer;
    }

    @JsonIgnore
    public void removeActiveLayer() {
    }

    @JsonIgnore
    public void removeLayer(int index) {
        if (this.layerIndexOrderList.size() > 0) {
            int layerIndex = this.layerIndexOrderList.get(index);
            this.layerList.remove(layerIndex);
            this.layerIndexOrderList.remove(index);
            this.fireLayerRemoved();
        }
    }

    @JsonIgnore
    public void moveToFront(int index) {
        if (index < 1) {
            return;
        }
        this.layerIndexOrderList.remove(index);
        this.layerIndexOrderList.add(0, index);
        this.fireLayerReordered();
    }

    @JsonIgnore
    public void moveToBack(Tile tile, int index) {
        if (index < 1) {
            return;
        }
        this.layerIndexOrderList.remove(index);
        this.layerIndexOrderList.add(index);
        this.fireLayerReordered();
    }

    @JsonIgnore
    public void moveUp(int index) {
        if (index < 1) {
            return;
        }
        this.layerIndexOrderList.remove(index);
        this.layerIndexOrderList.add(index - 1, index);
        this.fireLayerReordered();
    }

    @JsonIgnore
    public void moveDown(int index) {
        if (index < 1) {
            return;
        }
        this.layerIndexOrderList.remove(index);
        this.layerIndexOrderList.add(index + 1, index);
        this.fireLayerReordered();
    }

    @JsonIgnore
    public void move(int from, int to) {
    }

    @JsonIgnore
    public void setMulticolorEnabled(boolean multicolorEnabled) {
        this.multicolorEnabled = multicolorEnabled;
        this.fireTileChanged();
    }

    @JsonIgnore
    public void setShowOnlyActiveLayer(boolean showOnlyActiveLayer) {
        this.showOnlyActiveLayer = showOnlyActiveLayer;
        this.fireLayerVisibilityChanged(-1);
    }

    @JsonIgnore
    public void setShowInactiveLayerTranslucent(boolean showInactiveLayerTranslucent) {
        this.setShowInactiveLayerTranslucent(showInactiveLayerTranslucent);
        this.fireLayerVisibilityChanged(-1);
    }

    @JsonIgnore
    public void setLayerVisible(int index, boolean visible) {
        this.layerList.get(this.layerIndexOrderList.get(index)).setVisible(visible);
        this.fireLayerVisibilityChanged(index);
    }

    @JsonIgnore
    public void setLayerActive(int index, boolean active) {
        this.layerList.forEach(layer -> layer.setActive(false));
        this.layerList.get(this.layerIndexOrderList.get(index)).setActive(active);
        this.fireActiveLayerChanged(index);
    }

    @JsonIgnore
    public void setLayerLocked(int index, boolean active) {
        this.layerList.get(this.layerIndexOrderList.get(index)).setLocked(active);
        this.fireActiveLayerChanged(index);
    }

    @JsonIgnore
    public void resetActiveLayer() {
        int size = this.getActiveLayer().getContent().length;
    }

    @JsonIgnore
    public Layer getActiveLayer() {
        return this.layerList.stream().filter(x -> x.isActive()).findFirst().orElse(null);
    }

    @JsonIgnore
    public void setActiveLayerColorIndex(int index, int colorIndex, boolean select) {
        Layer layer = this.getActiveLayer();
        layer.getColorPalette().set(index, colorIndex);
        if (select) {
            this.getActiveLayer().setSelectedColorIndex(index);
        }
        this.fireActiveLayerChanged(-1);
    }

    @JsonIgnore
    public int getColorIndex(int colorIndex) {
        return this.getActiveLayer().getColorPalette().get(colorIndex);
    }

    @JsonIgnore
    public void setOrigin(Point origin) {
        this.originX = origin.x;
        this.originY = origin.y;
    }

    @JsonIgnore
    public Point getOrigin() {
        return new Point(this.originX, this.originY);
    }

    @JsonIgnore
    public void addTileListener(ITileListener listener) {
        this.createTileListenerList().add(listener);
    }

    @JsonIgnore
    public void removeTileListener(ITileListener listener) {
        this.createTileListenerList().remove(listener);
    }

    @JsonIgnore
    private List<ITileListener> createTileListenerList() {
        if (this.tileListenerList == null) {
            this.tileListenerList = new ArrayList<ITileListener>();
        }
        return this.tileListenerList;
    }

    @JsonIgnore
    private void fireLayerAdded() {
        this.createTileListenerList().forEach(listener -> listener.layerAdded());
    }

    @JsonIgnore
    private void fireLayerRemoved() {
        this.createTileListenerList().forEach(listener -> listener.layerRemoved());
    }

    @JsonIgnore
    private void fireLayerVisibilityChanged(int layer) {
        this.createTileListenerList().forEach(listener -> listener.layerVisibilityChanged(layer));
    }

    @JsonIgnore
    private void fireLayerContentChanged(int layer) {
        this.createTileListenerList().forEach(listener -> listener.layerContentChanged(layer));
    }

    @JsonIgnore
    private void fireLayerReordered() {
        this.createTileListenerList().forEach(listener -> listener.layerReordered());
    }

    @JsonIgnore
    private void fireActiveLayerChanged(int layer) {
        this.createTileListenerList().forEach(listener -> listener.activeLayerChanged(layer));
    }

    private void fireTileChanged() {
        this.createTileListenerList().forEach(listener -> listener.tileChanged());
    }

    public void sendModificationNotification() {
        this.fireLayerContentChanged(0);
    }

    public String getId() {
        return this.id;
    }

    @JsonProperty(value="id")
    public void setId(String id) {
        this.id = id;
    }

    public String getName() {
        return this.name;
    }

    public boolean isMulticolorEnabled() {
        return this.multicolorEnabled;
    }

    public Tile(String id, String name, boolean showOnlyActiveLayer, boolean showInactiveLayerTranslucent, boolean multicolorEnabled, int backgroundColorIndex, int originX, int originY, boolean deleted, List<Layer> layerList, List<Integer> layerIndexOrderList, List<ITileListener> tileListenerList, int size, Map<String, DirtyableImage> imagePool) {
        this.id = id;
        this.name = name;
        this.showOnlyActiveLayer = showOnlyActiveLayer;
        this.showInactiveLayerTranslucent = showInactiveLayerTranslucent;
        this.multicolorEnabled = multicolorEnabled;
        this.backgroundColorIndex = backgroundColorIndex;
        this.originX = originX;
        this.originY = originY;
        this.deleted = deleted;
        this.layerList = layerList;
        this.layerIndexOrderList = layerIndexOrderList;
        this.tileListenerList = tileListenerList;
        this.size = size;
        this.imagePool = imagePool;
    }
}

