/*
 * Decompiled with CFR 0.152.
 */
package de.drazil.nerdsuite.widget;

import de.drazil.nerdsuite.Constants;
import de.drazil.nerdsuite.model.CharMap;
import de.drazil.nerdsuite.model.CharObject;
import de.drazil.nerdsuite.model.PlatformColor;
import de.drazil.nerdsuite.widget.BaseWidget;
import de.drazil.nerdsuite.widget.ICharSelectionListener;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Shell;

public class SymbolPaletteChooser
extends BaseWidget
implements PaintListener {
    private int columns;
    private int rows;
    private int width;
    private int height;
    private int cx;
    private int cy;
    private int charIndex;
    private int repeatitionCount = 1;
    private int maxChars;
    private boolean isInFooter;
    private boolean mouseIn = false;
    private CharMap charMap;
    private List<CharObject> charList;
    private List<ICharSelectionListener> charSelectionListener;
    private List<PlatformColor> colorList;
    private static final int CHAR_TILE_SIZE = 18;

    public SymbolPaletteChooser(Composite parent, int style, CharMap charMap, List<PlatformColor> colorList) {
        super(parent, style);
        this.setSymbolMap(charMap);
        this.charSelectionListener = new ArrayList<ICharSelectionListener>();
        this.addPaintListener(this);
        this.colorList = colorList;
    }

    public void setSymbolMap(CharMap charMap) {
        this.charMap = charMap;
        this.charList = charMap.getCharMap().stream().filter(e -> e.isUpper()).collect(Collectors.toList());
        this.columns = this.charList.size() / 16;
        this.rows = this.charList.size() / this.columns;
        this.width = this.columns * 18;
        this.height = this.rows * 18;
        this.setSize(this.width, this.height + 20);
        this.maxChars = this.charList.size() - 1;
    }

    public void paintControl(PaintEvent e) {
        int thickness = 2;
        e.gc.setLineWidth(thickness);
        e.gc.setBackground(Constants.DARK_GREY);
        e.gc.fillRectangle(0, 0, this.height, this.width);
        int r = 0;
        while (r < this.columns) {
            int c = 0;
            while (c < this.rows) {
                int i = c + r * this.columns;
                e.gc.setFont(Constants.C64_Pro_Mono_FONT_12);
                e.gc.setForeground(Constants.WHITE);
                CharObject cm = this.charList.get(this.charMap.getUpperIndexOrderList().get(i));
                if (!cm.isColor() && !cm.isControl()) {
                    e.gc.drawString(String.valueOf(cm.getUnicode()), c * 18, r * 18);
                } else if (cm.isColor()) {
                    e.gc.setBackground(this.colorList.get(Integer.valueOf(cm.getCustomValue())).getColor());
                    e.gc.fillRectangle(1 + c * 18, 1 + r * 18, 18 - thickness, 18 - thickness);
                } else if (cm.isControl()) {
                    e.gc.setFont(Constants.GoogleMaterials_12);
                    e.gc.drawString(String.valueOf(cm.getAltUnicode()), c * 18, r * 18);
                }
                e.gc.setBackground(Constants.DARK_GREY);
                if (c == this.cx && r == this.cy && !this.isInFooter) {
                    e.gc.setForeground(Constants.BRIGHT_ORANGE);
                    e.gc.drawRectangle(1 + this.cx * 18, 1 + this.cy * 18, 18 - thickness, 18 - thickness);
                }
                ++c;
            }
            ++r;
        }
        e.gc.setForeground(Constants.DARK_GREY);
        e.gc.fillRectangle(0, this.height, this.width, 20);
        e.gc.setFont(Constants.SourceCodePro_Mono);
        e.gc.setForeground(Constants.WHITE);
        if (this.charIndex != -1) {
            CharObject cm = this.charList.get(this.charMap.getUpperIndexOrderList().get(this.charIndex));
            e.gc.drawString(String.format("$%02X(%03d) - %s", cm.getId(), cm.getId(), cm.getName()), 5, this.height);
            e.gc.drawString("symbol:", 200, this.height);
            e.gc.setBackground(Constants.BLACK);
            e.gc.fillRectangle(this.width - 18, this.height + 2, 16, 16);
            e.gc.setFont(Constants.C64_Pro_Mono_FONT_12);
            e.gc.drawString(String.format("%s", String.valueOf(cm.getUnicode())), this.width - 18, this.height + 2);
        } else {
            e.gc.setFont(Constants.GoogleMaterials_12);
            e.gc.drawString("\ueaa7", 30, this.height);
            e.gc.setFont(Constants.SourceCodePro_Mono);
            String s = String.format("%02d", this.repeatitionCount);
            Point p = e.gc.textExtent(s);
            e.gc.drawString(s, this.width / 2 - p.x / 2, this.height);
            e.gc.setFont(Constants.GoogleMaterials_12);
            e.gc.drawString("\ueaaa", this.width - 50, this.height);
        }
    }

    @Override
    protected void leftMouseButtonClickedInternal(int modifierMask, int x, int y) {
        this.computeCursorPosition(x, y);
        if (this.charIndex != -1) {
            this.close();
            this.fireCharSelected(this.charIndex);
            this.charSelectionListener.clear();
        }
    }

    @Override
    protected void leftMouseButtonPressedInternal(int modifierMask, int x, int y) {
        if (!this.mouseIn) {
            this.close();
        }
    }

    @Override
    protected void mouseEnterInternal(int modifierMask, int x, int y) {
        this.mouseIn = true;
    }

    @Override
    protected void mouseExitInternal(int modifierMask, int x, int y) {
        this.mouseIn = false;
    }

    @Override
    protected void mouseMoveInternal(int modifierMask, int x, int y) {
        this.computeCursorPosition(x, y);
        this.redraw();
    }

    @Override
    protected void leftMouseButtonReleasedInternal(int modifierMask, int x, int y) {
        if (x > 0 && x < 50 && y > this.height) {
            if (this.repeatitionCount > 1) {
                --this.repeatitionCount;
            }
            this.redraw();
        }
        if (x > this.width - 50 && x < this.width && y > this.height) {
            if (this.repeatitionCount < 40) {
                ++this.repeatitionCount;
            }
            this.redraw();
        }
    }

    private void close() {
        Composite o = this.getParent().getParent();
        if (o instanceof Shell) {
            ((Shell)o).close();
        }
    }

    public void addCharSelectionListener(ICharSelectionListener listener) {
        this.charSelectionListener.add(listener);
    }

    public void removeCharSelectionListener(ICharSelectionListener listener) {
        this.charSelectionListener.remove(listener);
    }

    private void fireCharSelected(int charIndex) {
        int index = this.charMap.getUpperIndexOrderList().get(charIndex);
        this.charSelectionListener.forEach(l -> l.charSelected(charIndex, this.charList.get(index).getUnicode(), this.repeatitionCount));
    }

    private void computeCursorPosition(int x, int y) {
        int icx = x / 18;
        int icy = y / 18;
        int idx = icx + icy * this.columns;
        this.charIndex = -1;
        boolean bl = this.isInFooter = y > this.height;
        if (idx <= this.maxChars) {
            this.charIndex = idx;
            this.cx = icx;
            this.cy = icy;
        }
    }

    public Point computeSize(int wHint, int hHint, boolean changed) {
        return this.getSize();
    }
}

