/*
 * Decompiled with CFR 0.152.
 */
package de.drazil.nerdsuite.widget;

import de.drazil.nerdsuite.Constants;
import de.drazil.nerdsuite.enums.RedrawMode;
import de.drazil.nerdsuite.model.DirtyableImage;
import de.drazil.nerdsuite.model.SelectionRange;
import de.drazil.nerdsuite.mouse.MeasuringController;
import de.drazil.nerdsuite.widget.BaseImagingWidget;
import de.drazil.nerdsuite.widget.IColorPaletteProvider;
import de.drazil.nerdsuite.widget.Layer;
import de.drazil.nerdsuite.widget.Tile;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;

public class RepositoryWidget
extends BaseImagingWidget {
    private boolean tileDragActive = false;
    private boolean tileSelectionStarted = false;
    private SelectionRange tileSelectionRange = new SelectionRange();
    private List<Integer> selectedTileIndexList = new ArrayList<Integer>();
    private boolean drawAll = true;
    private int start;
    private int end;
    private Map<String, DirtyableImage> imageCache;
    private int maxColumns;
    private int maxRows;

    public RepositoryWidget(Composite parent, int style, String owner, IColorPaletteProvider colorPaletteProvider, boolean autowrap) {
        super(parent, style, owner, colorPaletteProvider, autowrap);
        this.enableDelayTrigger(MeasuringController.Trigger.LEFT, 1000L);
        this.setBackground(Constants.BLACK);
        this.imageCache = new HashMap<String, DirtyableImage>();
    }

    @Override
    protected void leftMouseButtonPressedDelayed(int modifierMask, int x, int y) {
        this.tileDragActive = true;
        this.computeTileSelection(this.tileX, this.tileY, 0);
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                RepositoryWidget.this.doRedraw(RedrawMode.DrawAllTiles, 1);
            }
        });
    }

    @Override
    protected void leftMouseButtonClicked(int modifierMask, int x, int y) {
        if (!this.tileDragActive) {
            this.selectedTileIndexX = this.tileX;
            this.selectedTileIndexY = this.tileY;
            this.selectedTileIndex = this.computeTileIndex(this.tileX, this.tileY);
            this.computeTileSelection(this.tileX, this.tileY, 1);
            if (this.selectedTileIndex < this.tileRepositoryService.getSize()) {
                this.tileRepositoryService.setSelectedTileIndex(this.selectedTileIndex);
            } else {
                System.out.println("tile selection outside range...");
                this.tileRepositoryService.setSelectedTileIndex(-1);
            }
            this.doRedraw(RedrawMode.DrawAllTiles, 1);
        } else {
            this.selectedTileIndexX = this.tileX;
            this.selectedTileIndexY = this.tileY;
            this.selectedTileIndex = this.computeTileIndex(this.tileX, this.tileY);
        }
    }

    @Override
    protected void mouseDragged(int modifierMask, int x, int y) {
        this.tileDragActive = false;
        this.stopDelayTrigger(MeasuringController.Trigger.LEFT);
        this.computeTileSelection(this.tileX, this.tileY, 1);
        this.doRedraw(RedrawMode.DrawAllTiles, 1);
    }

    @Override
    protected void mouseDraggedDelayed(int modifierMask, int x, int y) {
        this.tileDragActive = true;
        if (this.tileSelectionStarted) {
            this.stopDelayTrigger(MeasuringController.Trigger.LEFT);
        }
        this.computeTileSelection(this.tileX, this.tileY, 1);
        this.doRedraw(RedrawMode.DrawAllTiles, 1);
    }

    @Override
    protected void leftMouseButtonReleased(int modifierMask, int x, int y) {
        if (this.tileDragActive) {
            this.tileDragActive = false;
            this.tileRepositoryService.moveTile(this.tileSelectionRange.getFrom(), this.tileSelectionRange.getTo());
        }
        if (this.selectedTileIndexList.size() > 1) {
            this.tileSelectionStarted = false;
            this.tileRepositoryService.setSelectedTileIndexList(this.selectedTileIndexList);
        }
        this.doRedraw(RedrawMode.DrawAllTiles, 1);
    }

    @Override
    protected void leftMouseButtonPressed(int modifierMask, int x, int y) {
        this.computeTileSelection(this.tileX, this.tileY, 0);
    }

    @Override
    protected void mouseMove(int modifierMask, int x, int y) {
        if (this.tileChanged) {
            this.doRedraw(RedrawMode.DrawAllTiles, 1);
        }
    }

    @Override
    protected void mouseEnter(int modifierMask, int x, int y) {
    }

    @Override
    protected void mouseExit(int modifierMask, int x, int y) {
    }

    private int computeTileIndex(int x, int y) {
        return x + y * this.maxColumns;
    }

    private void computeTileSelection(int tileX, int tileY, int mode) {
        int index = this.computeTileIndex(tileX, tileY);
        if (mode == 0) {
            this.tileSelectionStarted = false;
            this.tileSelectionRange.setFrom(index);
            this.tileSelectionRange.setTo(index);
        } else if (mode == 1) {
            if (!this.tileSelectionStarted) {
                this.tileSelectionRange.setFrom(index);
                this.tileSelectionStarted = true;
            }
            this.tileSelectionRange.setTo(index);
            int from = this.tileSelectionRange.getFrom();
            int to = this.tileSelectionRange.getTo();
            if (from > to) {
                int d = from;
                from = to;
                to = d;
            }
            if (!this.tileDragActive) {
                this.selectedTileIndexList.clear();
                int i = from;
                while (i <= to) {
                    if (i < this.tileRepositoryService.getSize()) {
                        this.selectedTileIndexList.add(i);
                    }
                    ++i;
                }
            }
        }
    }

    private void resetSelectionList() {
        this.selectedTileIndexList = new ArrayList<Integer>();
    }

    public void selectAll() {
        if (this.supportsMultiSelection()) {
            this.doRedraw(RedrawMode.DrawAllTiles, 1);
        }
    }

    @Override
    public void paintControl(PaintEvent e) {
        this.paintControl(e.gc, this.redrawMode, this.conf.pixelGridEnabled, this.conf.separatorEnabled, this.conf.tileGridEnabled, this.conf.tileSubGridEnabled, true, this.conf.tileCursorEnabled, true);
    }

    @Override
    protected void paintControl(GC gc, RedrawMode redrawMode, boolean paintPixelGrid, boolean paintSeparator, boolean paintTileGrid, boolean paintTileSubGrid, boolean paintSelection, boolean paintTileCursor, boolean paintTelevisionMode) {
        Rectangle r = this.getParent().getBounds();
        this.maxColumns = r.width / (this.conf.repositoryScaledTileWith + this.conf.tileGap);
        this.maxRows = r.height / (this.conf.repositoryScaledTileHeight + this.conf.tileGap);
        System.out.printf("repo redrawmode: %s\n", redrawMode.toString());
        this.paintTiles(gc, this.action, this.maxColumns, this.maxRows);
        if (this.tileDragActive) {
            this.paintDragMarker(gc);
        } else {
            this.paintTileMarker(gc);
            this.paintSelection(gc);
        }
        this.action = 0;
        this.drawAll = true;
        redrawMode = RedrawMode.DrawNothing;
    }

    private void paintDragMarker(GC gc) {
        int from = this.tileSelectionRange.getFrom();
        int to = this.tileSelectionRange.getTo();
        int xfrom = from % this.maxColumns;
        int yfrom = from / this.maxColumns;
        int xto = to % this.maxColumns;
        int yto = to / this.maxColumns;
        gc.setLineWidth(1);
        gc.setBackground(Constants.SELECTION_TILE_MARKER_COLOR);
        gc.setAlpha(150);
        gc.fillRectangle(xfrom * (this.conf.repositoryScaledTileWith + this.conf.tileGap), yfrom * (this.conf.repositoryScaledTileHeight + this.conf.tileGap), this.conf.repositoryScaledTileWith, this.conf.repositoryScaledTileHeight);
        gc.setAlpha(255);
        gc.setForeground(Constants.BRIGHT_ORANGE);
        gc.setLineWidth(4);
        if (Math.abs(to - from) > 0) {
            gc.drawLine(xto * (this.conf.repositoryScaledTileWith + this.conf.tileGap), yto * (this.conf.repositoryScaledTileHeight + this.conf.tileGap), xto * (this.conf.repositoryScaledTileWith + this.conf.tileGap), yto * (this.conf.repositoryScaledTileHeight + this.conf.tileGap) + this.conf.repositoryScaledTileHeight);
        }
    }

    private void paintSelection(GC gc) {
        this.selectedTileIndexList.forEach(i -> {
            int y = i / this.maxColumns;
            int x = i % this.maxColumns;
            if (i == this.temporaryIndex) {
                gc.setLineWidth(3);
                gc.setAlpha(255);
                gc.setBackground(Constants.WHITE);
                gc.fillRectangle(x * (this.conf.repositoryScaledTileWith + this.conf.tileGap), y * (this.conf.repositoryScaledTileHeight + this.conf.tileGap) + this.conf.repositoryScaledTileHeight, this.conf.repositoryScaledTileWith, 4);
            }
            gc.setBackground(Constants.SELECTION_TILE_MARKER_COLOR);
            gc.setAlpha(90);
            gc.fillRectangle(x * (this.conf.repositoryScaledTileWith + this.conf.tileGap), y * (this.conf.repositoryScaledTileHeight + this.conf.tileGap), this.conf.repositoryScaledTileWith, this.conf.repositoryScaledTileHeight);
        });
    }

    private void paintTileMarker(GC gc) {
        if (this.mouseIn && this.computeTileIndex(this.tileX, this.tileY) < this.tileRepositoryService.getSize()) {
            gc.setLineWidth(3);
            gc.setBackground(Constants.BRIGHT_ORANGE);
            gc.setAlpha(90);
            gc.fillRectangle(this.tileX * (this.conf.repositoryScaledTileWith + this.conf.tileGap), this.tileY * (this.conf.repositoryScaledTileHeight + this.conf.tileGap), this.conf.repositoryScaledTileWith, this.conf.repositoryScaledTileHeight);
        }
    }

    private void paintTileGrid(GC gc, int maxColumns, int maxRows) {
        gc.setLineWidth(1);
        gc.setLineStyle(1);
        gc.setForeground(Constants.TILE_GRID_COLOR);
        int x = 0;
        while (x <= maxColumns) {
            gc.drawLine(x * (this.conf.repositoryScaledTileWith + this.conf.tileGap) - 1, 0, x * (this.conf.repositoryScaledTileWith + this.conf.tileGap) - 1, this.getParent().getBounds().height);
            ++x;
        }
        int y = 0;
        while (y <= maxRows) {
            gc.drawLine(0, y * (this.conf.repositoryScaledTileHeight + this.conf.tileGap) - 1, this.getParent().getBounds().width, y * (this.conf.repositoryScaledTileHeight + this.conf.tileGap) - 1);
            ++y;
        }
    }

    @Override
    public void redrawTiles(List<Integer> selectedTileIndexList, RedrawMode redrawMode, int action) {
        if (redrawMode == RedrawMode.DrawTemporarySelectedTile) {
            this.temporaryIndex = selectedTileIndexList.get(0);
        }
        this.doRedraw(redrawMode, action);
    }

    private void paintTiles(GC gc, int action, int maxX, int maxY) {
        int max = maxX * maxY;
        int i = 0;
        while (i < max) {
            this.paintTile(gc, i, action, maxX);
            ++i;
        }
    }

    private void paintTile(GC gc, int index, int action, int columns) {
        int y = index / columns * (this.conf.repositoryScaledTileHeight + this.conf.tileGap);
        int x = index % columns * (this.conf.repositoryScaledTileWith + this.conf.tileGap);
        if (index < this.tileRepositoryService.getSize()) {
            Tile selectedTile;
            Tile tile = this.tileRepositoryService.getTile(index);
            if (tile.equals(selectedTile = this.tileRepositoryService.getSelectedTile())) {
                tile.setDirty(true);
            }
            Layer layer = tile.getActiveLayer();
            String name = String.format("%s%sID%03X", tile.getId(), layer.getId(), 0);
            this.imagePainterFactory.drawScaledImage(gc, tile, name, x, y, true);
            gc.setForeground(Constants.DEFAULT_COLOR_DEBUG);
            gc.drawRectangle(x, y, this.conf.repositoryScaledTileWith, this.conf.repositoryScaledTileHeight);
        }
    }

    @Override
    public void activeLayerChanged(int layer) {
        this.doRedraw(RedrawMode.DrawAllTiles, 1);
    }

    @Override
    public void colorSelected(int colorNo, int colorIndex) {
        this.tileRepositoryService.getSelectedTile().setActiveLayerColorIndex(colorNo, colorIndex, true);
    }

    @Override
    public void tileReordered() {
        this.doRedraw(RedrawMode.DrawAllTiles, 1);
    }

    @Override
    public void redrawCalculatedArea() {
        if (this.redrawMode == RedrawMode.DrawSelectedTiles || this.redrawMode == RedrawMode.DrawSelectedTile || this.redrawMode == RedrawMode.DrawPixel) {
            this.drawAll = false;
            this.start = this.tileRepositoryService.getSelectedTileIndexList().get(0);
            this.end = this.tileRepositoryService.getSelectedTileIndexList().get(this.tileRepositoryService.getSelectedTileIndexList().size() - 1);
            int iys = this.start / this.maxColumns;
            int ys = iys * (this.conf.repositoryScaledTileHeight + this.conf.tileGap);
            int iye = this.end / this.maxColumns;
            int ye = iye * (this.conf.repositoryScaledTileHeight + this.conf.tileGap);
            this.start = this.computeTileIndex(0, iys);
            this.end = this.computeTileIndex(this.maxColumns, iye);
            if (this.end > this.tileRepositoryService.getSize()) {
                this.end = this.tileRepositoryService.getSize();
            }
            int height = (1 + iye - iys) * (this.conf.repositoryScaledTileHeight + this.conf.tileGap);
            this.redraw(0, ys, (this.conf.repositoryScaledTileWith + this.conf.tileGap) * this.maxColumns, height, false);
        } else {
            this.drawAll = true;
            this.redraw();
        }
    }
}

