/*
 * Decompiled with CFR 0.152.
 */
package de.drazil.nerdsuite.widget;

import de.drazil.nerdsuite.Constants;
import de.drazil.nerdsuite.enums.RedrawMode;
import de.drazil.nerdsuite.model.SelectionRange;
import de.drazil.nerdsuite.widget.BaseImagingWidget;
import de.drazil.nerdsuite.widget.IColorPaletteProvider;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Composite;

public class ReferenceWidget
extends BaseImagingWidget {
    private boolean tileSelectionStarted = false;
    private SelectionRange tileSelectionRange = new SelectionRange();
    private List<Integer> selectedTileIndexList = new ArrayList<Integer>();
    private int start;
    private int end;

    public ReferenceWidget(Composite parent, int style, String owner, IColorPaletteProvider colorPaletteProvider, boolean autowrap) {
        super(parent, style, owner, colorPaletteProvider, autowrap);
    }

    @Override
    protected void leftMouseButtonClicked(int modifierMask, int x, int y) {
        this.selectedTileIndexX = this.tileX;
        this.selectedTileIndexY = this.tileY;
        this.selectedTileIndex = this.computeTileIndex(this.tileX, this.tileY);
        System.out.printf("select index:%02x\n", this.selectedTileIndex);
        this.computeTileSelection(this.tileX, this.tileY, 1);
        if (this.selectedTileIndex < this.tileRepositoryService.getSize()) {
            this.tileRepositoryService.setSelectedTileIndex(this.selectedTileIndex);
        } else {
            System.out.println("tile selection outside range...");
            this.tileRepositoryService.setSelectedTileIndex(-1);
        }
        this.doRedraw(RedrawMode.DrawAllTiles, 1);
    }

    @Override
    protected void leftMouseButtonReleased(int modifierMask, int x, int y) {
        if (this.selectedTileIndexList.size() > 1) {
            this.tileSelectionStarted = false;
            this.tileRepositoryService.setSelectedTileIndexList(this.selectedTileIndexList);
        }
        this.doRedraw(RedrawMode.DrawAllTiles, 1);
    }

    @Override
    protected void leftMouseButtonPressed(int modifierMask, int x, int y) {
        this.computeTileSelection(this.tileX, this.tileY, 0);
    }

    @Override
    protected void mouseEnter(int modifierMask, int x, int y) {
        this.mouseMove(modifierMask, x, y);
    }

    @Override
    protected void mouseExit(int modifierMask, int x, int y) {
        this.mouseMove(modifierMask, x, y);
    }

    @Override
    protected void mouseMove(int modifierMask, int x, int y) {
        if (this.tileChanged || !this.mouseIn) {
            this.doRedraw(RedrawMode.DrawAllTiles, 1);
        }
    }

    private int computeTileIndex(int x, int y) {
        return x + y * this.conf.columns;
    }

    private void computeTileSelection(int tileX, int tileY, int mode) {
        int index = this.computeTileIndex(tileX, tileY);
        if (mode == 0) {
            this.tileSelectionStarted = false;
            this.tileSelectionRange.setFrom(index);
            this.tileSelectionRange.setTo(index);
        } else if (mode == 1) {
            if (!this.tileSelectionStarted) {
                this.tileSelectionRange.setFrom(index);
                this.tileSelectionStarted = true;
            }
            this.tileSelectionRange.setTo(index);
            int from = this.tileSelectionRange.getFrom();
            int to = this.tileSelectionRange.getTo();
            if (from > to) {
                int d = from;
                from = to;
                to = d;
            }
            this.selectedTileIndexList.clear();
            int i = from;
            while (i <= to) {
                if (i < this.tileRepositoryService.getSize()) {
                    this.selectedTileIndexList.add(i);
                }
                ++i;
            }
        }
    }

    private void resetSelectionList() {
        this.selectedTileIndexList = new ArrayList<Integer>();
    }

    public void selectAll() {
        if (this.supportsMultiSelection()) {
            this.doRedraw(RedrawMode.DrawAllTiles, 1);
        }
    }

    @Override
    public void paintControl(PaintEvent e) {
        this.paintControl(e.gc, this.redrawMode, this.conf.pixelGridEnabled, this.conf.separatorEnabled, this.conf.tileGridEnabled, this.conf.tileSubGridEnabled, true, this.conf.tileCursorEnabled, true);
    }

    @Override
    protected void paintControl(GC gc, RedrawMode redrawMode, boolean paintPixelGrid, boolean paintSeparator, boolean paintTileGrid, boolean paintTileSubGrid, boolean paintSelection, boolean paintTileCursor, boolean paintTelevisionMode) {
        this.paintTileMap(gc);
        this.paintSelection(gc);
        this.paintTileMarker(gc);
        gc.setBackground(Constants.DARK_GREY);
        gc.fillRectangle(0, 302, 301, 20);
        gc.setForeground(Constants.WHITE);
        int index = this.tileRepositoryService.getTileList().indexOf(this.tileRepositoryService.getSelectedTile());
        int index2 = this.tileRepositoryService.getSelectedTileIndex();
        gc.setFont(Constants.RobotoMonoBold_FONT);
        gc.drawString(String.format("Natural %03X / %03d Ordered %03X / %03d", index, index, index2, index2), 0, (this.conf.tileHeightPixel * 2 + this.conf.tileGap) * 16);
        this.action = 0;
        redrawMode = RedrawMode.DrawNothing;
    }

    private void paintSelection(GC gc) {
        gc.setBackground(Constants.SELECTION_TILE_MARKER_COLOR);
        gc.setAlpha(150);
        this.selectedTileIndexList.forEach(i -> {
            int y = i / this.conf.columns;
            int x = i % this.conf.columns;
            gc.fillRectangle(x * (this.conf.tileWidthPixel * this.conf.scaleFactor + this.conf.tileGap), y * (this.conf.tileHeightPixel * this.conf.scaleFactor + this.conf.tileGap), this.conf.tileWidthPixel * this.conf.scaleFactor, this.conf.tileHeightPixel * this.conf.scaleFactor);
            if (i == this.temporaryIndex) {
                gc.setLineWidth(3);
                gc.setForeground(Constants.TEMPORARY_SELECTION_TILE_MARKER_COLOR);
                gc.drawRectangle(x * (this.conf.tileWidthPixel + this.conf.tileGap), y * (this.conf.tileHeightPixel + this.conf.tileGap), this.conf.tileWidthPixel, this.conf.tileHeightPixel);
            }
        });
    }

    private void paintTileMarker(GC gc) {
        if (this.mouseIn && this.computeTileIndex(this.tileX, this.tileY) < this.tileRepositoryService.getSize()) {
            gc.setLineWidth(3);
            gc.setBackground(Constants.BRIGHT_ORANGE);
            gc.fillRectangle(this.tileX * (this.conf.tileWidthPixel * this.conf.scaleFactor + this.conf.tileGap), this.tileY * (this.conf.tileHeightPixel * this.conf.scaleFactor + this.conf.tileGap), this.conf.tileWidthPixel * this.conf.scaleFactor, this.conf.tileHeightPixel * this.conf.scaleFactor);
        }
    }

    @Override
    public void redrawTiles(List<Integer> selectedTileIndexList, RedrawMode redrawMode, int action) {
        if (redrawMode == RedrawMode.DrawTemporarySelectedTile) {
            this.temporaryIndex = selectedTileIndexList.get(0);
        }
        this.doRedraw(redrawMode, action);
    }

    private void paintTileMap(GC gc) {
        this.imagePainterFactory.setForegroundColorIndex(1);
        gc.drawImage(this.imagePainterFactory.createOrUpdateBaseImage("REPOSITORY", Constants.BLACK, 301, 301).getImage(), 0, 0);
        gc.drawImage(this.imagePainterFactory.createOrUpdateTileMap(false).getImage(), 0, 0);
    }

    @Override
    public void activeLayerChanged(int layer) {
    }

    @Override
    public void colorSelected(int colorNo, int colorIndex) {
        this.tileRepositoryService.getSelectedTile().setActiveLayerColorIndex(colorNo, colorIndex, true);
    }

    @Override
    public void tileReordered() {
        this.doRedraw(RedrawMode.DrawAllTiles, 1);
    }

    @Override
    public void redrawCalculatedArea() {
        if (this.redrawMode == RedrawMode.DrawSelectedTiles || this.redrawMode == RedrawMode.DrawSelectedTile || this.redrawMode == RedrawMode.DrawPixel) {
            this.start = this.tileRepositoryService.getSelectedTileIndexList().get(0);
            this.end = this.tileRepositoryService.getSelectedTileIndexList().get(this.tileRepositoryService.getSelectedTileIndexList().size() - 1);
            int iys = this.start / this.conf.columns;
            int ys = iys * this.conf.tileHeightPixel;
            int iye = this.end / this.conf.columns;
            int ye = iye * this.conf.tileHeightPixel;
            this.start = this.computeTileIndex(0, iys);
            this.end = this.computeTileIndex(this.conf.columns, iye);
            if (this.end > this.tileRepositoryService.getSize()) {
                this.end = this.tileRepositoryService.getSize();
            }
            int height = (1 + iye - iys) * this.conf.tileHeightPixel;
            this.redraw(0, ys, this.conf.tileWidthPixel * this.conf.columns, height, false);
        } else {
            this.redraw();
        }
    }

    @Override
    public Point computeSize(int wHint, int hHint, boolean changed) {
        return new Point(this.conf.fullWidthPixel * 2, this.conf.fullHeightPixel * 2 + 20);
    }
}

