/*
 * Decompiled with CFR 0.152.
 */
package de.drazil.nerdsuite.widget;

import com.fasterxml.jackson.databind.ObjectMapper;
import de.drazil.nerdsuite.model.BasicInstructions;
import de.drazil.nerdsuite.model.CharMap;
import de.drazil.nerdsuite.model.CpuInstructions;
import de.drazil.nerdsuite.model.PlatformColor;
import de.drazil.nerdsuite.model.PlatformData;
import de.drazil.nerdsuite.model.TargetPlatform;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.eclipse.core.runtime.Platform;
import org.osgi.framework.Bundle;

public class PlatformFactory {
    private static List<TargetPlatform> targetPlatformList;
    private static Map<String, TargetPlatform> platformCache;
    private static Map<String, List<PlatformColor>> platformColorCache;
    private static Map<String, CharMap> charMapCache;

    static {
        platformCache = new HashMap<String, TargetPlatform>();
        platformColorCache = new HashMap<String, List<PlatformColor>>();
        charMapCache = new HashMap<String, CharMap>();
    }

    public static List<TargetPlatform> getTargetPlatFormList() {
        if (targetPlatformList == null) {
            Bundle bundle = Platform.getBundle((String)"de.drazil.nerdsuite");
            ObjectMapper mapper = new ObjectMapper();
            try {
                targetPlatformList = Arrays.asList((TargetPlatform[])mapper.readValue(bundle.getEntry("configuration/platform.json"), TargetPlatform[].class)).stream().filter(c -> c.isEnabled()).collect(Collectors.toList());
            }
            catch (Exception e) {
                targetPlatformList = null;
            }
        }
        return targetPlatformList;
    }

    public static TargetPlatform getTargetPlatform(String id) {
        TargetPlatform platform = platformCache.get(id);
        if (platform == null) {
            platform = PlatformFactory.getTargetPlatFormList().stream().filter(p -> p.getId().equalsIgnoreCase(id)).findFirst().orElse(null);
            platformCache.put(id, platform);
        }
        return platform;
    }

    public static BasicInstructions getBasicInstructions(String id) {
        BasicInstructions basicInstructions = null;
        Bundle bundle = Platform.getBundle((String)"de.drazil.nerdsuite");
        ObjectMapper mapper = new ObjectMapper();
        try {
            PlatformData platformData = (PlatformData)mapper.readValue(bundle.getEntry(PlatformFactory.getTargetPlatform(id).getSource()), PlatformData.class);
            basicInstructions = (BasicInstructions)mapper.readValue(bundle.getEntry(platformData.getBasicInstructionSource()), BasicInstructions.class);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return basicInstructions;
    }

    public static CpuInstructions getCpuInstructions(String id) {
        CpuInstructions cpuInstruction = null;
        Bundle bundle = Platform.getBundle((String)"de.drazil.nerdsuite");
        ObjectMapper mapper = new ObjectMapper();
        try {
            PlatformData platformData = (PlatformData)mapper.readValue(bundle.getEntry(PlatformFactory.getTargetPlatform(id).getSource()), PlatformData.class);
            cpuInstruction = (CpuInstructions)mapper.readValue(bundle.getEntry(platformData.getCpuInstructionSource()), CpuInstructions.class);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return cpuInstruction;
    }

    public static CharMap getCharMap(String id) {
        CharMap charMap = charMapCache.get(id);
        if (charMap == null) {
            Bundle bundle = Platform.getBundle((String)"de.drazil.nerdsuite");
            ObjectMapper mapper = new ObjectMapper();
            try {
                PlatformData platformData = (PlatformData)mapper.readValue(bundle.getEntry(PlatformFactory.getTargetPlatform(id).getSource()), PlatformData.class);
                charMap = (CharMap)mapper.readValue(bundle.getEntry(platformData.getCharMapSource()), CharMap.class);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return charMap;
    }

    public static boolean containsCodePoint(String id, char chr) {
        CharMap cm = PlatformFactory.getCharMap(id);
        return !cm.getCharMap().stream().filter(c2 -> c2.getUnicode() == chr).findFirst().isEmpty();
    }

    public static List<PlatformColor> getPlatformColors(String id) {
        List<PlatformColor> platformColors = platformColorCache.get(id);
        if (platformColors == null) {
            Bundle bundle = Platform.getBundle((String)"de.drazil.nerdsuite");
            ObjectMapper mapper = new ObjectMapper();
            PlatformData platformData = null;
            try {
                platformData = (PlatformData)mapper.readValue(bundle.getEntry(PlatformFactory.getTargetPlatform(id).getSource()), PlatformData.class);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            platformColors = platformData.getColorPalette();
            platformColorCache.put(id, platformColors);
        }
        return platformColors;
    }
}

