/*
 * Decompiled with CFR 0.152.
 */
package de.drazil.nerdsuite.widget;

import de.drazil.nerdsuite.Constants;
import de.drazil.nerdsuite.enums.CursorMode;
import de.drazil.nerdsuite.enums.GridType;
import de.drazil.nerdsuite.enums.PencilMode;
import de.drazil.nerdsuite.enums.RedrawMode;
import de.drazil.nerdsuite.imaging.service.ImagePainterFactory;
import de.drazil.nerdsuite.widget.BaseImagingWidget;
import de.drazil.nerdsuite.widget.IColorPaletteProvider;
import de.drazil.nerdsuite.widget.ImagingWidgetConfiguration;
import de.drazil.nerdsuite.widget.Layer;
import de.drazil.nerdsuite.widget.Tile;
import java.util.List;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;

public class PainterWidget
extends BaseImagingWidget {
    private boolean rangeSelectionStarted = false;
    private int selectedPixelRangeX = 0;
    private int selectedPixelRangeY = 0;
    private int selectedPixelRangeX2 = 0;
    private int selectedPixelRangeY2 = 0;
    private Point startPos;
    private int oldScrollStep = 0;
    private int scrollStep = 0;
    private ScrolledComposite parent;
    private GridType gridType = GridType.None;
    private boolean multiColor = false;

    public PainterWidget(Composite parent, int style, String owner, IColorPaletteProvider colorPaletteProvider, boolean autowrap) {
        super(parent, style, owner, colorPaletteProvider, autowrap);
        this.parent = (ScrolledComposite)parent;
        this.parent.getHorizontalBar().addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                PainterWidget.this.scrollWorkArea(e.x, e.y);
            }
        });
        this.parent.getVerticalBar().addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                PainterWidget.this.scrollWorkArea(e.x, e.y);
            }
        });
    }

    @Override
    protected void leftMouseButtonClicked(int modifierMask, int x, int y) {
        if (this.conf.cursorMode == CursorMode.Point) {
            this.setPixel(this.cursorX, this.cursorY, this.conf);
            this.tileRepositoryService.getSelectedTile().setDirty(true);
            this.doRedraw(RedrawMode.DrawPixel, 4);
        }
    }

    @Override
    protected void leftMouseButtonPressedDelayed(int modifierMask, int x, int y) {
    }

    @Override
    protected void mouseDraggedDelayed(int modifierMask, int x, int y) {
    }

    @Override
    protected void mouseDragged(int modifierMask, int x, int y) {
        if (this.conf.cursorMode == CursorMode.SelectRectangle) {
            this.computeRangeSelection(this.cursorX, this.cursorY, 1, (modifierMask & 0x20000) == 131072);
            this.doRedraw(RedrawMode.DrawSelectedTile, 2);
        } else if (this.conf.cursorMode == CursorMode.Move || this.conf.cursorMode == CursorMode.Point && (this.modifierMask & 0x60000) == 393216) {
            int xoff = x - this.startPos.x;
            int yoff = y - this.startPos.y;
            this.scrollWorkArea(xoff, yoff);
        } else if (this.conf.cursorMode == CursorMode.Point && this.cursorChanged) {
            if (this.conf.cursorMode == CursorMode.Point) {
                this.tileRepositoryService.getSelectedTile().setDirty(true);
            }
            this.setPixel(this.cursorX, this.cursorY, this.conf);
            this.doRedraw(RedrawMode.DrawPixel, 4);
        }
    }

    private void scrollWorkArea(int xoff, int yoff) {
        int xo = this.parent.getHorizontalBar().getSelection() - xoff;
        int yo = this.parent.getVerticalBar().getSelection() - yoff;
        this.parent.setOrigin(xo, yo);
        this.tileRepositoryService.getSelectedTile().setOrigin(new Point(xo, yo));
    }

    @Override
    protected void leftMouseButtonPressed(int modifierMask, int x, int y) {
        this.takePosition = true;
        if (this.conf.cursorMode == CursorMode.SelectRectangle) {
            this.computeRangeSelection(this.cursorX, this.cursorY, 0, false);
            this.doRedraw(RedrawMode.DrawSelectedTile, 2);
        } else if (this.conf.cursorMode == CursorMode.Move || this.conf.cursorMode == CursorMode.Point && (this.modifierMask & 0x60000) == 393216) {
            if (this.conf.cursorMode == CursorMode.Point) {
                this.tileRepositoryService.getSelectedTile().setDirty(true);
            }
            this.startPos = new Point(x, y);
        }
    }

    @Override
    protected void leftMouseButtonReleased(int modifierMask, int x, int y) {
        if (this.conf.cursorMode == CursorMode.SelectRectangle) {
            if (this.rangeSelectionStarted) {
                this.rangeSelectionStarted = false;
                this.computeRangeSelection(this.cursorX, this.cursorY, 2, (modifierMask & 0x20000) == 131072);
            }
        } else if (this.conf.cursorMode == CursorMode.Point) {
            this.fireDoRedraw(RedrawMode.DrawSelectedTile, null, 2);
        }
    }

    @Override
    protected void mouseEnter(int modifierMask, int x, int y) {
        this.doRedraw(RedrawMode.DrawSelectedTile, 1);
    }

    @Override
    protected void mouseExit(int modifierMask, int x, int y) {
        this.doRedraw(RedrawMode.DrawSelectedTile, 1);
    }

    @Override
    protected void mouseMove(int modifierMask, int x, int y) {
        if (this.conf.cursorMode == CursorMode.Point && this.cursorChanged) {
            this.doRedraw(RedrawMode.DrawSelectedTile, 1);
        }
    }

    @Override
    protected void mouseScrolled(int modifierMask, int x, int y, int count) {
        this.oldScrollStep = this.scrollStep;
        this.scrollStep += count;
        if (Math.abs(this.scrollStep) % 3 == 0) {
            int step;
            System.out.println("wheel");
            boolean direction = this.oldScrollStep < this.scrollStep;
            int n = step = direction ? 2 : -2;
            if (this.conf.pixelWidth + step >= 8 && this.conf.pixelWidth + step <= 32) {
                this.conf.pixelWidth += step;
                this.conf.pixelHeight = this.conf.pixelWidth;
                this.recalc();
                this.conf.computeDimensions();
                this.imagePainterFactory.resetCache();
                this.doRedraw(RedrawMode.DrawSelectedTile, 1);
                ((ScrolledComposite)this.getParent()).setMinSize(this.conf.fullWidthPixel, this.conf.fullHeightPixel);
            }
        }
    }

    private int computeCursorIndex(int x, int y) {
        return x + y * this.conf.tileWidth / (this.tileRepositoryService.getSelectedTile().isMulticolorEnabled() ? 2 : 1);
    }

    private void computeRangeSelection(int cursorX, int cursorY, int mode, boolean enabledSquareSelection) {
        int y;
        int x = cursorX < 0 ? 0 : cursorX;
        int n = y = cursorY < 0 ? 0 : cursorY;
        if (mode == 0) {
            this.selectedPixelRangeX = 0;
            this.selectedPixelRangeY = 0;
            this.selectedPixelRangeX2 = 0;
            this.selectedPixelRangeY2 = 0;
        } else if (mode == 1) {
            if (!this.rangeSelectionStarted) {
                this.selectedPixelRangeX = x;
                this.selectedPixelRangeY = y;
                this.selectedPixelRangeX2 = x;
                this.selectedPixelRangeY2 = y;
                this.rangeSelectionStarted = true;
            } else {
                this.selectedPixelRangeX2 = enabledSquareSelection && y - this.selectedPixelRangeY > x - this.selectedPixelRangeX ? this.selectedPixelRangeX + (this.selectedPixelRangeY2 - this.selectedPixelRangeY) : x;
                this.selectedPixelRangeY2 = enabledSquareSelection && x - this.selectedPixelRangeX > y - this.selectedPixelRangeY ? this.selectedPixelRangeY + (this.selectedPixelRangeX2 - this.selectedPixelRangeX) : y;
            }
        } else if (mode == 2) {
            int v;
            int x1 = this.selectedPixelRangeX;
            int x2 = this.selectedPixelRangeX2;
            int y1 = this.selectedPixelRangeY;
            int y2 = this.selectedPixelRangeY2;
            if (x1 > x2) {
                v = x1;
                x1 = x2;
                x2 = v;
            }
            if (y1 > y2) {
                v = y1;
                y1 = y2;
                y2 = v;
            }
            int width = x2 - x1 + 1;
            int height = y2 - y1 + 1;
            if (this.tileRepositoryService.getSelectedTile().isMulticolorEnabled()) {
                x1 *= 2;
                width *= 2;
            }
            this.tileRepositoryService.setSelection(new Rectangle(x1, y1, width, height));
        }
    }

    @Override
    protected void paintControl(GC gc, RedrawMode redrawMode, boolean paintPixelGrid, boolean paintSeparator, boolean paintTileGrid, boolean paintTileSubGrid, boolean paintSelection, boolean paintTileCursor, boolean paintTelevisionMode) {
        boolean forceRepaintGrid;
        Tile t = this.tileRepositoryService.getSelectedTile();
        if (redrawMode == RedrawMode.DrawTemporarySelectedTile) {
            t = this.tileRepositoryService.getTile(this.temporaryIndex);
        }
        String id = String.format("%s%sID%03X", t.getId(), t.getActiveLayer().getId(), 0);
        this.imagePainterFactory.drawScaledImage(gc, t, id, 0, 0);
        boolean bl = forceRepaintGrid = this.gridType != this.conf.getGridType() || this.multiColor != this.tileRepositoryService.getSelectedTile().isMulticolorEnabled();
        if (forceRepaintGrid) {
            this.gridType = this.conf.getGridType();
            this.multiColor = this.tileRepositoryService.getSelectedTile().isMulticolorEnabled();
        }
        if (paintPixelGrid) {
            gc.drawImage(this.imagePainterFactory.getGridLayer(forceRepaintGrid, t).getImage(), 0, 0);
            if (paintSeparator) {
                this.paintSeparator(gc);
            }
            if (paintTileSubGrid) {
                this.paintTileSubGrid(gc);
            }
        }
        if (this.conf.cursorMode == CursorMode.SelectRectangle) {
            this.paintRangeSelection(gc);
        } else if (this.conf.cursorMode == CursorMode.Point) {
            this.paintPixelCursor(gc);
        }
        this.action = 0;
        redrawMode = RedrawMode.DrawNothing;
    }

    private void paintTileSubGrid(GC gc) {
        gc.setForeground(Constants.TILE_SUB_GRID_COLOR);
        int i = this.conf.iconHeight;
        while (i < this.conf.tileHeight) {
            gc.drawLine(0, i * this.conf.scaleFactor, this.conf.painterScaledTileWith, i * this.conf.scaleFactor);
            i += this.conf.iconHeight;
        }
        i = this.conf.iconWidth;
        while (i < this.conf.tileWidth) {
            gc.drawLine(i * this.conf.scaleFactor, 0, i * this.conf.scaleFactor, this.conf.painterScaledTileHeight);
            i += this.conf.iconWidth;
        }
    }

    private void paintSeparator(GC gc) {
        gc.setForeground(Constants.BYTE_SEPARATOR_COLOR);
        int x = this.conf.storageSize;
        while (x < this.conf.tileWidth) {
            gc.drawLine(x * this.conf.scaleFactor, 0, x * this.conf.scaleFactor, this.conf.painterScaledTileHeight);
            x += this.conf.storageSize;
        }
    }

    private void paintPixelCursor(GC gc) {
        if (this.computeCursorIndex(this.cursorX, this.cursorY) < this.conf.tileSize / (this.tileRepositoryService.getSelectedTile().isMulticolorEnabled() ? 2 : 1)) {
            int pixelWidth = this.conf.pixelPaintWidth * (this.tileRepositoryService.getSelectedTile().isMulticolorEnabled() ? 2 : 1) * this.conf.getScaleFactor();
            int pixelHeight = this.conf.pixelPaintHeight * this.conf.getScaleFactor();
            if (this.conf.pencilMode == PencilMode.Draw) {
                if (this.tileRepositoryService.hasReference()) {
                    Tile tile = this.tileRepositoryService.getSelectedTile();
                    int brushIndex = this.tileRepositoryReferenceService.getSelectedTileIndex(true);
                    Tile refTile = this.tileRepositoryReferenceService.getTile(brushIndex, true);
                    ImagePainterFactory ipf = ImagePainterFactory.getImageFactory(this.tileRepositoryReferenceService.getMetadata().getId());
                    gc.setBackground(Constants.BLACK);
                    gc.fillRectangle(this.cursorX * pixelWidth, this.cursorY * pixelHeight, pixelWidth, pixelHeight);
                    int colorIndex = this.imagePainterFactory.getForegroundColorIndex();
                    ipf.setForegroundColorIndex(colorIndex);
                    String id = String.format("%s%sID%03X", refTile.getId(), refTile.getActiveLayer().getId(), colorIndex);
                    ipf.createOrUpdateLayer(id, refTile.getActiveLayer(), false);
                    ipf.drawScaledImage(gc, refTile, id, this.cursorX * pixelWidth, this.cursorY * pixelHeight);
                } else {
                    gc.setBackground(this.colorPaletteProvider.getColorByIndex(this.imagePainterFactory.getForegroundColorIndex()));
                    gc.fillRectangle(this.cursorX * pixelWidth, this.cursorY * pixelHeight, pixelWidth, pixelHeight);
                }
            } else if (this.conf.pencilMode == PencilMode.Erase) {
                gc.setBackground(Constants.BLACK);
                gc.fillRectangle(this.cursorX * pixelWidth, this.cursorY * pixelHeight, pixelWidth, pixelHeight);
            }
            gc.setForeground(Constants.BRIGHT_ORANGE);
            int x = this.cursorX * pixelWidth - 1;
            int y = this.cursorY * pixelHeight - 1;
            gc.drawRectangle(x, y, pixelWidth + 1, pixelHeight + 1);
        }
    }

    private void paintRangeSelection(GC gc) {
        gc.setForeground(Constants.BRIGHT_ORANGE);
        gc.setLineWidth(2);
        gc.setLineStyle(2);
        int zoomFactor = this.conf.getScaleFactor();
        int width = (this.tileRepositoryService.getSelectedTile().isMulticolorEnabled() ? 2 : 1) * zoomFactor;
        int x1 = this.selectedPixelRangeX;
        int x2 = this.selectedPixelRangeX2;
        int y1 = this.selectedPixelRangeY;
        int y2 = this.selectedPixelRangeY2;
        if (x1 != 0 || x2 != 0 || y1 != 0 || y2 != 0) {
            int v;
            if (x1 > x2) {
                v = x1;
                x1 = x2;
                x2 = v;
            }
            if (y1 > y2) {
                v = y1;
                y1 = y2;
                y2 = v;
            }
            gc.drawRectangle(x1 * this.conf.pixelPaintWidth * width, y1 * this.conf.pixelPaintHeight * zoomFactor, ((x2 - x1) * this.conf.pixelPaintWidth + this.conf.pixelPaintWidth) * width, ((y2 - y1) * this.conf.pixelPaintHeight + this.conf.pixelPaintHeight) * zoomFactor);
        }
    }

    public void setCursorMode(CursorMode cursorMode) {
        this.conf.cursorMode = cursorMode;
        Cursor cursor = this.getCursor();
        if (cursor != null) {
            cursor.dispose();
        }
        if (cursorMode == CursorMode.SelectRectangle) {
            this.setCursor(new Cursor((Device)this.getShell().getDisplay(), 2));
        } else if (cursorMode == CursorMode.Move) {
            this.setCursor(new Cursor((Device)this.getShell().getDisplay(), 5));
        } else {
            this.setCursor(new Cursor((Device)this.getShell().getDisplay(), 0));
            this.tileRepositoryService.setSelection(new Rectangle(0, 0, this.conf.tileWidth, this.conf.tileHeight));
        }
        this.doRedraw(RedrawMode.DrawSelectedTile, 1);
    }

    @Override
    public void redrawTiles(List<Integer> selectedTileIndexList, RedrawMode redrawMode, int action) {
        if (redrawMode == RedrawMode.DrawSelectedTile || redrawMode == RedrawMode.DrawSelectedTiles) {
            Tile tile = this.tileRepositoryService.getTile(selectedTileIndexList.get(0));
            if (this.tile != null) {
                this.tile.removeTileListener(this);
            }
            this.tile = tile;
            tile.addTileListener(this);
        } else if (redrawMode == RedrawMode.DrawTemporarySelectedTile) {
            this.temporaryIndex = selectedTileIndexList.get(0);
        }
        this.doRedraw(redrawMode, action);
        this.parent.setOrigin(this.tileRepositoryService.getSelectedTile().getOrigin());
    }

    public void setPixel(int x, int y, ImagingWidgetConfiguration conf) {
        Tile tile = this.tileRepositoryService.getSelectedTile();
        Layer layer = tile.getActiveLayer();
        String id = String.format("%s%sID%03X", tile.getId(), layer.getId(), 0);
        int x1 = this.lastCursorX;
        int y1 = this.lastCursorY;
        int x2 = this.lastCursorX + this.cursorDiffX;
        int y2 = this.lastCursorY + this.cursorDiffY;
        switch (conf.paintMode) {
            case Single: {
                this.drawLine(id, layer, x1, y1, x2, y2, conf);
                break;
            }
            case VerticalMirror: {
                this.drawLine(id, layer, x1, y1, x2, y2, conf);
                int centerX = conf.tileWidth / 2;
                int diffx1 = centerX - x1 - 1;
                int diffx2 = centerX - x2 - 1;
                this.drawLine(id, layer, centerX + diffx1, y1, centerX + diffx2, y2, conf);
                break;
            }
            case HorizontalMirror: {
                this.drawLine(id, layer, x1, y1, x2, y2, conf);
                int centerY = conf.tileHeight / 2;
                int diffy1 = centerY - y1 - 1;
                int diffy2 = centerY - y2 - 1;
                this.drawLine(id, layer, x1, centerY + diffy1, x2, centerY + diffy2, conf);
                break;
            }
            case Kaleidoscope: {
                this.drawLine(id, layer, x1, y1, x2, y2, conf);
                int centerX = conf.tileWidth / 2;
                int diffx1 = centerX - x1 - 1;
                int diffx2 = centerX - x2 - 1;
                this.drawLine(id, layer, centerX + diffx1, y1, centerX + diffx2, y2, conf);
                int centerY = conf.tileHeight / 2;
                int diffy1 = centerY - y1 - 1;
                int diffy2 = centerY - y2 - 1;
                this.drawLine(id, layer, x1, centerY + diffy1, x2, centerY + diffy2, conf);
                this.drawLine(id, layer, centerX + diffx1, centerY + diffy1, centerX + diffx2, centerY + diffy2, conf);
            }
        }
    }

    private void drawLine(String id, Layer layer, int x1, int y1, int x2, int y2, ImagingWidgetConfiguration conf) {
        int y;
        int x;
        if (x1 == x2 && y1 == y2) {
            x = x1;
            y = y1;
        } else {
            int dx = x2 - x1;
            int dy = y2 - y1;
            int xstep = 1;
            int ystep = 1;
            x = x1;
            y = y1;
            if (dx < 0) {
                dx = -dx;
                xstep = -1;
            }
            if (dy < 0) {
                dy = -dy;
                ystep = -1;
            }
            int a = dx + dx;
            int b = dy + dy;
            if (dy <= dx) {
                int error = -dx;
                while (x != x2) {
                    this.setPixel(id, layer, x, y, conf);
                    if ((error += b) > 0) {
                        y += ystep;
                        error -= a;
                    }
                    x += xstep;
                }
            } else {
                int error = -dy;
                while (y != y2) {
                    this.setPixel(id, layer, x, y, conf);
                    if ((error += a) > 0) {
                        x += xstep;
                        error -= b;
                    }
                    y += ystep;
                }
            }
        }
        this.setPixel(id, layer, x, y, conf);
    }

    private void drawCircleSection(String id, Layer layer, int xc, int yc, int x, int y) {
        this.setPixel(id, layer, xc + x, yc + y, this.conf);
        this.setPixel(id, layer, xc - x, yc + y, this.conf);
        this.setPixel(id, layer, xc + x, yc - y, this.conf);
        this.setPixel(id, layer, xc - x, yc - y, this.conf);
        this.setPixel(id, layer, xc + y, yc + x, this.conf);
        this.setPixel(id, layer, xc - y, yc + x, this.conf);
        this.setPixel(id, layer, xc + y, yc - x, this.conf);
        this.setPixel(id, layer, xc - y, yc - x, this.conf);
    }

    public void drawCircle(String id, Layer layer, int xc, int yc, int r) {
        int x = 0;
        int y = r;
        int d = 3 - 2 * r;
        this.drawCircleSection(id, layer, xc, yc, x, y);
        while (y >= x) {
            d = d > 0 ? d + 4 * (x - --y) + 10 : d + 4 * ++x + 6;
            this.drawCircleSection(id, layer, xc, yc, x, y);
        }
    }

    private void setPixel(String id, Layer layer, int x, int y, ImagingWidgetConfiguration conf) {
        if (x >= 0 && y >= 0 && x < conf.tileWidth && y < conf.tileHeight) {
            int colorIndex = -1;
            int colorId = 0;
            if (conf.pencilMode == PencilMode.Draw) {
                colorIndex = layer.getSelectedColorIndex();
                colorId = this.tileRepositoryService.getSelectedTile().getColorIndex(colorIndex);
            } else if (conf.pencilMode == PencilMode.Erase) {
                colorId = this.tileRepositoryService.getSelectedTile().getColorIndex(0);
            }
            int offset = y * conf.tileWidth + x * (this.tileRepositoryService.getSelectedTile().isMulticolorEnabled() ? 2 : 1);
            if (this.tileRepositoryService.getMetadata().getType().equals("PETSCII")) {
                layer.getContent()[offset] = colorId;
            } else {
                layer.getContent()[offset] = colorIndex;
                if (this.tileRepositoryService.getSelectedTile().isMulticolorEnabled()) {
                    layer.getContent()[offset + 1] = colorIndex;
                }
            }
            if (this.tileRepositoryReferenceService != null) {
                int i;
                int[] brush = layer.getBrush();
                if (brush == null) {
                    layer.resetBrush(layer.getContent().length, this.tileRepositoryService.getMetadata().getBlankValue());
                }
                layer.getBrush()[offset] = i = conf.pencilMode == PencilMode.Draw ? this.tileRepositoryReferenceService.getSelectedTileIndex(true) : this.tileRepositoryService.getMetadata().getBlankValue().intValue();
            }
            this.imagePainterFactory.createOrUpdateTilePixel(id, layer, x, y, false);
        }
    }

    @Override
    public void activeLayerChanged(int layer) {
        this.doRedraw(RedrawMode.DrawSelectedTile, 2);
    }

    @Override
    public void colorSelected(int colorNo, int paletteIndex) {
        System.out.printf("colorNo:%d  palette:%d\n", colorNo, paletteIndex);
        Tile tile = this.tileRepositoryService.getSelectedTile();
        this.tileRepositoryService.setDirty(true);
        if (colorNo == 0) {
            this.imagePainterFactory.setBackgroundColorIndex(paletteIndex);
        } else {
            this.imagePainterFactory.setForegroundColorIndex(paletteIndex);
        }
        tile.setActiveLayerColorIndex(colorNo, paletteIndex, true);
    }

    @Override
    public void redrawCalculatedArea() {
        this.redraw();
    }

    @Override
    public Point computeSize(int wHint, int hHint, boolean changed) {
        return new Point(wHint, hHint);
    }
}

