/*
 * Decompiled with CFR 0.152.
 */
package de.drazil.nerdsuite.widget;

import de.drazil.nerdsuite.Constants;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.internal.DPIUtil;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;

public class MemoryViewWidget
extends Canvas
implements PaintListener {
    private Image image = null;
    private int width = 660;
    private int height = 960;
    private Image[] imageCache = new Image[512];

    public MemoryViewWidget(Composite parent, int style) {
        super(parent, style);
        this.prepareImage(this.width, this.height);
        this.prepareImageCache();
        this.addPaintListener(this);
    }

    private void prepareImageCache() {
        int zoom = DPIUtil.getDeviceZoom();
        double mul = 1.0;
        if (zoom > 100) {
            double zf = 100.0 / (double)zoom;
            mul = 1.0 / zf;
        }
        int i = 0;
        while (i < 256) {
            Image imgGreen = new Image((Device)this.getDisplay(), (int)(8.0 * mul), (int)(1.0 * mul));
            Image imgRed = new Image((Device)this.getDisplay(), (int)(8.0 * mul), (int)(1.0 * mul));
            GC gcGreen = new GC((Drawable)imgGreen);
            GC gcRed = new GC((Drawable)imgRed);
            int v = 1;
            int x = 7;
            while (v < 256) {
                if (mul == 1.0) {
                    if ((i & v) == v) {
                        gcGreen.setForeground(Constants.GREEN);
                        gcRed.setForeground(Constants.RED);
                    } else {
                        gcGreen.setForeground(Constants.BLACK);
                        gcRed.setForeground(Constants.BLACK);
                    }
                } else if ((i & v) == v) {
                    gcGreen.setBackground(Constants.GREEN);
                    gcRed.setBackground(Constants.RED);
                } else {
                    gcGreen.setBackground(Constants.BLACK);
                    gcRed.setBackground(Constants.BLACK);
                }
                if (mul == 2.0) {
                    gcGreen.fillRectangle(x, 0, 2, 2);
                    gcRed.fillRectangle(x, 0, 2, 2);
                } else {
                    gcGreen.drawPoint(x, 0);
                    gcRed.drawPoint(x, 0);
                }
                v <<= 1;
                --x;
            }
            this.imageCache[i] = imgGreen;
            this.imageCache[i + 256] = imgRed;
            gcGreen.dispose();
            gcRed.dispose();
            ++i;
        }
    }

    private void prepareImage(int width, int height) {
        this.image = new Image((Device)this.getDisplay(), width, 960);
        GC gc = new GC((Drawable)this.image);
        gc.setBackground(Constants.BLACK);
        gc.fillRectangle(0, 0, width, 960);
        gc.setForeground(Constants.WHITE);
        int from = 0;
        int x = 0;
        while (x < 2) {
            int y = 0;
            while (y < 4) {
                String s = String.format("%04x-%04x", from, from + 8191);
                gc.drawString(s, x * 330, 210 + y * 230);
                from += 8192;
                ++y;
            }
            ++x;
        }
        gc.dispose();
    }

    public void paintControl(PaintEvent e) {
        e.gc.drawImage(this.image, 0, 0);
    }

    public void setByte(int address, int value, boolean rw) {
        int segmentStartY = address / 8192 % 4 * 230;
        int segmentStartX = address / 32768 * 330;
        int si = address % 8192;
        int x = segmentStartX + si / 8 % 40 * 8;
        int y = segmentStartY + (si % 8 + si / 320 * 8);
        GC gc = new GC((Drawable)this.image);
        gc.drawImage(this.imageCache[value + (rw ? 0 : 256)], x, y);
        gc.dispose();
        this.redraw(x, y, 8, 1, false);
    }

    public Point computeSize(int wHint, int hHint, boolean changed) {
        return new Point(this.width, this.height);
    }
}

