/*
 * Decompiled with CFR 0.152.
 */
package de.drazil.nerdsuite.widget;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import de.drazil.nerdsuite.json.IntArrayToStringConverter;
import de.drazil.nerdsuite.json.StringToIntArrayConverter;
import de.drazil.nerdsuite.model.DirtyableImage;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class Layer {
    @JsonProperty(value="id")
    private String id;
    @JsonProperty(value="name")
    private String name;
    @JsonSerialize(converter=IntArrayToStringConverter.class)
    @JsonDeserialize(converter=StringToIntArrayConverter.class)
    @JsonProperty(value="content")
    private int[] content = null;
    @JsonSerialize(converter=IntArrayToStringConverter.class)
    @JsonDeserialize(converter=StringToIntArrayConverter.class)
    @JsonProperty(value="brush")
    private int[] brush = null;
    @JsonProperty(value="active")
    private boolean active = false;
    @JsonProperty(value="locked")
    private boolean locked = false;
    @JsonProperty(value="visible")
    private boolean visible = true;
    @JsonProperty(value="deleted")
    private boolean deleted = false;
    @JsonProperty(value="selectedColorIndex")
    private int selectedColorIndex = 1;
    @JsonProperty(value="colorPalette")
    private List<Integer> colorPalette = new ArrayList<Integer>();
    @JsonIgnore
    private Map<String, DirtyableImage> imagePool = new HashMap<String, DirtyableImage>();
    @JsonIgnore
    private boolean dirty = true;

    public Layer() {
    }

    public Layer(String id, String name, int size, Integer brushValue) {
        this();
        this.id = id;
        this.name = name;
        this.reset(size, brushValue);
    }

    @JsonIgnore
    public void putImage(DirtyableImage image) {
        this.putImage(this.id, image);
    }

    @JsonIgnore
    public void putImage(String id, DirtyableImage image) {
        this.imagePool.put(id, image);
    }

    @JsonIgnore
    public DirtyableImage getImage(String id) {
        return this.imagePool.get(id);
    }

    @JsonIgnore
    public void removeImage() {
        this.removeImage(this.id);
    }

    @JsonIgnore
    public void removeImage(String id) {
        this.imagePool.get(id).dispose();
        this.imagePool.remove(id);
    }

    @JsonIgnore
    public int getSize() {
        return this.content.length;
    }

    @JsonIgnore
    public void reset(int size, Integer brushValue) {
        this.resetContent(size);
        this.resetBrush(size, brushValue);
    }

    @JsonIgnore
    public void resetBrush(int size, Integer blankValue) {
        if (blankValue != null) {
            this.brush = new int[size];
            Arrays.fill(this.brush, blankValue);
        }
    }

    @JsonIgnore
    public void resetContent(int contentLength) {
        this.content = new int[contentLength];
        Arrays.fill(this.content, 0);
    }

    public String getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public int[] getContent() {
        return this.content;
    }

    public int[] getBrush() {
        return this.brush;
    }

    public boolean isActive() {
        return this.active;
    }

    public boolean isLocked() {
        return this.locked;
    }

    public boolean isVisible() {
        return this.visible;
    }

    public boolean isDeleted() {
        return this.deleted;
    }

    public int getSelectedColorIndex() {
        return this.selectedColorIndex;
    }

    public List<Integer> getColorPalette() {
        return this.colorPalette;
    }

    public Map<String, DirtyableImage> getImagePool() {
        return this.imagePool;
    }

    public boolean isDirty() {
        return this.dirty;
    }

    @JsonProperty(value="id")
    public void setId(String id) {
        this.id = id;
    }

    @JsonProperty(value="name")
    public void setName(String name) {
        this.name = name;
    }

    @JsonDeserialize(converter=StringToIntArrayConverter.class)
    @JsonProperty(value="content")
    public void setContent(int[] content) {
        this.content = content;
    }

    @JsonDeserialize(converter=StringToIntArrayConverter.class)
    @JsonProperty(value="brush")
    public void setBrush(int[] brush) {
        this.brush = brush;
    }

    @JsonProperty(value="active")
    public void setActive(boolean active) {
        this.active = active;
    }

    @JsonProperty(value="locked")
    public void setLocked(boolean locked) {
        this.locked = locked;
    }

    @JsonProperty(value="visible")
    public void setVisible(boolean visible) {
        this.visible = visible;
    }

    @JsonProperty(value="deleted")
    public void setDeleted(boolean deleted) {
        this.deleted = deleted;
    }

    @JsonProperty(value="selectedColorIndex")
    public void setSelectedColorIndex(int selectedColorIndex) {
        this.selectedColorIndex = selectedColorIndex;
    }

    @JsonProperty(value="colorPalette")
    public void setColorPalette(List<Integer> colorPalette) {
        this.colorPalette = colorPalette;
    }

    @JsonIgnore
    public void setImagePool(Map<String, DirtyableImage> imagePool) {
        this.imagePool = imagePool;
    }

    @JsonIgnore
    public void setDirty(boolean dirty) {
        this.dirty = dirty;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Layer)) {
            return false;
        }
        Layer other = (Layer)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.isActive() != other.isActive()) {
            return false;
        }
        if (this.isLocked() != other.isLocked()) {
            return false;
        }
        if (this.isVisible() != other.isVisible()) {
            return false;
        }
        if (this.isDeleted() != other.isDeleted()) {
            return false;
        }
        if (this.getSelectedColorIndex() != other.getSelectedColorIndex()) {
            return false;
        }
        if (this.isDirty() != other.isDirty()) {
            return false;
        }
        String this$id = this.getId();
        String other$id = other.getId();
        if (this$id == null ? other$id != null : !this$id.equals(other$id)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        if (!Arrays.equals(this.getContent(), other.getContent())) {
            return false;
        }
        if (!Arrays.equals(this.getBrush(), other.getBrush())) {
            return false;
        }
        List<Integer> this$colorPalette = this.getColorPalette();
        List<Integer> other$colorPalette = other.getColorPalette();
        if (this$colorPalette == null ? other$colorPalette != null : !((Object)this$colorPalette).equals(other$colorPalette)) {
            return false;
        }
        Map<String, DirtyableImage> this$imagePool = this.getImagePool();
        Map<String, DirtyableImage> other$imagePool = other.getImagePool();
        return !(this$imagePool == null ? other$imagePool != null : !((Object)this$imagePool).equals(other$imagePool));
    }

    protected boolean canEqual(Object other) {
        return other instanceof Layer;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isActive() ? 79 : 97);
        result = result * 59 + (this.isLocked() ? 79 : 97);
        result = result * 59 + (this.isVisible() ? 79 : 97);
        result = result * 59 + (this.isDeleted() ? 79 : 97);
        result = result * 59 + this.getSelectedColorIndex();
        result = result * 59 + (this.isDirty() ? 79 : 97);
        String $id = this.getId();
        result = result * 59 + ($id == null ? 43 : $id.hashCode());
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        result = result * 59 + Arrays.hashCode(this.getContent());
        result = result * 59 + Arrays.hashCode(this.getBrush());
        List<Integer> $colorPalette = this.getColorPalette();
        result = result * 59 + ($colorPalette == null ? 43 : ((Object)$colorPalette).hashCode());
        Map<String, DirtyableImage> $imagePool = this.getImagePool();
        result = result * 59 + ($imagePool == null ? 43 : ((Object)$imagePool).hashCode());
        return result;
    }

    public String toString() {
        return "Layer(id=" + this.getId() + ", name=" + this.getName() + ", content=" + Arrays.toString(this.getContent()) + ", brush=" + Arrays.toString(this.getBrush()) + ", active=" + this.isActive() + ", locked=" + this.isLocked() + ", visible=" + this.isVisible() + ", deleted=" + this.isDeleted() + ", selectedColorIndex=" + this.getSelectedColorIndex() + ", colorPalette=" + this.getColorPalette() + ", imagePool=" + this.getImagePool() + ", dirty=" + this.isDirty() + ")";
    }
}

