/*
 * Decompiled with CFR 0.152.
 */
package de.drazil.nerdsuite.widget;

import de.drazil.nerdsuite.Constants;
import de.drazil.nerdsuite.model.Key;
import de.drazil.nerdsuite.model.PlatformColor;
import de.drazil.nerdsuite.widget.IHitKeyListener;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.MouseTrackAdapter;
import org.eclipse.swt.events.MouseTrackListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;

public class KeyboardElement
extends Canvas
implements PaintListener {
    private static final int SIZE = 30;
    private Key key;
    private int calculatedSize;
    private Color backgroundColor;
    private List<IHitKeyListener> list;
    private boolean mouseIn = false;
    private List<PlatformColor> colorList;

    public KeyboardElement(Composite parent, int style, final Key key, List<PlatformColor> colorList) {
        super(parent, style);
        this.colorList = colorList;
        this.list = new ArrayList<IHitKeyListener>();
        this.key = key;
        this.calculatedSize = (int)(30.0 * key.getSize());
        this.backgroundColor = this.getDefaultBackgroundColor();
        if (key.isSymbol()) {
            this.setFont(Constants.GoogleMaterials);
        } else {
            this.setFont(Constants.C64_Pro_Mono_FONT_12);
        }
        this.addPaintListener(this);
        this.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseUp(MouseEvent e) {
            }

            public void mouseDown(MouseEvent e) {
                if (key.isToggleButton()) {
                    key.setToggleState(!key.isToggleState());
                    KeyboardElement.this.backgroundColor = key.isToggleState() ? Constants.BRIGHT_ORANGE : Constants.DARK_GREY;
                    KeyboardElement.this.fireHitKey(key);
                } else {
                    KeyboardElement.this.fireHitKey(key);
                }
                KeyboardElement.this.redraw();
            }
        });
        this.addMouseTrackListener((MouseTrackListener)new MouseTrackAdapter(){

            public void mouseEnter(MouseEvent e) {
                KeyboardElement.this.mouseIn = true;
                KeyboardElement.this.backgroundColor = key.isToggleButton() && key.isToggleState() ? Constants.BRIGHT_ORANGE : KeyboardElement.this.getDefaultBackgroundColor();
                KeyboardElement.this.redraw();
            }

            public void mouseExit(MouseEvent e) {
                KeyboardElement.this.mouseIn = false;
                KeyboardElement.this.backgroundColor = key.isToggleButton() && key.isToggleState() ? Constants.BRIGHT_ORANGE : KeyboardElement.this.getDefaultBackgroundColor();
                KeyboardElement.this.redraw();
            }
        });
    }

    public void paintControl(PaintEvent e) {
        if (!this.key.getType().equals("FILLER")) {
            e.gc.setBackground(this.backgroundColor);
            e.gc.fillRoundRectangle(2, 2, this.calculatedSize - 4, 26, 5, 5);
            e.gc.setForeground(Constants.WHITE);
            if (!this.key.getType().equals("KEY") && !this.key.getType().equals("COLOR")) {
                Point textBounds = e.gc.stringExtent(this.key.getText());
                int xText = (this.calculatedSize - textBounds.x) / 2;
                int yText = (30 - textBounds.y) / 2;
                e.gc.drawString(this.key.getText(), xText, yText);
            } else {
                Point textBounds = e.gc.stringExtent(this.key.getDisplay());
                int xText = (this.calculatedSize - textBounds.x) / 2;
                int yText = (30 - textBounds.y) / 2;
                if ((this.key.getOptionState() & 8) == 8 && !this.key.isSymbol()) {
                    e.gc.setBackground(Constants.DARK_GREY);
                    e.gc.fillRectangle(xText, yText, textBounds.x, textBounds.y);
                }
                e.gc.drawString(this.key.getDisplay(), xText, yText);
                if ((this.key.getOptionState() & 8) == 8 && !this.key.isSymbol()) {
                    e.gc.setForeground(Constants.WHITE);
                    e.gc.drawRectangle(xText - 1, yText - 1, textBounds.x + 1, textBounds.y + 1);
                }
            }
            if (this.mouseIn) {
                e.gc.setForeground(Constants.BRIGHT_ORANGE);
                e.gc.setLineWidth(3);
                e.gc.drawRoundRectangle(3, 3, this.calculatedSize - 6, 24, 3, 3);
            }
        }
    }

    public Point getDimension() {
        return new Point(this.calculatedSize, 30);
    }

    private Color getDefaultBackgroundColor() {
        return this.key.getType().equals("COLOR") && this.key.getIndex() != null ? this.colorList.get(this.key.getIndex()).getColor() : Constants.DARK_GREY;
    }

    public Point computeSize(int wHint, int hHint) {
        int width = wHint != -1 ? Math.min(wHint, this.calculatedSize) : this.calculatedSize;
        int height = hHint != -1 ? Math.min(hHint, 30) : 30;
        return new Point(width, height);
    }

    public void addHitKeyListener(IHitKeyListener listener) {
        this.list.add(listener);
    }

    public void removeHitKeyListener(IHitKeyListener listener) {
        this.list.remove(listener);
    }

    private void fireHitKey(Key key) {
        this.list.forEach(k -> k.keyPressed(key));
    }

    public void refresh() {
        this.redraw();
    }
}

