/*
 * Decompiled with CFR 0.152.
 */
package de.drazil.nerdsuite.widget;

import de.drazil.nerdsuite.enums.CursorMode;
import de.drazil.nerdsuite.enums.GridType;
import de.drazil.nerdsuite.enums.PaintMode;
import de.drazil.nerdsuite.enums.PencilMode;
import de.drazil.nerdsuite.enums.PixelConfig;
import de.drazil.nerdsuite.enums.TileSelectionModes;
import de.drazil.nerdsuite.model.GraphicMetadata;
import de.drazil.nerdsuite.model.ViewSetup;

public class ImagingWidgetConfiguration
implements TileSelectionModes {
    public static final int AUTOMATIC = -1;
    public String owner;
    public int tileGap = 0;
    public int storageSize = 0;
    public int iconSize;
    public int tileSize;
    public int tileSizePixel;
    public int columns = 1;
    public int rows = 1;
    public int iconWidth;
    public int iconHeight;
    public int tileRows;
    public int tileColumns;
    public int tileHeight;
    public int tileWidth;
    public int tileWidthPixel;
    public int tileHeightPixel;
    public int fullWidthPixel;
    public int fullHeightPixel;
    public int pixelWidth = 1;
    public int pixelHeight = 1;
    public int pixelSize = 1;
    public int pixelPaintWidth = 1;
    public int pixelPaintHeight = 1;
    public int painterScaledTileWith = 1;
    public int painterScaledTileHeight = 1;
    public int repositoryScaledTileWith = 1;
    public int repositoryScaledTileHeight = 1;
    public int cursorLineWidth = 1;
    public int scaleFactor = 1;
    public int tileSelectionModes = 0;
    public boolean pixelGridEnabled = true;
    public boolean tileGridEnabled = true;
    public boolean tileSubGridEnabled = true;
    public boolean tileCursorEnabled = false;
    public boolean separatorEnabled = true;
    public boolean layerViewEnabled = false;
    public boolean televisionModeEnabled = false;
    public PixelConfig pixelConfig = PixelConfig.BC1;
    public PaintMode paintMode = PaintMode.Single;
    public PencilMode pencilMode = PencilMode.Draw;
    public GridType gridType = GridType.Line;
    public CursorMode cursorMode = CursorMode.Point;
    public ViewSetup viewSetup;

    public ImagingWidgetConfiguration(GraphicMetadata metadata) {
        this.iconWidth = metadata.getWidth();
        this.iconHeight = metadata.getHeight();
        this.tileColumns = metadata.getColumns();
        this.tileRows = metadata.getRows();
        this.storageSize = metadata.getStorageEntity();
    }

    public void computeDimensions() {
        this.pixelPaintWidth = this.pixelSize;
        this.pixelPaintHeight = this.pixelSize;
        this.iconSize = this.iconHeight * this.iconWidth;
        this.tileSize = this.iconSize * this.tileColumns * this.tileRows;
        this.tileWidth = this.iconWidth * this.tileColumns;
        this.tileHeight = this.iconHeight * this.tileRows;
        this.tileWidthPixel = this.tileWidth * this.pixelPaintWidth;
        this.tileHeightPixel = this.tileHeight * this.pixelPaintHeight;
        if (this.rows == -1 && this.columns > 0) {
            this.fullWidthPixel = this.tileWidthPixel * this.columns + this.columns * this.tileGap - this.tileGap;
            this.rows = this.fullWidthPixel / this.columns;
            this.fullHeightPixel = this.tileHeightPixel * this.rows + this.rows * this.tileGap - this.tileGap;
        } else if (this.columns == -1 && this.rows > 0) {
            this.fullHeightPixel = this.tileHeightPixel * this.rows + this.rows * this.tileGap - this.tileGap;
            this.columns = this.fullHeightPixel / this.rows;
            this.fullWidthPixel = this.tileWidthPixel * this.columns + this.columns * this.tileGap - this.tileGap;
        } else {
            this.fullWidthPixel = this.tileWidthPixel * this.columns + this.columns * this.tileGap - this.tileGap;
            this.fullHeightPixel = this.tileHeightPixel * this.rows + this.rows * this.tileGap - this.tileGap;
        }
        double thumbnailScaleFactor = 1.0;
        if (this.tileWidthPixel >= 100) {
            thumbnailScaleFactor = 100.0f / (float)this.tileWidthPixel;
        } else {
            if (this.tileWidthPixel <= 48) {
                thumbnailScaleFactor = 1.0;
            }
            if (this.tileWidthPixel <= 24) {
                thumbnailScaleFactor = 2.0;
            }
            if (this.tileWidthPixel <= 16) {
                thumbnailScaleFactor = 3.0;
            }
        }
        this.painterScaledTileWith = this.tileWidthPixel * this.scaleFactor;
        this.painterScaledTileHeight = this.tileHeightPixel * this.scaleFactor;
        this.repositoryScaledTileWith = (int)((double)this.tileWidthPixel * thumbnailScaleFactor);
        this.repositoryScaledTileHeight = (int)((double)this.tileHeightPixel * thumbnailScaleFactor);
    }

    public String getOwner() {
        return this.owner;
    }

    public int getTileGap() {
        return this.tileGap;
    }

    public int getStorageSize() {
        return this.storageSize;
    }

    public int getIconSize() {
        return this.iconSize;
    }

    public int getTileSize() {
        return this.tileSize;
    }

    public int getTileSizePixel() {
        return this.tileSizePixel;
    }

    public int getColumns() {
        return this.columns;
    }

    public int getRows() {
        return this.rows;
    }

    public int getIconWidth() {
        return this.iconWidth;
    }

    public int getIconHeight() {
        return this.iconHeight;
    }

    public int getTileRows() {
        return this.tileRows;
    }

    public int getTileColumns() {
        return this.tileColumns;
    }

    public int getTileHeight() {
        return this.tileHeight;
    }

    public int getTileWidth() {
        return this.tileWidth;
    }

    public int getTileWidthPixel() {
        return this.tileWidthPixel;
    }

    public int getTileHeightPixel() {
        return this.tileHeightPixel;
    }

    public int getFullWidthPixel() {
        return this.fullWidthPixel;
    }

    public int getFullHeightPixel() {
        return this.fullHeightPixel;
    }

    public int getPixelWidth() {
        return this.pixelWidth;
    }

    public int getPixelHeight() {
        return this.pixelHeight;
    }

    public int getPixelSize() {
        return this.pixelSize;
    }

    public int getPixelPaintWidth() {
        return this.pixelPaintWidth;
    }

    public int getPixelPaintHeight() {
        return this.pixelPaintHeight;
    }

    public int getPainterScaledTileWith() {
        return this.painterScaledTileWith;
    }

    public int getPainterScaledTileHeight() {
        return this.painterScaledTileHeight;
    }

    public int getRepositoryScaledTileWith() {
        return this.repositoryScaledTileWith;
    }

    public int getRepositoryScaledTileHeight() {
        return this.repositoryScaledTileHeight;
    }

    public int getCursorLineWidth() {
        return this.cursorLineWidth;
    }

    public int getScaleFactor() {
        return this.scaleFactor;
    }

    public int getTileSelectionModes() {
        return this.tileSelectionModes;
    }

    public boolean isPixelGridEnabled() {
        return this.pixelGridEnabled;
    }

    public boolean isTileGridEnabled() {
        return this.tileGridEnabled;
    }

    public boolean isTileSubGridEnabled() {
        return this.tileSubGridEnabled;
    }

    public boolean isTileCursorEnabled() {
        return this.tileCursorEnabled;
    }

    public boolean isSeparatorEnabled() {
        return this.separatorEnabled;
    }

    public boolean isLayerViewEnabled() {
        return this.layerViewEnabled;
    }

    public boolean isTelevisionModeEnabled() {
        return this.televisionModeEnabled;
    }

    public PixelConfig getPixelConfig() {
        return this.pixelConfig;
    }

    public PaintMode getPaintMode() {
        return this.paintMode;
    }

    public PencilMode getPencilMode() {
        return this.pencilMode;
    }

    public GridType getGridType() {
        return this.gridType;
    }

    public CursorMode getCursorMode() {
        return this.cursorMode;
    }

    public ViewSetup getViewSetup() {
        return this.viewSetup;
    }

    public void setOwner(String owner) {
        this.owner = owner;
    }

    public void setTileGap(int tileGap) {
        this.tileGap = tileGap;
    }

    public void setStorageSize(int storageSize) {
        this.storageSize = storageSize;
    }

    public void setIconSize(int iconSize) {
        this.iconSize = iconSize;
    }

    public void setTileSize(int tileSize) {
        this.tileSize = tileSize;
    }

    public void setTileSizePixel(int tileSizePixel) {
        this.tileSizePixel = tileSizePixel;
    }

    public void setColumns(int columns) {
        this.columns = columns;
    }

    public void setRows(int rows) {
        this.rows = rows;
    }

    public void setIconWidth(int iconWidth) {
        this.iconWidth = iconWidth;
    }

    public void setIconHeight(int iconHeight) {
        this.iconHeight = iconHeight;
    }

    public void setTileRows(int tileRows) {
        this.tileRows = tileRows;
    }

    public void setTileColumns(int tileColumns) {
        this.tileColumns = tileColumns;
    }

    public void setTileHeight(int tileHeight) {
        this.tileHeight = tileHeight;
    }

    public void setTileWidth(int tileWidth) {
        this.tileWidth = tileWidth;
    }

    public void setTileWidthPixel(int tileWidthPixel) {
        this.tileWidthPixel = tileWidthPixel;
    }

    public void setTileHeightPixel(int tileHeightPixel) {
        this.tileHeightPixel = tileHeightPixel;
    }

    public void setFullWidthPixel(int fullWidthPixel) {
        this.fullWidthPixel = fullWidthPixel;
    }

    public void setFullHeightPixel(int fullHeightPixel) {
        this.fullHeightPixel = fullHeightPixel;
    }

    public void setPixelWidth(int pixelWidth) {
        this.pixelWidth = pixelWidth;
    }

    public void setPixelHeight(int pixelHeight) {
        this.pixelHeight = pixelHeight;
    }

    public void setPixelSize(int pixelSize) {
        this.pixelSize = pixelSize;
    }

    public void setPixelPaintWidth(int pixelPaintWidth) {
        this.pixelPaintWidth = pixelPaintWidth;
    }

    public void setPixelPaintHeight(int pixelPaintHeight) {
        this.pixelPaintHeight = pixelPaintHeight;
    }

    public void setPainterScaledTileWith(int painterScaledTileWith) {
        this.painterScaledTileWith = painterScaledTileWith;
    }

    public void setPainterScaledTileHeight(int painterScaledTileHeight) {
        this.painterScaledTileHeight = painterScaledTileHeight;
    }

    public void setRepositoryScaledTileWith(int repositoryScaledTileWith) {
        this.repositoryScaledTileWith = repositoryScaledTileWith;
    }

    public void setRepositoryScaledTileHeight(int repositoryScaledTileHeight) {
        this.repositoryScaledTileHeight = repositoryScaledTileHeight;
    }

    public void setCursorLineWidth(int cursorLineWidth) {
        this.cursorLineWidth = cursorLineWidth;
    }

    public void setScaleFactor(int scaleFactor) {
        this.scaleFactor = scaleFactor;
    }

    public void setTileSelectionModes(int tileSelectionModes) {
        this.tileSelectionModes = tileSelectionModes;
    }

    public void setPixelGridEnabled(boolean pixelGridEnabled) {
        this.pixelGridEnabled = pixelGridEnabled;
    }

    public void setTileGridEnabled(boolean tileGridEnabled) {
        this.tileGridEnabled = tileGridEnabled;
    }

    public void setTileSubGridEnabled(boolean tileSubGridEnabled) {
        this.tileSubGridEnabled = tileSubGridEnabled;
    }

    public void setTileCursorEnabled(boolean tileCursorEnabled) {
        this.tileCursorEnabled = tileCursorEnabled;
    }

    public void setSeparatorEnabled(boolean separatorEnabled) {
        this.separatorEnabled = separatorEnabled;
    }

    public void setLayerViewEnabled(boolean layerViewEnabled) {
        this.layerViewEnabled = layerViewEnabled;
    }

    public void setTelevisionModeEnabled(boolean televisionModeEnabled) {
        this.televisionModeEnabled = televisionModeEnabled;
    }

    public void setPixelConfig(PixelConfig pixelConfig) {
        this.pixelConfig = pixelConfig;
    }

    public void setPaintMode(PaintMode paintMode) {
        this.paintMode = paintMode;
    }

    public void setPencilMode(PencilMode pencilMode) {
        this.pencilMode = pencilMode;
    }

    public void setGridType(GridType gridType) {
        this.gridType = gridType;
    }

    public void setCursorMode(CursorMode cursorMode) {
        this.cursorMode = cursorMode;
    }

    public void setViewSetup(ViewSetup viewSetup) {
        this.viewSetup = viewSetup;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ImagingWidgetConfiguration)) {
            return false;
        }
        ImagingWidgetConfiguration other = (ImagingWidgetConfiguration)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getTileGap() != other.getTileGap()) {
            return false;
        }
        if (this.getStorageSize() != other.getStorageSize()) {
            return false;
        }
        if (this.getIconSize() != other.getIconSize()) {
            return false;
        }
        if (this.getTileSize() != other.getTileSize()) {
            return false;
        }
        if (this.getTileSizePixel() != other.getTileSizePixel()) {
            return false;
        }
        if (this.getColumns() != other.getColumns()) {
            return false;
        }
        if (this.getRows() != other.getRows()) {
            return false;
        }
        if (this.getIconWidth() != other.getIconWidth()) {
            return false;
        }
        if (this.getIconHeight() != other.getIconHeight()) {
            return false;
        }
        if (this.getTileRows() != other.getTileRows()) {
            return false;
        }
        if (this.getTileColumns() != other.getTileColumns()) {
            return false;
        }
        if (this.getTileHeight() != other.getTileHeight()) {
            return false;
        }
        if (this.getTileWidth() != other.getTileWidth()) {
            return false;
        }
        if (this.getTileWidthPixel() != other.getTileWidthPixel()) {
            return false;
        }
        if (this.getTileHeightPixel() != other.getTileHeightPixel()) {
            return false;
        }
        if (this.getFullWidthPixel() != other.getFullWidthPixel()) {
            return false;
        }
        if (this.getFullHeightPixel() != other.getFullHeightPixel()) {
            return false;
        }
        if (this.getPixelWidth() != other.getPixelWidth()) {
            return false;
        }
        if (this.getPixelHeight() != other.getPixelHeight()) {
            return false;
        }
        if (this.getPixelSize() != other.getPixelSize()) {
            return false;
        }
        if (this.getPixelPaintWidth() != other.getPixelPaintWidth()) {
            return false;
        }
        if (this.getPixelPaintHeight() != other.getPixelPaintHeight()) {
            return false;
        }
        if (this.getPainterScaledTileWith() != other.getPainterScaledTileWith()) {
            return false;
        }
        if (this.getPainterScaledTileHeight() != other.getPainterScaledTileHeight()) {
            return false;
        }
        if (this.getRepositoryScaledTileWith() != other.getRepositoryScaledTileWith()) {
            return false;
        }
        if (this.getRepositoryScaledTileHeight() != other.getRepositoryScaledTileHeight()) {
            return false;
        }
        if (this.getCursorLineWidth() != other.getCursorLineWidth()) {
            return false;
        }
        if (this.getScaleFactor() != other.getScaleFactor()) {
            return false;
        }
        if (this.getTileSelectionModes() != other.getTileSelectionModes()) {
            return false;
        }
        if (this.isPixelGridEnabled() != other.isPixelGridEnabled()) {
            return false;
        }
        if (this.isTileGridEnabled() != other.isTileGridEnabled()) {
            return false;
        }
        if (this.isTileSubGridEnabled() != other.isTileSubGridEnabled()) {
            return false;
        }
        if (this.isTileCursorEnabled() != other.isTileCursorEnabled()) {
            return false;
        }
        if (this.isSeparatorEnabled() != other.isSeparatorEnabled()) {
            return false;
        }
        if (this.isLayerViewEnabled() != other.isLayerViewEnabled()) {
            return false;
        }
        if (this.isTelevisionModeEnabled() != other.isTelevisionModeEnabled()) {
            return false;
        }
        String this$owner = this.getOwner();
        String other$owner = other.getOwner();
        if (this$owner == null ? other$owner != null : !this$owner.equals(other$owner)) {
            return false;
        }
        PixelConfig this$pixelConfig = this.getPixelConfig();
        PixelConfig other$pixelConfig = other.getPixelConfig();
        if (this$pixelConfig == null ? other$pixelConfig != null : !((Object)((Object)this$pixelConfig)).equals((Object)other$pixelConfig)) {
            return false;
        }
        PaintMode this$paintMode = this.getPaintMode();
        PaintMode other$paintMode = other.getPaintMode();
        if (this$paintMode == null ? other$paintMode != null : !((Object)((Object)this$paintMode)).equals((Object)other$paintMode)) {
            return false;
        }
        PencilMode this$pencilMode = this.getPencilMode();
        PencilMode other$pencilMode = other.getPencilMode();
        if (this$pencilMode == null ? other$pencilMode != null : !((Object)((Object)this$pencilMode)).equals((Object)other$pencilMode)) {
            return false;
        }
        GridType this$gridType = this.getGridType();
        GridType other$gridType = other.getGridType();
        if (this$gridType == null ? other$gridType != null : !((Object)((Object)this$gridType)).equals((Object)other$gridType)) {
            return false;
        }
        CursorMode this$cursorMode = this.getCursorMode();
        CursorMode other$cursorMode = other.getCursorMode();
        if (this$cursorMode == null ? other$cursorMode != null : !((Object)((Object)this$cursorMode)).equals((Object)other$cursorMode)) {
            return false;
        }
        ViewSetup this$viewSetup = this.getViewSetup();
        ViewSetup other$viewSetup = other.getViewSetup();
        return !(this$viewSetup == null ? other$viewSetup != null : !((Object)this$viewSetup).equals(other$viewSetup));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ImagingWidgetConfiguration;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getTileGap();
        result = result * 59 + this.getStorageSize();
        result = result * 59 + this.getIconSize();
        result = result * 59 + this.getTileSize();
        result = result * 59 + this.getTileSizePixel();
        result = result * 59 + this.getColumns();
        result = result * 59 + this.getRows();
        result = result * 59 + this.getIconWidth();
        result = result * 59 + this.getIconHeight();
        result = result * 59 + this.getTileRows();
        result = result * 59 + this.getTileColumns();
        result = result * 59 + this.getTileHeight();
        result = result * 59 + this.getTileWidth();
        result = result * 59 + this.getTileWidthPixel();
        result = result * 59 + this.getTileHeightPixel();
        result = result * 59 + this.getFullWidthPixel();
        result = result * 59 + this.getFullHeightPixel();
        result = result * 59 + this.getPixelWidth();
        result = result * 59 + this.getPixelHeight();
        result = result * 59 + this.getPixelSize();
        result = result * 59 + this.getPixelPaintWidth();
        result = result * 59 + this.getPixelPaintHeight();
        result = result * 59 + this.getPainterScaledTileWith();
        result = result * 59 + this.getPainterScaledTileHeight();
        result = result * 59 + this.getRepositoryScaledTileWith();
        result = result * 59 + this.getRepositoryScaledTileHeight();
        result = result * 59 + this.getCursorLineWidth();
        result = result * 59 + this.getScaleFactor();
        result = result * 59 + this.getTileSelectionModes();
        result = result * 59 + (this.isPixelGridEnabled() ? 79 : 97);
        result = result * 59 + (this.isTileGridEnabled() ? 79 : 97);
        result = result * 59 + (this.isTileSubGridEnabled() ? 79 : 97);
        result = result * 59 + (this.isTileCursorEnabled() ? 79 : 97);
        result = result * 59 + (this.isSeparatorEnabled() ? 79 : 97);
        result = result * 59 + (this.isLayerViewEnabled() ? 79 : 97);
        result = result * 59 + (this.isTelevisionModeEnabled() ? 79 : 97);
        String $owner = this.getOwner();
        result = result * 59 + ($owner == null ? 43 : $owner.hashCode());
        PixelConfig $pixelConfig = this.getPixelConfig();
        result = result * 59 + ($pixelConfig == null ? 43 : ((Object)((Object)$pixelConfig)).hashCode());
        PaintMode $paintMode = this.getPaintMode();
        result = result * 59 + ($paintMode == null ? 43 : ((Object)((Object)$paintMode)).hashCode());
        PencilMode $pencilMode = this.getPencilMode();
        result = result * 59 + ($pencilMode == null ? 43 : ((Object)((Object)$pencilMode)).hashCode());
        GridType $gridType = this.getGridType();
        result = result * 59 + ($gridType == null ? 43 : ((Object)((Object)$gridType)).hashCode());
        CursorMode $cursorMode = this.getCursorMode();
        result = result * 59 + ($cursorMode == null ? 43 : ((Object)((Object)$cursorMode)).hashCode());
        ViewSetup $viewSetup = this.getViewSetup();
        result = result * 59 + ($viewSetup == null ? 43 : ((Object)$viewSetup).hashCode());
        return result;
    }

    public String toString() {
        return "ImagingWidgetConfiguration(owner=" + this.getOwner() + ", tileGap=" + this.getTileGap() + ", storageSize=" + this.getStorageSize() + ", iconSize=" + this.getIconSize() + ", tileSize=" + this.getTileSize() + ", tileSizePixel=" + this.getTileSizePixel() + ", columns=" + this.getColumns() + ", rows=" + this.getRows() + ", iconWidth=" + this.getIconWidth() + ", iconHeight=" + this.getIconHeight() + ", tileRows=" + this.getTileRows() + ", tileColumns=" + this.getTileColumns() + ", tileHeight=" + this.getTileHeight() + ", tileWidth=" + this.getTileWidth() + ", tileWidthPixel=" + this.getTileWidthPixel() + ", tileHeightPixel=" + this.getTileHeightPixel() + ", fullWidthPixel=" + this.getFullWidthPixel() + ", fullHeightPixel=" + this.getFullHeightPixel() + ", pixelWidth=" + this.getPixelWidth() + ", pixelHeight=" + this.getPixelHeight() + ", pixelSize=" + this.getPixelSize() + ", pixelPaintWidth=" + this.getPixelPaintWidth() + ", pixelPaintHeight=" + this.getPixelPaintHeight() + ", painterScaledTileWith=" + this.getPainterScaledTileWith() + ", painterScaledTileHeight=" + this.getPainterScaledTileHeight() + ", repositoryScaledTileWith=" + this.getRepositoryScaledTileWith() + ", repositoryScaledTileHeight=" + this.getRepositoryScaledTileHeight() + ", cursorLineWidth=" + this.getCursorLineWidth() + ", scaleFactor=" + this.getScaleFactor() + ", tileSelectionModes=" + this.getTileSelectionModes() + ", pixelGridEnabled=" + this.isPixelGridEnabled() + ", tileGridEnabled=" + this.isTileGridEnabled() + ", tileSubGridEnabled=" + this.isTileSubGridEnabled() + ", tileCursorEnabled=" + this.isTileCursorEnabled() + ", separatorEnabled=" + this.isSeparatorEnabled() + ", layerViewEnabled=" + this.isLayerViewEnabled() + ", televisionModeEnabled=" + this.isTelevisionModeEnabled() + ", pixelConfig=" + (Object)((Object)this.getPixelConfig()) + ", paintMode=" + (Object)((Object)this.getPaintMode()) + ", pencilMode=" + (Object)((Object)this.getPencilMode()) + ", gridType=" + (Object)((Object)this.getGridType()) + ", cursorMode=" + (Object)((Object)this.getCursorMode()) + ", viewSetup=" + this.getViewSetup() + ")";
    }
}

