/*
 * Decompiled with CFR 0.152.
 */
package de.drazil.nerdsuite.widget;

import de.drazil.nerdsuite.util.ImageFactory;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.PaletteData;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;

public class ImageViewWidget
extends Canvas
implements PaintListener {
    private List<ID> buffer;
    private PaletteData paletteData;
    private int scaledWidth;
    private int scaledHeight;
    private boolean showDummy = true;
    private int skipCount;

    public ImageViewWidget(Composite parent, int style, PaletteData paletteData) {
        super(parent, style);
        this.paletteData = paletteData;
        this.buffer = new ArrayList<ID>();
        this.addPaintListener(this);
        this.getParent().addListener(11, new Listener(){

            public void handleEvent(Event event) {
                ImageViewWidget.this.scaledHeight = ImageViewWidget.this.getParent().getSize().y;
                ImageViewWidget.this.scaledWidth = (int)((double)ImageViewWidget.this.getParent().getSize().y * 1.411);
                ImageViewWidget.this.getParent().layout(true, true);
            }
        });
    }

    public void paintControl(PaintEvent e) {
        try {
            if (!this.showDummy) {
                ID id;
                if (this.skipCount > 0) {
                    --this.skipCount;
                    this.buffer.remove(0);
                }
                if (!this.buffer.isEmpty() && this.buffer.size() > 10 && this.skipCount == 0 && !(id = this.buffer.get(0)).isProcessed()) {
                    ImageData imageData = id.getImageData();
                    int i = 0;
                    while (i < imageData.data.length) {
                        imageData.data[i] = (byte)((imageData.data[i] & 0xF) << 4 | (imageData.data[i] & 0xF0) >> 4);
                        ++i;
                    }
                    if ((double)this.getParent().getSize().y / (double)this.getParent().getSize().x < (double)0.8f) {
                        ratio = (double)this.getParent().getSize().y / (double)id.getImageData().height;
                        this.scaledWidth = (int)((double)id.getImageData().width * ratio);
                        this.scaledHeight = this.getParent().getSize().y;
                    } else {
                        ratio = (double)this.getParent().getSize().x / (double)id.getImageData().width;
                        this.scaledWidth = this.getParent().getSize().x;
                        this.scaledHeight = (int)((double)id.getImageData().height * ratio);
                    }
                    Image image = new Image((Device)this.getDisplay(), id.getImageData());
                    e.gc.drawImage(image, 0, 0);
                    image.dispose();
                    this.buffer.remove(0);
                    id.setProcessed(true);
                }
            } else {
                this.skipCount = 20;
                ImageData imageData = ImageFactory.createImage("images/FuBK-Testbild.png").getImageData();
                double ratio = (double)this.getParent().getSize().y / (double)imageData.height;
                this.scaledWidth = (int)((double)imageData.width * ratio);
                this.scaledHeight = this.getParent().getSize().y;
                Image image = new Image((Device)this.getDisplay(), imageData.scaledTo(this.scaledWidth, this.scaledHeight));
                e.gc.drawImage(image, 0, 0);
                image.dispose();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void addImageData(byte[] data) {
        ImageData id = new ImageData(384, 272, 4, this.paletteData, 2, data);
        this.buffer.add(new ID(id));
    }

    public void drawImage(boolean showDummy) {
        if (!this.isDisposed()) {
            this.scaledWidth = this.getClientArea().width;
            this.scaledHeight = this.getClientArea().height;
            this.showDummy = showDummy;
            this.redraw(0, 0, this.scaledWidth, this.scaledHeight, false);
            this.update();
        }
    }

    public Point computeSize(int wHint, int hHint, boolean changed) {
        return new Point(this.scaledWidth, this.scaledHeight);
    }

    private class ID {
        private boolean processed;
        private ImageData imageData;

        public ID(ImageData imageData) {
            this.imageData = imageData;
            this.processed = false;
        }

        public boolean isProcessed() {
            return this.processed;
        }

        public ImageData getImageData() {
            return this.imageData;
        }

        public void setProcessed(boolean processed) {
            this.processed = processed;
        }

        public void setImageData(ImageData imageData) {
            this.imageData = imageData;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ID)) {
                return false;
            }
            ID other = (ID)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (this.isProcessed() != other.isProcessed()) {
                return false;
            }
            ImageData this$imageData = this.getImageData();
            ImageData other$imageData = other.getImageData();
            return !(this$imageData == null ? other$imageData != null : !this$imageData.equals(other$imageData));
        }

        protected boolean canEqual(Object other) {
            return other instanceof ID;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + (this.isProcessed() ? 79 : 97);
            ImageData $imageData = this.getImageData();
            result = result * 59 + ($imageData == null ? 43 : $imageData.hashCode());
            return result;
        }

        public String toString() {
            return "ImageViewWidget.ID(processed=" + this.isProcessed() + ", imageData=" + this.getImageData() + ")";
        }
    }
}

