/*
 * Decompiled with CFR 0.152.
 */
package de.drazil.nerdsuite.widget;

import de.drazil.nerdsuite.Constants;
import de.drazil.nerdsuite.cpu.decode.HexViewContent;
import de.drazil.nerdsuite.cpu.decode.InstructionLine;
import de.drazil.nerdsuite.cpu.platform.IPlatform;
import de.drazil.nerdsuite.log.Console;
import de.drazil.nerdsuite.model.DisassemblingRange;
import de.drazil.nerdsuite.model.RangeType;
import de.drazil.nerdsuite.model.Value;
import de.drazil.nerdsuite.util.BinaryFileHandler;
import de.drazil.nerdsuite.widget.IContentProvider;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Stack;
import java.util.stream.Collectors;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.swt.custom.LineStyleEvent;
import org.eclipse.swt.custom.LineStyleListener;
import org.eclipse.swt.custom.StyleRange;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.custom.StyledTextContent;
import org.eclipse.swt.custom.TableEditor;
import org.eclipse.swt.dnd.DropTargetAdapter;
import org.eclipse.swt.dnd.DropTargetEvent;
import org.eclipse.swt.dnd.DropTargetListener;
import org.eclipse.swt.dnd.FileTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.MouseMoveListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontMetrics;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;

public class HexViewWidget
extends Composite
implements IContentProvider {
    private byte[] content = null;
    private StyledText addressArea = null;
    private StyledText hexArea = null;
    private StyledText textArea = null;
    private Button autoDiscover;
    private Button startAddress;
    private Button code;
    private Button binary;
    private int contentOffset = 0;
    private int visibleRows = 0;
    private IPlatform platform;
    private List<DisassemblingRange> rangeList;
    private DisassemblingRange selectedRange = null;
    private boolean enableSelect = false;
    private boolean dragStarted = false;
    private int selectStartOffset = 0;
    private TableViewer tableViewer;
    private Value pc;
    private Stack<InstructionLine> jumpStack;
    private static StyleRange[] hexStyleRangeList = new StyleRange[32];

    static {
        int i = 0;
        while (i < 32) {
            HexViewWidget.hexStyleRangeList[i] = new StyleRange(0, 2, Constants.HEXVIEW_ODD_COLUMN_FG_COLOR, Constants.HEXVIEW_ODD_COLUMN_BG_COLOR);
            HexViewWidget.hexStyleRangeList[i + 1] = new StyleRange(0, 2, Constants.HEXVIEW_EVEN_COLUMN_FG_COLOR, Constants.HEXVIEW_EVEN_COLUMN_BG_COLOR);
            i += 2;
        }
    }

    public HexViewWidget(Composite parent, int style, IPlatform platform) {
        super(parent, style);
        this.platform = platform;
        this.rangeList = new ArrayList<DisassemblingRange>();
        this.jumpStack = new Stack();
        this.selectedRange = new DisassemblingRange(0, 0, false, RangeType.Binary);
        this.initialize();
    }

    private static boolean isPrintableCharacter(char c) {
        return c >= ' ' && c < '\u007f';
    }

    @Override
    public byte[] getContentArray() {
        return this.content;
    }

    @Override
    public byte getContentAtOffset(int index) {
        return this.content[this.contentOffset + index];
    }

    @Override
    public int getContentOffset() {
        return this.contentOffset;
    }

    @Override
    public int getContentLength() {
        return this.content.length - this.contentOffset;
    }

    public Composite getDisassemblyView() {
        return this.tableViewer.getTable();
    }

    public Composite getBinaryView() {
        return this.hexArea;
    }

    public void jumpToAddress() {
        IStructuredSelection selection = (IStructuredSelection)this.tableViewer.getSelection();
        InstructionLine line = (InstructionLine)selection.getFirstElement();
        InstructionLine refLine = this.platform.getCPU().findInstructionLineByProgrammCounter(line.getReferenceValue());
        if (refLine == null) {
            MessageBox message = new MessageBox(this.getParent().getShell(), 40);
            message.setMessage(String.format("0x%04x is currently unreachable!", line.getReferenceValue().getValue()));
            message.setText("Target unreachable");
            message.open();
        } else {
            this.selectInstruction(refLine);
            this.jumpStack.push(line);
        }
    }

    public void returnToOrigin() {
        if (!this.jumpStack.isEmpty()) {
            this.selectInstruction(this.jumpStack.pop());
        } else {
            MessageBox message = new MessageBox(this.getParent().getShell(), 34);
            message.setMessage("Base origin already reached!");
            message.setText("Base origin reached");
            message.open();
        }
    }

    private void selectInstruction(InstructionLine line) {
        int index = this.platform.getCPU().getIndexOf(line);
        this.tableViewer.setSelection((ISelection)new StructuredSelection(this.tableViewer.getElementAt(index)), true);
        this.tableViewer.getTable().showSelection();
    }

    public void setLabel(String name) {
    }

    public void setBinaryContent(byte[] binaryContent) {
        this.content = binaryContent;
        this.rangeList = new ArrayList<DisassemblingRange>();
        this.rangeList.add(new DisassemblingRange(0, this.content.length, false, RangeType.Binary));
        this.prepareContent();
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                GC fontGC = new GC((Drawable)Display.getCurrent());
                int fontHeight = 0;
                try {
                    fontGC.setFont(Constants.EDITOR_FONT);
                    FontMetrics fm = fontGC.getFontMetrics();
                    fontHeight = fm.getHeight();
                }
                finally {
                    fontGC.dispose();
                }
                HexViewWidget.this.visibleRows = HexViewWidget.this.getClientArea().height / fontHeight;
                HexViewWidget.this.getVerticalBar().setMinimum(0);
                HexViewWidget.this.getVerticalBar().setMaximum(HexViewWidget.this.hexArea.getLineCount());
                HexViewWidget.this.getVerticalBar().setSelection(0);
                HexViewWidget.this.getVerticalBar().setThumb(HexViewWidget.this.visibleRows);
                HexViewWidget.this.getVerticalBar().setPageIncrement(HexViewWidget.this.visibleRows);
                HexViewWidget.this.addressArea.redraw();
                HexViewWidget.this.hexArea.redraw();
                HexViewWidget.this.textArea.redraw();
                HexViewWidget.this.pc = HexViewWidget.this.platform.checkAdress(HexViewWidget.this.content, 0);
                if (HexViewWidget.this.pc != null && HexViewWidget.this.pc.getValue() > 0) {
                    MessageBox message = new MessageBox(HexViewWidget.this.getParent().getShell(), 196);
                    message.setMessage(String.format("Found potential StartAddress 0x%04x\nApply it?", HexViewWidget.this.pc.getValue()));
                    message.setText("StartAddress found");
                    if (message.open() == 64) {
                        HexViewWidget.this.startAddress.setSelection(true);
                        HexViewWidget.this.platform.setProgrammCounter(new Value(HexViewWidget.this.pc.getValue()));
                    }
                }
                HexViewWidget.this.prepareContent();
            }
        });
    }

    private void disassemble() {
        if (this.selectedRange.getLen() > 0) {
            this.platform.getCPU().clear();
            this.handleSelection(this.selectedRange.getOffset(), this.selectedRange.getLen(), this.selectedRange.getRangeType());
            Console.println("> ----------------------------------------------");
            Console.printf("> range count :%d\n", this.rangeList.size());
            int i = 0;
            while (i < this.rangeList.size()) {
                int offset = this.pc.getValue() + this.rangeList.get(i).getOffset();
                Console.printf("> %04d : %04x - %04x %s\n", i, offset, offset + this.rangeList.get(i).getLen() - 1, this.rangeList.get(i).getRangeType().toString());
                ++i;
            }
            this.hexArea.redraw();
            this.textArea.redraw();
            if (this.pc != null) {
                this.platform.setProgrammCounter(new Value(this.pc.getValue()));
                this.platform.parseBinary(this, this.rangeList);
                this.tableViewer.setInput(this.platform.getCPU().getInstructionLineList());
            }
        }
    }

    private void handleSelection(int start, int length, RangeType rangeType) {
        DisassemblingRange range = this.rangeList.stream().filter(r -> start >= r.getOffset() && start + length <= r.getOffset() + r.getLen()).findFirst().orElse(null);
        if (range != null) {
            if (rangeType != range.getRangeType()) {
                range.setDirty(true);
                if (start == range.getOffset() && length == range.getLen()) {
                    range.setRangeType(rangeType);
                    Console.println("> simply change rangetype.");
                } else {
                    int oldStart = range.getOffset();
                    int oldLength = range.getLen();
                    int rangeIndex = this.rangeList.indexOf(range);
                    int croppedLength = start - range.getOffset();
                    int indexOffset = 1;
                    if (croppedLength == 0) {
                        indexOffset = 0;
                        this.rangeList.remove(rangeIndex);
                    }
                    range.setLen(croppedLength);
                    range.setDirty(true);
                    this.rangeList.add(rangeIndex + indexOffset++, new DisassemblingRange(start, length, true, rangeType));
                    this.rangeList.add(rangeIndex + indexOffset++, new DisassemblingRange(start + length, oldStart + oldLength - (start + length), true, range.getRangeType()));
                }
            } else {
                Console.println("> skip setting new range due to equality.");
            }
        } else {
            List ranges = this.rangeList.stream().filter(r -> start < r.getOffset() + r.getLen() && start + length > r.getOffset()).collect(Collectors.toList());
            for (DisassemblingRange r2 : ranges) {
                if (ranges.indexOf(r2) <= 0 || ranges.indexOf(r2) >= ranges.size() - 1) continue;
                this.rangeList.remove(r2);
            }
            DisassemblingRange topRange = (DisassemblingRange)ranges.get(0);
            DisassemblingRange bottomRange = (DisassemblingRange)ranges.get(ranges.size() - 1);
            topRange.setDirty(true);
            bottomRange.setDirty(true);
            if (topRange.getRangeType() == bottomRange.getRangeType() && topRange.getRangeType() == rangeType) {
                int newLength = bottomRange.getOffset() + bottomRange.getLen() - topRange.getOffset();
                this.rangeList.remove(bottomRange);
                topRange.setLen(newLength);
            } else if (topRange.getRangeType() == rangeType && topRange.getRangeType() != bottomRange.getRangeType()) {
                bottomRange.setLen(bottomRange.getOffset() + bottomRange.getLen() - (start + length));
                bottomRange.setOffset(start + length);
                topRange.setLen(start + length - topRange.getOffset());
            } else if (bottomRange.getRangeType() == rangeType && topRange.getRangeType() != bottomRange.getRangeType()) {
                topRange.setLen(start - topRange.getOffset());
                bottomRange.setLen(bottomRange.getOffset() + bottomRange.getLen() - start);
                bottomRange.setOffset(start);
            } else if (topRange.getRangeType() == bottomRange.getRangeType() && topRange.getRangeType() != rangeType) {
                topRange.setLen(start - topRange.getOffset());
                bottomRange.setLen(bottomRange.getOffset() + bottomRange.getLen() - (start + length));
                bottomRange.setOffset(start + length);
                int insertIndex = this.rangeList.indexOf(topRange) + 1;
                this.rangeList.add(insertIndex, new DisassemblingRange(start, length, true, rangeType));
            } else {
                Console.println("> should not happen.");
            }
        }
    }

    private void prepareContent() {
        int b = 0;
        int memoryOffset = 0;
        this.platform.setIgnoreStartAddressBytes(true);
        if (this.startAddress.getSelection()) {
            this.platform.setIgnoreStartAddressBytes(false);
            this.contentOffset = 2;
            memoryOffset = this.platform.getCPU().getWord(this.content, 0);
        } else {
            this.contentOffset = 0;
        }
        StringBuilder sbByte = null;
        StringBuilder sbText = null;
        StringBuilder sbAdress = null;
        sbByte = new StringBuilder();
        sbText = new StringBuilder();
        sbAdress = new StringBuilder();
        while (b < this.getContentLength()) {
            if (b % 16 == 0) {
                sbAdress.append(String.format("%04x:", memoryOffset + b));
            }
            byte c = this.getContentAtOffset(b);
            sbByte.append(String.format("%02x", c));
            sbText.append((char)(HexViewWidget.isPrintableCharacter((char)c) ? (int)c : 95));
            ++b;
        }
        this.hexArea.getContent().setText(sbByte.toString());
        this.textArea.getContent().setText(sbText.toString());
        this.addressArea.getContent().setText(sbAdress.toString());
        this.hexArea.redraw();
        this.textArea.redraw();
    }

    private void updateArea(final int offset) {
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                HexViewWidget.this.addressArea.setTopIndex(offset);
                HexViewWidget.this.hexArea.setTopIndex(offset);
                HexViewWidget.this.textArea.setTopIndex(offset);
            }
        });
    }

    private void initialize() {
        this.getVerticalBar().addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                e.doit = false;
                int offset = HexViewWidget.this.getVerticalBar().getSelection();
                HexViewWidget.this.updateArea(offset);
            }
        });
        GridLayout layout = new GridLayout(4, false);
        this.setLayout((Layout)layout);
        GridData gd = null;
        gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.verticalAlignment = 4;
        gd.grabExcessVerticalSpace = true;
        gd.grabExcessHorizontalSpace = true;
        gd.verticalSpan = 2;
        this.tableViewer = new TableViewer((Composite)this, 67584);
        this.tableViewer.getTable().setLinesVisible(true);
        this.tableViewer.setCellEditors(new CellEditor[]{new TextCellEditor((Composite)this.tableViewer.getTable())});
        this.tableViewer.setColumnProperties(new String[]{"ADDRESS", "LABEL", "DISASSEMBLY"});
        TableViewerColumn tableViewerColumnAddress = new TableViewerColumn(this.tableViewer, 0);
        TableViewerColumn tableViewerColumnLabel = new TableViewerColumn(this.tableViewer, 0);
        TableViewerColumn tableViewerColumnCode = new TableViewerColumn(this.tableViewer, 0);
        ColumnLabelProvider labelProviderAddress = new ColumnLabelProvider(){

            public String getText(Object element) {
                InstructionLine il = (InstructionLine)element;
                Object[] userObject = (Object[])il.getUserObject();
                String s = "";
                if (userObject != null) {
                    s = String.format("%s", userObject[1]);
                }
                return s;
            }

            public Font getFont(Object element) {
                return Constants.EDITOR_FONT;
            }
        };
        ColumnLabelProvider labelProviderLabel = new ColumnLabelProvider(){

            public String getText(Object element) {
                InstructionLine il = (InstructionLine)element;
                Object[] userObject = (Object[])il.getUserObject();
                String s = "";
                if (userObject != null) {
                    s = String.format("%s", userObject[2]);
                }
                return s;
            }

            public Font getFont(Object element) {
                return Constants.EDITOR_FONT;
            }
        };
        ColumnLabelProvider labelProviderCode = new ColumnLabelProvider(){

            public String getText(Object element) {
                InstructionLine il = (InstructionLine)element;
                Object[] userObject = (Object[])il.getUserObject();
                String s = "";
                if (userObject != null) {
                    if (userObject[0].equals(RangeType.Code.toString())) {
                        s = String.format("%-13s %s %-15s %s", userObject[3], userObject[4], userObject[5], userObject[6]);
                    } else if (userObject[0].equals(RangeType.Binary.toString())) {
                        s = String.format("%s", userObject[3]);
                    }
                }
                return s;
            }

            public Font getFont(Object element) {
                return Constants.EDITOR_FONT;
            }
        };
        tableViewerColumnAddress.setLabelProvider((CellLabelProvider)labelProviderAddress);
        tableViewerColumnLabel.setLabelProvider((CellLabelProvider)labelProviderLabel);
        tableViewerColumnCode.setLabelProvider((CellLabelProvider)labelProviderCode);
        TableColumn addressLine = tableViewerColumnAddress.getColumn();
        addressLine.setWidth(50);
        TableColumn labelLine = tableViewerColumnLabel.getColumn();
        labelLine.setWidth(200);
        TableColumn codeLine = tableViewerColumnCode.getColumn();
        codeLine.setWidth(500);
        this.tableViewer.setContentProvider((org.eclipse.jface.viewers.IContentProvider)new ArrayContentProvider());
        this.tableViewer.getTable().setLayoutData((Object)gd);
        final TableEditor editor = new TableEditor(this.tableViewer.getTable());
        editor.horizontalAlignment = 16384;
        editor.grabHorizontal = true;
        this.tableViewer.getTable().addListener(3, new Listener(){

            public void handleEvent(Event event) {
                Rectangle clientArea = HexViewWidget.this.tableViewer.getTable().getClientArea();
                Point pt = new Point(event.x, event.y);
                int index = HexViewWidget.this.tableViewer.getTable().getTopIndex();
                while (index < HexViewWidget.this.tableViewer.getTable().getItemCount()) {
                    boolean visible = false;
                    final TableItem item = HexViewWidget.this.tableViewer.getTable().getItem(index);
                    Rectangle rect = item.getBounds(1);
                    if (rect.contains(pt)) {
                        final Text text = new Text((Composite)HexViewWidget.this.tableViewer.getTable(), 0);
                        text.setFont(Constants.C64_Pro_Mono_FONT);
                        Listener textListener = new Listener(){

                            public void handleEvent(Event e) {
                                switch (e.type) {
                                    case 16: {
                                        item.setText(1, text.getText());
                                        text.dispose();
                                        break;
                                    }
                                    case 31: {
                                        switch (e.detail) {
                                            case 4: {
                                                item.setText(1, text.getText());
                                                ((InstructionLine)item.getData()).setLabelName(text.getText());
                                            }
                                            case 2: {
                                                text.dispose();
                                                e.doit = false;
                                            }
                                        }
                                    }
                                }
                            }
                        };
                        text.addListener(16, textListener);
                        text.addListener(31, textListener);
                        editor.setEditor((Control)text, item, 1);
                        text.setText(item.getText(1));
                        text.selectAll();
                        text.setFocus();
                        return;
                    }
                    if (!visible && rect.intersects(clientArea)) {
                        visible = true;
                    }
                    if (!visible) {
                        return;
                    }
                    ++index;
                }
            }
        });
        Transfer[] types = new Transfer[]{FileTransfer.getInstance()};
        this.tableViewer.addDropSupport(3, types, (DropTargetListener)new DropTargetAdapter(){

            public void drop(DropTargetEvent event) {
                String fileName = ((String[])event.data)[0].toString();
                byte[] content = null;
                try {
                    content = BinaryFileHandler.readFile(new File(fileName), 0);
                    HexViewWidget.this.setBinaryContent(content);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        });
        gd = new GridData();
        gd.horizontalAlignment = 1;
        gd.verticalAlignment = 4;
        gd.grabExcessVerticalSpace = false;
        gd.grabExcessHorizontalSpace = false;
        gd.horizontalSpan = 3;
        GridLayout layout2 = new GridLayout(4, false);
        Composite c = new Composite((Composite)this, 0);
        c.setLayout((Layout)layout2);
        GridData gd2 = new GridData();
        gd2.horizontalAlignment = 1;
        gd2.horizontalSpan = 1;
        gd2.grabExcessHorizontalSpace = false;
        this.autoDiscover = new Button(c, 32);
        this.autoDiscover.setText("AutoDiscover Mode");
        this.autoDiscover.setLayoutData((Object)gd2);
        gd2 = new GridData();
        gd2.horizontalAlignment = 1;
        gd2.horizontalSpan = 1;
        gd2.grabExcessHorizontalSpace = false;
        this.startAddress = new Button(c, 32);
        this.startAddress.setText("First two bytes represent StartAddress");
        this.startAddress.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
            }
        });
        gd2 = new GridData();
        gd2.horizontalAlignment = 1;
        gd2.horizontalSpan = 4;
        Group group = new Group(c, 0);
        group.setLayout((Layout)new RowLayout(256));
        group.setLayoutData((Object)gd2);
        this.code = new Button((Composite)group, 16);
        this.code.setBackground(Constants.CODE_COLOR);
        this.code.setForeground(Constants.WHITE);
        this.code.setText("Code");
        this.code.setSelection(true);
        this.code.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                HexViewWidget.this.selectedRange.setRangeType(RangeType.Code);
                HexViewWidget.this.hexArea.setSelectionForeground(Constants.WHITE);
                HexViewWidget.this.textArea.setSelectionForeground(Constants.WHITE);
                HexViewWidget.this.hexArea.setSelectionBackground(Constants.CODE_COLOR);
                HexViewWidget.this.textArea.setSelectionBackground(Constants.CODE_COLOR);
            }
        });
        this.binary = new Button((Composite)group, 16);
        this.binary.setText("Binary");
        this.binary.setBackground(Constants.BINARY_COLOR);
        this.binary.setForeground(Constants.WHITE);
        this.binary.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                HexViewWidget.this.selectedRange.setRangeType(RangeType.Binary);
                HexViewWidget.this.hexArea.setSelectionForeground(Constants.WHITE);
                HexViewWidget.this.textArea.setSelectionForeground(Constants.WHITE);
                HexViewWidget.this.hexArea.setSelectionBackground(Constants.BINARY_COLOR);
                HexViewWidget.this.textArea.setSelectionBackground(Constants.BINARY_COLOR);
            }
        });
        this.selectedRange.setRangeType(this.code.getSelection() ? RangeType.Code : (this.binary.getSelection() ? RangeType.Binary : RangeType.Unspecified));
        c.setLayoutData((Object)gd);
        gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.verticalAlignment = 4;
        gd.widthHint = 40;
        gd.grabExcessVerticalSpace = false;
        gd.grabExcessHorizontalSpace = false;
        this.addressArea = new StyledText((Composite)this, 8);
        this.addressArea.setEditable(false);
        this.addressArea.setEnabled(false);
        this.addressArea.setContent((StyledTextContent)new HexViewContent(5));
        this.addressArea.setFont(Constants.EDITOR_FONT);
        this.addressArea.setLayoutData((Object)gd);
        gd = new GridData();
        gd.horizontalAlignment = 1;
        gd.verticalAlignment = 4;
        gd.widthHint = 208;
        gd.grabExcessVerticalSpace = false;
        gd.grabExcessHorizontalSpace = false;
        this.hexArea = new StyledText((Composite)this, 0);
        this.hexArea.setFont(Constants.EDITOR_FONT);
        this.hexArea.setSelectionBackground(Constants.CODE_COLOR);
        this.hexArea.setContent((StyledTextContent)new HexViewContent(32));
        this.hexArea.addLineStyleListener(new LineStyleListener(){

            public void lineGetStyle(LineStyleEvent event) {
                event.styles = HexViewWidget.this.getStyleRanges(2, event);
            }
        });
        this.hexArea.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDown(MouseEvent e) {
                if (e.button == 1) {
                    HexViewWidget.this.enableSelect = true;
                    HexViewWidget.this.dragStarted = false;
                    HexViewWidget.this.selectStartOffset = HexViewWidget.this.hexArea.getCaretOffset();
                }
            }

            public void mouseUp(MouseEvent e) {
                if (e.button == 1) {
                    if (HexViewWidget.this.enableSelect && HexViewWidget.this.dragStarted) {
                        HexViewWidget.this.disassemble();
                    }
                    HexViewWidget.this.enableSelect = false;
                    HexViewWidget.this.dragStarted = false;
                }
                HexViewWidget.this.textArea.setSelection(0, 0);
                HexViewWidget.this.hexArea.setSelection(0, 0);
            }
        });
        this.hexArea.addMouseMoveListener(new MouseMoveListener(){

            public void mouseMove(MouseEvent e) {
                if (HexViewWidget.this.enableSelect) {
                    HexViewWidget.this.dragStarted = true;
                    int start = HexViewWidget.this.selectStartOffset;
                    int end = HexViewWidget.this.hexArea.getCaretOffset();
                    if (start > end) {
                        int x = end;
                        end = start;
                        start = x;
                    }
                    if (start % 2 != 0) {
                        --start;
                    }
                    if (end % 2 != 0) {
                        ++end;
                    }
                    int length = end - start;
                    int sstart = start >> 1;
                    int slength = length >> 1;
                    HexViewWidget.this.hexArea.setSelectionRange(start, length);
                    HexViewWidget.this.textArea.setSelectionRange(sstart, slength);
                    HexViewWidget.this.selectedRange.setOffset(sstart);
                    HexViewWidget.this.selectedRange.setLen(slength);
                }
            }
        });
        this.hexArea.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                HexViewWidget.this.addressArea.setTopIndex(HexViewWidget.this.hexArea.getTopIndex());
                HexViewWidget.this.textArea.setTopIndex(HexViewWidget.this.hexArea.getTopIndex());
                HexViewWidget.this.getVerticalBar().setSelection(HexViewWidget.this.hexArea.getTopIndex());
            }
        });
        this.hexArea.setLayoutData((Object)gd);
        gd = new GridData();
        gd.horizontalAlignment = 1;
        gd.verticalAlignment = 4;
        gd.widthHint = 104;
        gd.grabExcessVerticalSpace = false;
        gd.grabExcessHorizontalSpace = false;
        this.textArea = new StyledText((Composite)this, 0);
        this.textArea.setFont(Constants.EDITOR_FONT);
        this.textArea.setSelectionBackground(Constants.CODE_COLOR);
        this.textArea.setContent((StyledTextContent)new HexViewContent(16));
        this.textArea.addLineStyleListener(new LineStyleListener(){

            public void lineGetStyle(LineStyleEvent event) {
                event.styles = HexViewWidget.this.getStyleRanges(1, event);
            }
        });
        this.textArea.setLayoutData((Object)gd);
        this.textArea.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDown(MouseEvent e) {
                if (e.button == 1) {
                    HexViewWidget.this.enableSelect = true;
                    HexViewWidget.this.dragStarted = false;
                    HexViewWidget.this.selectStartOffset = HexViewWidget.this.textArea.getCaretOffset();
                }
            }

            public void mouseUp(MouseEvent e) {
                if (e.button == 1) {
                    if (HexViewWidget.this.enableSelect && HexViewWidget.this.dragStarted) {
                        HexViewWidget.this.disassemble();
                    }
                    HexViewWidget.this.enableSelect = false;
                    HexViewWidget.this.dragStarted = false;
                    HexViewWidget.this.textArea.setSelection(0, 0);
                    HexViewWidget.this.hexArea.setSelection(0, 0);
                }
            }
        });
        this.textArea.addMouseMoveListener(new MouseMoveListener(){

            public void mouseMove(MouseEvent e) {
                if (HexViewWidget.this.enableSelect) {
                    HexViewWidget.this.dragStarted = true;
                    int start = HexViewWidget.this.selectStartOffset;
                    int end = HexViewWidget.this.textArea.getCaretOffset();
                    if (start > end) {
                        int x = end;
                        end = start;
                        start = x;
                    }
                    int length = end - start;
                    HexViewWidget.this.hexArea.setSelectionRange(start << 1, length << 1);
                    HexViewWidget.this.textArea.setSelectionRange(start, length);
                    HexViewWidget.this.selectedRange.setOffset(start);
                    HexViewWidget.this.selectedRange.setLen(length);
                }
            }
        });
        this.textArea.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                HexViewWidget.this.addressArea.setTopIndex(HexViewWidget.this.textArea.getTopIndex());
                HexViewWidget.this.textArea.setTopIndex(HexViewWidget.this.textArea.getTopIndex());
                HexViewWidget.this.getVerticalBar().setSelection(HexViewWidget.this.textArea.getTopIndex());
            }
        });
    }

    private StyleRange[] getStyleRanges(int width, LineStyleEvent event) {
        ArrayList<StyleRange> list = new ArrayList<StyleRange>();
        StyleRange styleRange = null;
        Color fgc = Constants.BLACK;
        Color bgc = null;
        if (width == 2) {
            for (DisassemblingRange range : this.rangeList) {
                switch (range.getRangeType()) {
                    case Code: {
                        bgc = Constants.CODE_COLOR;
                        break;
                    }
                    case Binary: {
                        bgc = Constants.WHITE;
                        break;
                    }
                    default: {
                        bgc = Constants.WHITE;
                    }
                }
                styleRange = new StyleRange(range.getOffset() * width, range.getLen() * width, fgc, bgc);
                list.add(styleRange);
            }
        }
        return list.toArray(new StyleRange[list.size()]);
    }
}

