/*
 * Decompiled with CFR 0.152.
 */
package de.drazil.nerdsuite.widget;

import de.drazil.nerdsuite.Constants;
import de.drazil.nerdsuite.mouse.AdvancedMouseAdaper;
import de.drazil.nerdsuite.mouse.IAdvancedMouseListener;
import de.drazil.nerdsuite.mouse.IAdvancedMouseMoveListener;
import de.drazil.nerdsuite.mouse.IAdvancedMouseTrackListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Shell;

public class CustomShell
implements IAdvancedMouseMoveListener,
IAdvancedMouseListener,
IAdvancedMouseTrackListener,
PaintListener {
    private Shell shell;
    private AdvancedMouseAdaper ama;
    private boolean leftPressed = false;
    private boolean onHeader = false;
    private boolean oldHeader = false;
    private int xp;
    private int yp;

    public void open(Composite composite) {
        this.shell = new Shell(composite.getShell(), 536887304);
        this.shell.setSize(200, 200);
        this.shell.addPaintListener((PaintListener)this);
        this.shell.setBackground(Constants.LIGHT_BLUE);
        this.ama = new AdvancedMouseAdaper((Composite)this.shell);
        this.ama.addMouseListener(this);
        this.ama.addMouseMoveListener(this);
        this.ama.addMouseTrackListener(this);
        this.shell.open();
    }

    @Override
    public void leftMouseButtonPressed(int modifierMask, int x, int y) {
        if (this.onHeader) {
            this.leftPressed = true;
            this.shell.redraw(0, 0, this.shell.getSize().x, 20, false);
        }
        System.out.print("pressed");
    }

    @Override
    public void leftMouseButtonClicked(int modifierMask, int x, int y) {
    }

    @Override
    public void leftMouseButtonDoubleClicked(int modifierMask, int x, int y) {
    }

    @Override
    public void leftMouseButtonPressedDelayed(int modifierMask, int x, int y) {
    }

    @Override
    public void leftMouseButtonReleased(int modifierMask, int x, int y) {
        this.leftPressed = false;
        this.shell.redraw(0, 0, this.shell.getSize().x, 20, false);
        System.out.print("released");
    }

    @Override
    public void leftMouseButtonTimesClicked(int modifierMask, int x, int y, int count) {
    }

    @Override
    public void middleMouseButtonPressed(int modifierMask, int x, int y) {
    }

    @Override
    public void middleMouseButtonPressedDelayed(int modifierMask, int x, int y) {
    }

    @Override
    public void middleMouseButtonReleased(int modifierMask, int x, int y) {
    }

    @Override
    public void rightMouseButtonClicked(int modifierMask, int x, int y) {
    }

    @Override
    public void rightMouseButtonPressed(int modifierMask, int x, int y) {
    }

    @Override
    public void rightMouseButtonDoubleClicked(int modifierMask, int x, int y) {
    }

    @Override
    public void rightMouseButtonPressedDelayed(int modifierMask, int x, int y) {
    }

    @Override
    public void rightMouseButtonReleased(int modifierMask, int x, int y) {
    }

    @Override
    public void rightMouseButtonTimesClicked(int modifierMask, int x, int y, int count) {
    }

    @Override
    public void mouseDragged(int modifierMask, int x, int y) {
        if (this.leftPressed) {
            System.out.printf("x:%d/y:%d\n", x, y);
            this.shell.setLocation(this.shell.getLocation().x + (x - this.xp), this.shell.getLocation().y + (y - this.yp));
        }
    }

    @Override
    public void mouseDropped(int modifierMask, int x, int y) {
    }

    @Override
    public void mouseMove(int modifierMask, int x, int y) {
        this.xp = x;
        this.yp = y;
        boolean bl = this.onHeader = this.yp >= 0 && this.yp <= 20;
        if (this.oldHeader != this.onHeader) {
            this.oldHeader = this.onHeader;
            this.shell.redraw(0, 0, this.shell.getSize().x, 20, false);
        }
    }

    @Override
    public void mouseDraggedDelayed(int modifierMask, int x, int y) {
    }

    @Override
    public void mouseEnter(int modifierMask, int x, int y) {
    }

    @Override
    public void mouseExit(int modifierMask, int x, int y) {
        this.onHeader = false;
        this.oldHeader = false;
        this.shell.redraw(0, 0, this.shell.getSize().x, 20, false);
    }

    public void paintControl(PaintEvent e) {
        GC gc = e.gc;
        if (this.onHeader && !this.leftPressed) {
            gc.setBackground(Constants.DARK_GREY);
            gc.fillRectangle(0, 0, this.shell.getSize().x, 20);
        } else if (this.onHeader && this.leftPressed) {
            gc.setBackground(Constants.LIGHT_RED);
            gc.fillRectangle(0, 0, this.shell.getSize().x, 20);
        } else {
            gc.setBackground(Constants.LIGHT_BLUE);
            gc.fillRectangle(0, 0, this.shell.getSize().x, 20);
        }
    }
}

