/*
 * Decompiled with CFR 0.152.
 */
package de.drazil.nerdsuite.widget;

import de.drazil.nerdsuite.Constants;
import de.drazil.nerdsuite.model.PlatformColor;
import de.drazil.nerdsuite.widget.BaseWidget;
import de.drazil.nerdsuite.widget.IColorSelectionListener;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Shell;

public class ColorPaletteChooser
extends BaseWidget
implements PaintListener {
    private int columns;
    private int rows;
    private int width;
    private int height;
    private int cx;
    private int cy;
    private int colorIndex;
    private int maxColors;
    private boolean mouseIn = false;
    private List<PlatformColor> platformColorList;
    private List<IColorSelectionListener> colorSelectionListener;
    private static final int COLOR_TILE_SIZE = 30;

    public ColorPaletteChooser(Composite parent, int style, List<PlatformColor> platformColorList) {
        super(parent, style);
        this.setPlatformColors(platformColorList);
        this.colorSelectionListener = new ArrayList<IColorSelectionListener>();
        this.addPaintListener(this);
    }

    public void setPlatformColors(List<PlatformColor> platformColorList) {
        this.platformColorList = platformColorList;
        this.columns = platformColorList.size() / 4;
        this.rows = platformColorList.size() / this.columns;
        this.width = this.columns * 30;
        this.height = this.rows * 30;
        this.setSize(this.width, this.height + 20);
        this.maxColors = platformColorList.size() - 1;
    }

    public void setSelectedColor(int index) {
        this.cx = index % this.columns;
        this.cy = index / this.columns;
        this.colorIndex = index;
        this.redraw();
    }

    public void paintControl(PaintEvent e) {
        e.gc.setLineWidth(3);
        int r = 0;
        while (r < this.columns) {
            int c = 0;
            while (c < this.rows) {
                e.gc.setBackground(this.platformColorList.get(r * this.columns + c).getColor());
                e.gc.fillRectangle(c * 30, r * 30, 30, 30);
                if (c == this.cx && r == this.cy) {
                    e.gc.setForeground(Constants.BRIGHT_ORANGE);
                    e.gc.drawRectangle(1 + this.cx * 30, 1 + this.cy * 30, 27, 27);
                }
                ++c;
            }
            ++r;
        }
        e.gc.setFont(Constants.RobotoMonoBold_FONT);
        e.gc.setBackground(Constants.DARK_GREY);
        e.gc.fillRectangle(0, this.height, this.width, 20);
        e.gc.setForeground(Constants.WHITE);
        e.gc.drawString(String.format("$%02X - %s", this.colorIndex, this.platformColorList.get(this.colorIndex).getName()), 5, this.height);
    }

    @Override
    protected void leftMouseButtonClickedInternal(int modifierMask, int x, int y) {
        this.computeCursorPosition(x, y);
        this.close();
        this.fireColorSelected(this.colorIndex);
        this.colorSelectionListener.clear();
    }

    @Override
    protected void leftMouseButtonPressedInternal(int modifierMask, int x, int y) {
        if (!this.mouseIn) {
            this.close();
        }
    }

    @Override
    protected void mouseEnterInternal(int modifierMask, int x, int y) {
        this.mouseIn = true;
    }

    @Override
    protected void mouseExitInternal(int modifierMask, int x, int y) {
        this.mouseIn = false;
    }

    @Override
    protected void mouseMoveInternal(int modifierMask, int x, int y) {
        this.computeCursorPosition(x, y);
        this.redraw();
    }

    private void close() {
        Composite o = this.getParent().getParent();
        if (o instanceof Shell) {
            ((Shell)o).close();
        }
    }

    public void addColorSelectionListener(IColorSelectionListener listener) {
        this.colorSelectionListener.add(listener);
    }

    public void removeColorSelectionListener(IColorSelectionListener listener) {
        this.colorSelectionListener.remove(listener);
    }

    private void fireColorSelected(int colorIndex) {
        this.colorSelectionListener.forEach(l -> l.colorSelected(-1, colorIndex));
    }

    private void computeCursorPosition(int x, int y) {
        int icx = x / 30;
        int icy = y / 30;
        int idx = icx + icy * this.columns;
        if (idx <= this.maxColors) {
            this.colorIndex = idx;
            this.cx = icx;
            this.cy = icy;
        }
    }

    public Point computeSize(int wHint, int hHint, boolean changed) {
        return this.getSize();
    }
}

