/*
 * Decompiled with CFR 0.152.
 */
package de.drazil.nerdsuite.widget;

import de.drazil.nerdsuite.Constants;
import de.drazil.nerdsuite.model.PlatformColor;
import de.drazil.nerdsuite.widget.BaseWidget;
import de.drazil.nerdsuite.widget.ColorPaletteChooser;
import de.drazil.nerdsuite.widget.CustomPopupDialog;
import de.drazil.nerdsuite.widget.IColorSelectionListener;
import de.drazil.nerdsuite.widget.ITileListener;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Composite;

public class ColorChooser
extends BaseWidget
implements PaintListener,
IColorSelectionListener,
ITileListener {
    private static final int WIDGET_WIDTH = 180;
    private static final int COLOR_TILE_SIZE = 30;
    private static final int COLOR_OFFSET = 150;
    private int maxColors;
    private int maxColorsTemp;
    private boolean isMulticolorEnabled;
    private int colorIndex = 1;
    private List<PlatformColor> platformColorList;
    private int[] platformPaletteIndexList;
    private ColorPaletteChooser colorChooser;
    private CustomPopupDialog popupDialog;
    private List<IColorSelectionListener> colorSelectionListener;
    private String[] colorNames = new String[]{"Background", "Color", "Color 2", "Color 3"};

    public ColorChooser(Composite parent, int style, int maxColors, List<PlatformColor> platformColorList) {
        super(parent, style);
        this.maxColors = maxColors;
        this.maxColorsTemp = maxColors;
        this.platformColorList = platformColorList;
        this.colorSelectionListener = new ArrayList<IColorSelectionListener>();
        this.platformPaletteIndexList = new int[maxColors];
        int i = 0;
        while (i < maxColors) {
            this.platformPaletteIndexList[i] = i;
            ++i;
        }
        this.addPaintListener(this);
    }

    public void paintControl(PaintEvent e) {
        e.gc.setLineWidth(3);
        int y = 0;
        while (y < this.maxColors) {
            e.gc.setAlpha(255);
            e.gc.setBackground(Constants.DARK_GREY);
            e.gc.fillRectangle(0, y * 30, 150, 30);
            e.gc.setForeground(Constants.WHITE);
            e.gc.drawString(this.colorNames[y], 5, y * 30 + 10);
            e.gc.drawString(":" + this.platformColorList.get(this.platformPaletteIndexList[y]).getName(), 80, y * 30 + 10);
            e.gc.setBackground(this.platformColorList.get(this.platformPaletteIndexList[y]).getColor());
            e.gc.fillRectangle(150, y * 30, 30, 30);
            if (y < this.maxColors - 1) {
                e.gc.setForeground(Constants.BLACK);
                e.gc.drawLine(0, y * 30 + 30, 180, y * 30 + 30);
            }
            if (y >= this.maxColorsTemp) {
                e.gc.setAlpha(170);
                e.gc.setBackground(Constants.WHITE);
                e.gc.fillRectangle(0, y * 30, 180, 30);
            }
            ++y;
        }
        e.gc.setAlpha(255);
        e.gc.setForeground(Constants.BRIGHT_ORANGE);
        e.gc.drawRectangle(1, 1 + this.colorIndex * 30, 178, 28);
    }

    public void setMulticolorEnabled(boolean multicolorEnabled) {
        this.isMulticolorEnabled = multicolorEnabled;
        this.maxColorsTemp = this.maxColors;
        if (!multicolorEnabled) {
            this.maxColorsTemp = 2;
            this.colorIndex = 1;
            this.fireColorSelected(this.platformPaletteIndexList[this.colorIndex]);
        }
        this.redraw();
    }

    public void addColorSelectionListener(IColorSelectionListener listener) {
        this.colorSelectionListener.add(listener);
    }

    public void removeColorSelectionListener(IColorSelectionListener listener) {
        this.colorSelectionListener.remove(listener);
    }

    private void fireColorSelected(int paletteIndex) {
        if (this.colorSelectionListener != null) {
            this.colorSelectionListener.forEach(l -> l.colorSelected(this.colorIndex, paletteIndex));
        }
    }

    @Override
    public void colorSelected(int colorIndex, int paletteIndex) {
        this.platformPaletteIndexList[this.colorIndex] = paletteIndex;
        this.fireColorSelected(paletteIndex);
        this.redraw();
    }

    @Override
    protected void leftMouseButtonClickedInternal(int modifierMask, int x, int y) {
        this.computeCursorPosition(x, y);
        this.closePupup();
        if (this.colorIndex < this.maxColorsTemp) {
            this.fireColorSelected(this.platformPaletteIndexList[this.colorIndex]);
            this.redraw();
        }
    }

    @Override
    protected void rightMouseButtonClickedInternal(int modifierMask, int x, int y) {
        this.computeCursorPosition(x, y);
        this.closePupup();
        if (this.colorIndex < this.maxColorsTemp) {
            this.colorChooser = new ColorPaletteChooser(this.getParent(), 0x20100000, this.platformColorList);
            this.colorChooser.setSelectedColor(this.platformPaletteIndexList[this.colorIndex]);
            this.colorChooser.addColorSelectionListener(this);
            this.popupDialog = new CustomPopupDialog(this.getParent().getShell(), (Composite)this.colorChooser);
            this.popupDialog.open();
        }
    }

    private void closePupup() {
        if (this.colorChooser != null) {
            this.colorChooser.removeColorSelectionListener(this);
            this.popupDialog.close();
        }
    }

    public Point computeSize(int wHint, int hHint, boolean changed) {
        return new Point(100, 30 * this.maxColors);
    }

    private void computeCursorPosition(int x, int y) {
        this.colorIndex = y / 30;
        if (this.colorIndex > this.maxColorsTemp) {
            this.colorIndex = this.maxColorsTemp;
        }
    }

    @Override
    public void activeLayerChanged(int layer) {
    }

    @Override
    public void layerAdded() {
    }

    @Override
    public void layerContentChanged(int layer) {
    }

    @Override
    public void layerRemoved() {
    }

    @Override
    public void layerReordered() {
    }

    @Override
    public void layerVisibilityChanged(int layer) {
    }

    @Override
    public void tileChanged() {
    }
}

