/*
 * Decompiled with CFR 0.152.
 */
package de.drazil.nerdsuite.widget;

import de.drazil.nerdsuite.Constants;
import de.drazil.nerdsuite.enums.PencilMode;
import de.drazil.nerdsuite.enums.RedrawMode;
import de.drazil.nerdsuite.enums.TileSelectionModes;
import de.drazil.nerdsuite.imaging.service.IServiceCallback;
import de.drazil.nerdsuite.imaging.service.ITileBulkModificationListener;
import de.drazil.nerdsuite.imaging.service.ITileManagementListener;
import de.drazil.nerdsuite.imaging.service.ITileUpdateListener;
import de.drazil.nerdsuite.imaging.service.ImagePainterFactory;
import de.drazil.nerdsuite.imaging.service.ServiceFactory;
import de.drazil.nerdsuite.imaging.service.TileRepositoryService;
import de.drazil.nerdsuite.mouse.MeasuringController;
import de.drazil.nerdsuite.widget.BaseWidget;
import de.drazil.nerdsuite.widget.IColorPaletteProvider;
import de.drazil.nerdsuite.widget.IColorSelectionListener;
import de.drazil.nerdsuite.widget.IDrawListener;
import de.drazil.nerdsuite.widget.ITileListener;
import de.drazil.nerdsuite.widget.ImagingWidgetConfiguration;
import de.drazil.nerdsuite.widget.Tile;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;

public abstract class BaseImagingWidget
extends BaseWidget
implements IDrawListener,
PaintListener,
IServiceCallback,
ITileUpdateListener,
ITileManagementListener,
ITileListener,
ITileBulkModificationListener,
IColorSelectionListener,
TileSelectionModes {
    protected int selectedTileIndexX = 0;
    protected int selectedTileIndexY = 0;
    protected int selectedTileIndex = 0;
    protected int lastCursorX = -1;
    protected int lastCursorY = -1;
    protected int oldCursorX = -1;
    protected int oldCursorY = -1;
    protected int cursorX = 0;
    protected int cursorY = 0;
    protected int oldTileX = -1;
    protected int oldTileY = -1;
    protected int tileX = 0;
    protected int tileY = 0;
    protected int cursorDiffX = -1;
    protected int cursorDiffY = -1;
    protected int tileDiffX = -1;
    protected int tileDiffY = -1;
    protected int tileCursorDiffX = -1;
    protected int tileCursorDiffY = -1;
    protected int oldTileCursorX = -1;
    protected int oldTileCursorY = -1;
    protected int tileCursorX = 0;
    protected int tileCursorY = 0;
    protected int temporaryIndex = -1;
    protected int action;
    protected boolean takePosition;
    protected boolean cursorChanged = false;
    protected boolean tileCursorChanged = false;
    protected boolean tileChanged = false;
    protected boolean updateCursorLocation = false;
    protected RedrawMode redrawMode = RedrawMode.DrawAllTiles;
    protected boolean mouseIn = false;
    private List<IDrawListener> drawListenerList = null;
    protected TileRepositoryService tileRepositoryService;
    protected TileRepositoryService tileRepositoryReferenceService;
    protected ImagePainterFactory imagePainterFactory;
    protected Tile tile = null;
    protected Image image = null;
    protected IColorPaletteProvider colorPaletteProvider;
    protected ImagingWidgetConfiguration conf;

    public BaseImagingWidget(Composite parent, int style, String owner, IColorPaletteProvider colorPaletteProvider, final boolean autowrap) {
        super(parent, style);
        this.colorPaletteProvider = colorPaletteProvider;
        this.drawListenerList = new ArrayList<IDrawListener>();
        this.tileRepositoryService = ServiceFactory.getService(owner, TileRepositoryService.class);
        this.conf = new ImagingWidgetConfiguration(this.tileRepositoryService.getMetadata());
        if (this.tileRepositoryService.getMetadata().getReferenceId() != null) {
            this.tileRepositoryReferenceService = ServiceFactory.getService(this.tileRepositoryService.getMetadata().getReferenceId(), TileRepositoryService.class);
        }
        this.imagePainterFactory = new ImagePainterFactory(owner, colorPaletteProvider, this.conf);
        this.addPaintListener(this);
        this.getParent().getDisplay().getActiveShell().addListener(11, new Listener(){

            public void handleEvent(Event event) {
                if (autowrap) {
                    int c = BaseImagingWidget.this.getCalculatedColumns();
                    BaseImagingWidget.this.conf.columns = c == 0 ? 1 : c;
                    BaseImagingWidget.this.conf.rows = BaseImagingWidget.this.tileRepositoryService.getSize() / BaseImagingWidget.this.conf.columns + (BaseImagingWidget.this.tileRepositoryService.getSize() % BaseImagingWidget.this.conf.columns == 0 ? 0 : 1);
                    BaseImagingWidget.this.doRedraw(RedrawMode.DrawAllTiles, 1);
                }
            }
        });
    }

    protected int getCalculatedColumns() {
        return (this.getParent().getBounds().width - 30) / this.conf.tileWidthPixel;
    }

    public void stopDelayTrigger(MeasuringController.Trigger trigger) {
        this.ama.stopDelayTrigger(trigger);
    }

    public void enableDelayTrigger(MeasuringController.Trigger trigger, long triggerMillis) {
        this.ama.enableDelayTrigger(trigger, triggerMillis);
    }

    protected void leftMouseButtonClicked(int modifierMask, int x, int y) {
    }

    @Override
    protected void leftMouseButtonClickedInternal(int modifierMask, int x, int y) {
        this.computeCursorPosition(x, y);
        this.leftMouseButtonClicked(modifierMask, x, y);
    }

    protected void mouseMove(int modifierMask, int x, int y) {
    }

    @Override
    protected void mouseMoveInternal(int modifierMask, int x, int y) {
        this.computeCursorPosition(x, y);
        this.mouseMove(modifierMask, x, y);
    }

    protected void mouseExit(int modifierMask, int x, int y) {
    }

    @Override
    protected void mouseExitInternal(int modifierMask, int x, int y) {
        this.mouseIn = false;
        this.mouseExit(modifierMask, x, y);
    }

    protected void mouseEnter(int modifierMask, int x, int y) {
    }

    @Override
    protected void mouseEnterInternal(int modifierMask, int x, int y) {
        this.mouseIn = true;
        this.mouseEnter(modifierMask, x, y);
    }

    protected void mouseDragged(int modifierMask, int x, int y) {
    }

    @Override
    protected void mouseDraggedInternal(int modifierMask, int x, int y) {
        this.computeCursorPosition(x, y);
        this.mouseDragged(modifierMask, x, y);
    }

    protected void mouseDraggedDelayed(int modifierMask, int x, int y) {
    }

    @Override
    protected void mouseDraggedDelayedInternal(int modifierMask, int x, int y) {
        this.computeCursorPosition(x, y);
        this.mouseDraggedDelayed(modifierMask, x, y);
    }

    protected void leftMouseButtonReleased(int modifierMask, int x, int y) {
    }

    @Override
    protected void leftMouseButtonReleasedInternal(int modifierMask, int x, int y) {
        this.computeCursorPosition(x, y);
        this.leftMouseButtonReleased(modifierMask, x, y);
    }

    protected void leftMouseButtonPressed(int modifierMask, int x, int y) {
    }

    @Override
    protected void leftMouseButtonPressedInternal(int modifierMask, int x, int y) {
        this.computeCursorPosition(x, y);
        this.leftMouseButtonPressed(modifierMask, x, y);
    }

    protected void mouseScrolled(int modifierMask, int x, int y, int count) {
    }

    @Override
    protected void mouseScrolledInternal(int modifierMask, int x, int y, int count) {
        this.computeCursorPosition(x, y);
        this.mouseScrolled(modifierMask, x, y, count);
    }

    @Override
    protected void leftMouseButtonPressedDelayedInternal(int modifierMask, int x, int y) {
        this.computeCursorPosition(x, y);
        this.leftMouseButtonPressedDelayed(modifierMask, x, y);
    }

    protected void leftMouseButtonPressedDelayed(int modifierMask, int x, int y) {
    }

    protected void computeCursorPosition(int x, int y) {
        this.cursorX = x / (this.conf.pixelPaintWidth * (this.tileRepositoryService.getSelectedTile().isMulticolorEnabled() ? 2 : 1) * this.conf.getScaleFactor());
        this.cursorY = y / (this.conf.pixelPaintHeight * this.conf.getScaleFactor());
        if (this.oldCursorX != this.cursorX || this.oldCursorY != this.cursorY || this.takePosition) {
            this.lastCursorX = this.oldCursorX;
            this.lastCursorY = this.oldCursorY;
            this.cursorDiffX = this.cursorX - this.lastCursorX;
            this.cursorDiffY = this.cursorY - this.lastCursorY;
            this.oldCursorX = this.cursorX;
            this.oldCursorY = this.cursorY;
            this.cursorChanged = true;
            this.takePosition = false;
        } else {
            this.cursorChanged = false;
        }
        this.tileX = 0;
        this.tileY = 0;
        if (this.conf.scaleFactor == -1) {
            this.tileX = x / (this.conf.repositoryScaledTileWith + this.conf.tileGap);
            this.tileY = y / (this.conf.repositoryScaledTileHeight + this.conf.tileGap);
        } else {
            this.tileX = x / (this.conf.painterScaledTileWith + this.conf.tileGap);
            this.tileY = y / (this.conf.painterScaledTileHeight + this.conf.tileGap);
        }
        if (this.oldTileX != this.tileX || this.oldTileY != this.tileY || this.takePosition) {
            this.tileDiffX = this.tileX - this.oldTileX;
            this.tileDiffX = Math.abs(this.tileDiffX) > 1 ? this.tileDiffX : 0;
            this.tileDiffY = this.tileY - this.oldTileY;
            this.tileDiffY = Math.abs(this.tileDiffY) > 1 ? this.tileDiffY : 0;
            this.oldTileX = this.tileX;
            this.oldTileY = this.tileY;
            this.tileChanged = true;
            this.takePosition = false;
        } else {
            this.tileChanged = false;
        }
        this.tileCursorX = this.cursorX - this.tileX * this.conf.tileWidth * this.conf.scaleFactor;
        this.tileCursorY = this.cursorY - this.tileY * this.conf.tileHeight * this.conf.scaleFactor;
        if (this.oldTileCursorX != this.tileCursorX || this.oldTileCursorY != this.tileCursorY || this.takePosition) {
            this.tileCursorDiffX = this.tileCursorX - this.oldTileCursorX;
            this.tileCursorDiffX = Math.abs(this.tileCursorDiffX) > 1 ? this.tileCursorDiffX : 0;
            this.tileCursorDiffY = this.tileCursorY - this.oldTileCursorY;
            this.tileCursorDiffY = Math.abs(this.tileCursorDiffY) > 1 ? this.tileCursorDiffY : 0;
            this.oldTileCursorX = this.tileCursorX;
            this.oldTileCursorY = this.tileCursorY;
            this.tileCursorChanged = true;
            this.takePosition = false;
        } else {
            this.tileCursorChanged = false;
        }
    }

    public void paintControl(PaintEvent e) {
        this.paintControl(e.gc, this.redrawMode, this.conf.pixelGridEnabled, this.conf.separatorEnabled, this.conf.tileGridEnabled, this.conf.tileSubGridEnabled, true, this.conf.tileCursorEnabled, true);
    }

    protected abstract void paintControl(GC var1, RedrawMode var2, boolean var3, boolean var4, boolean var5, boolean var6, boolean var7, boolean var8, boolean var9);

    protected void paintTelevisionRaster(GC gc) {
        int height = this.conf.fullHeightPixel;
        int length = this.conf.fullWidthPixel;
        int y = 0;
        while (y < height) {
            gc.setAlpha(60);
            gc.setForeground(Constants.BLACK);
            gc.drawLine(0, y, length, y);
            y += 2;
        }
    }

    public void recalc() {
    }

    public Point computeSize(int wHint, int hHint, boolean changed) {
        int w = wHint != -1 ? wHint : this.conf.fullWidthPixel;
        int h = hHint != -1 ? hHint : this.conf.fullHeightPixel;
        return new Point(w, h);
    }

    protected boolean supportsSingleSelection() {
        return (this.conf.tileSelectionModes & 1) == 1;
    }

    protected boolean supportsMultiSelection() {
        return (this.conf.tileSelectionModes & 2) == 2;
    }

    protected boolean supportsRangeSelection() {
        return (this.conf.tileSelectionModes & 4) == 4;
    }

    public void addDrawListener(IDrawListener redrawListener) {
        if (this.drawListenerList != null) {
            this.drawListenerList.add(redrawListener);
        }
    }

    public void removeDrawListener(IDrawListener redrawListener) {
        if (this.drawListenerList != null) {
            this.drawListenerList.remove(redrawListener);
        }
    }

    protected void fireDoRedraw(RedrawMode redrawMode, PencilMode pencilMode, int update) {
        if (this.drawListenerList != null) {
            this.drawListenerList.forEach(l -> l.doRedraw(redrawMode, update));
        }
    }

    @Override
    public void doRedraw(RedrawMode redrawMode, int action) {
        this.action = action;
        this.redrawMode = redrawMode;
        this.redrawCalculatedArea();
    }

    public abstract void redrawCalculatedArea();

    @Override
    public void beforeRunService() {
    }

    @Override
    public void onRunService(int offset, int x, int y, boolean updateCursorLocation) {
    }

    @Override
    public void afterRunService() {
    }

    @Override
    public void tileAdded(Tile tile) {
    }

    @Override
    public void tileRemoved() {
    }

    @Override
    public void tileReordered() {
    }

    @Override
    public abstract void redrawTiles(List<Integer> var1, RedrawMode var2, int var3);

    @Override
    public void tileChanged() {
        this.doRedraw(RedrawMode.DrawSelectedTile, 2);
    }

    @Override
    public void tilesChanged(List<Integer> selectedTileIndexList) {
        this.doRedraw(RedrawMode.DrawSelectedTiles, 2);
    }

    @Override
    public void layerRemoved() {
    }

    @Override
    public void layerAdded() {
    }

    @Override
    public void layerContentChanged(int layer) {
        this.doRedraw(RedrawMode.DrawSelectedTile, 2);
    }

    @Override
    public void layerReordered() {
    }

    @Override
    public void layerVisibilityChanged(int layer) {
        this.redraw();
    }

    public ImagePainterFactory getImagePainterFactory() {
        return this.imagePainterFactory;
    }

    public ImagingWidgetConfiguration getConf() {
        return this.conf;
    }
}

