/*
 * Decompiled with CFR 0.152.
 */
package de.drazil.nerdsuite.viewer;

import de.drazil.nerdsuite.Constants;
import de.drazil.nerdsuite.util.IFont;
import de.drazil.nerdsuite.viewer.RowDescriber;
import org.eclipse.jface.viewers.IColorProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;

public class TableLabelProvider
implements ITableLabelProvider,
IColorProvider {
    private IFont font = null;

    public TableLabelProvider(IFont font) {
        this.font = font;
    }

    public void addListener(ILabelProviderListener listener) {
    }

    public void dispose() {
    }

    public boolean isLabelProperty(Object element, String property) {
        return false;
    }

    public void removeListener(ILabelProviderListener listener) {
    }

    public Image getColumnImage(Object element, int columnIndex) {
        return null;
    }

    public String getColumnText(Object element, int columnIndex) {
        RowDescriber rowDescriber = (RowDescriber)element;
        byte[] binaryData = rowDescriber.getBinaryData();
        switch (columnIndex) {
            case 0: {
                return String.format("%04x", rowDescriber.getStart() + rowDescriber.getOffset());
            }
            case 17: {
                StringBuffer sb = new StringBuffer();
                int i = rowDescriber.getOffset();
                while (i < rowDescriber.getOffset() + rowDescriber.getLength()) {
                    if (i < binaryData.length) {
                        sb.append(Character.toChars(this.font.getUnicodePrefix() | binaryData[i] & 0xFF));
                    } else {
                        sb.append("");
                    }
                    ++i;
                }
                return sb.toString();
            }
        }
        int offset = rowDescriber.getOffset() + columnIndex - 1;
        if (offset < binaryData.length) {
            return String.format("%02x", binaryData[offset]);
        }
        return "";
    }

    public Color getBackground(Object element) {
        RowDescriber rowDescriber = (RowDescriber)element;
        return rowDescriber.isOdd() ? Constants.LIGHT_GREEN : Constants.WHITE;
    }

    public Color getForeground(Object element) {
        return null;
    }

    private static boolean isPrintableCharacter(char c) {
        return c >= ' ' && c < '\u007f';
    }
}

