/*
 * Decompiled with CFR 0.152.
 */
package de.drazil.nerdsuite.viewer;

import de.drazil.nerdsuite.util.BinaryFileHandler;
import de.drazil.nerdsuite.util.C64Font;
import de.drazil.nerdsuite.viewer.BinaryContentProvider;
import de.drazil.nerdsuite.viewer.BinaryTableModel;
import de.drazil.nerdsuite.viewer.TableLabelProvider;
import java.io.IOException;
import java.net.URL;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import org.eclipse.core.runtime.Platform;
import org.eclipse.e4.ui.di.Focus;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.osgi.framework.Bundle;

public class BinaryViewer {
    private Table table;

    @PostConstruct
    public void createControls(Composite parent) {
        byte[] binaryData = null;
        Bundle bundle = Platform.getBundle((String)"de.drazil.nerdsuite");
        URL url = bundle.getEntry("images/Image by Almighty God.koa");
        try {
            binaryData = BinaryFileHandler.readFile(url.openConnection().getInputStream(), 2);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        C64Font font = new C64Font();
        TableViewer tableViewer = new TableViewer(parent, 67584);
        tableViewer.setContentProvider((IContentProvider)new BinaryContentProvider());
        TableLabelProvider labelProvider = new TableLabelProvider(font);
        tableViewer.setLabelProvider((IBaseLabelProvider)labelProvider);
        this.table = tableViewer.getTable();
        this.table.setHeaderVisible(true);
        this.table.setLinesVisible(true);
        this.table.setBounds(0, 0, 18, 81);
        this.table.setFont(font.getFont());
        int height = font.getFont().getFontData()[0].getHeight();
        TableColumn counterColumn = new TableColumn(this.table, 0);
        counterColumn.setWidth(height * 7);
        counterColumn.setText("#");
        int i = 0;
        while (i < 16) {
            TableColumn dataColumn = new TableColumn(this.table, 0);
            dataColumn.setWidth(height * 4);
            dataColumn.setText(String.format("%02x", i));
            ++i;
        }
        TableColumn asciiColumn = new TableColumn(this.table, 0);
        asciiColumn.setWidth(height * 20);
        asciiColumn.setText("ASCII");
        tableViewer.setInput((Object)new BinaryTableModel(binaryData, 0, 16));
    }

    @PreDestroy
    public void dispose() {
    }

    @Focus
    public void setFocus() {
    }
}

