/*
 * Decompiled with CFR 0.152.
 */
package de.drazil.nerdsuite.validator;

import de.drazil.nerdsuite.validator.BaseValidator;
import java.text.MessageFormat;
import org.eclipse.core.databinding.validation.ValidationStatus;
import org.eclipse.core.runtime.IStatus;

public class LengthValidator
extends BaseValidator {
    private int lengthA;
    private int lengthB;
    private CheckType checkType;

    public LengthValidator(String fieldName, int length, CheckType checkType) {
        this(fieldName, length, 0, checkType);
    }

    public LengthValidator(String fieldName, int minLength, int maxLength) {
        this(fieldName, minLength, maxLength, CheckType.Both);
    }

    private LengthValidator(String fieldname, int minLength, int maxLength, CheckType checkType) {
        super(fieldname);
        this.lengthA = minLength;
        this.lengthB = maxLength;
        this.checkType = checkType;
    }

    public IStatus validate(Object value) {
        IStatus validationStatus = ValidationStatus.ok();
        if (value != null && value instanceof String) {
            String s = (String)value;
            if (this.checkType == CheckType.Max) {
                if (s.length() > this.lengthA) {
                    validationStatus = ValidationStatus.error((String)MessageFormat.format("{0} has to be a maximum length of {1}", this.getFieldName(), new Integer(this.lengthA)));
                }
            } else if (this.checkType == CheckType.Min) {
                if (s.length() < this.lengthA) {
                    validationStatus = ValidationStatus.error((String)MessageFormat.format("{0} has to be a minimum length of {1}", this.getFieldName(), new Integer(this.lengthA)));
                }
            } else if (this.checkType == CheckType.Both && (s.length() < this.lengthA || s.length() > this.lengthB)) {
                validationStatus = ValidationStatus.error((String)MessageFormat.format("{0} has to be a length between {1} and {2}", this.getFieldName(), new Integer(this.lengthA), new Integer(this.lengthB)));
            }
        }
        return validationStatus;
    }

    public int getLengthA() {
        return this.lengthA;
    }

    public void setLengthA(int lengthA) {
        this.lengthA = lengthA;
    }

    public int getLengthB() {
        return this.lengthB;
    }

    public void setLengthB(int lengthB) {
        this.lengthB = lengthB;
    }

    public CheckType getCheckType() {
        return this.checkType;
    }

    public void setCheckType(CheckType checkType) {
        this.checkType = checkType;
    }

    public static enum CheckType {
        Min,
        Max,
        Both;

    }
}

