/*
 * Decompiled with CFR 0.152.
 */
package de.drazil.nerdsuite.util;

import de.drazil.nerdsuite.cpu.Endianness;

public class NumericConverter {
    public static void toDecimalString(byte b, StringBuilder sb) {
        NumericConverter.toHexString(new byte[]{b}, 0, 1, 1, sb);
    }

    public static void toDecimalString(byte[] byteArray, int offset, int len, int step, StringBuilder sb) {
        int i = offset;
        while (i < offset + len) {
            sb.append(String.format("%03d", byteArray[i] & 0xFF));
            if (i < offset + len - 1) {
                sb.append(',');
            }
            ++i;
        }
    }

    public static int toInt(byte b) {
        return b & 0xFF;
    }

    public static void toHexString(byte b, StringBuilder sb) {
        NumericConverter.toHexString(new byte[]{b}, 0, 1, 1, sb);
    }

    public static void toHexString(byte[] byteArray, int offset, int len, int step, StringBuilder sb) {
        int i = offset;
        while (i < offset + len) {
            sb.append("$" + String.format("%02x", byteArray[i]));
            if (i < offset + len - 1) {
                sb.append(',');
            }
            ++i;
        }
    }

    public static String toHexString(int value, int len) {
        return String.format("%0" + len + "x", value);
    }

    public static void toBinaryString(byte b, StringBuilder sb) {
        NumericConverter.toBinaryString(new byte[]{b}, 0, 1, 1, sb);
    }

    public static void toBinaryString(byte[] byteArray, int offset, int len, int step, StringBuilder sb) {
        int i = offset;
        while (i < offset + len) {
            char[] c = new char[]{'0', '0', '0', '0', '0', '0', '0', '0'};
            int cb = 1;
            int j = 1;
            while (j <= 8) {
                if ((byteArray[i] & cb) == cb) {
                    c[8 - j] = 49;
                }
                cb = (byte)(cb << 1);
                ++j;
            }
            sb.append("%" + String.valueOf(c));
            if (i < offset + len - 1) {
                sb.append(',');
            }
            ++i;
        }
    }

    public static String toBinaryString(byte[] byteArray, int offset, int len) {
        StringBuilder sb = new StringBuilder();
        int i = 0;
        while (i < len) {
            sb.append(String.format("%8s", Integer.toBinaryString(byteArray[offset + i] & 0xFF)).replace(" ", "0"));
            ++i;
        }
        return sb.toString();
    }

    public static int getByteAsInt(byte[] byteArray, int offset) {
        return NumericConverter.getBytes(byteArray, offset, 1)[0] & 0xFF;
    }

    public static int getWordAsInt(byte[] byteArray, int offset) {
        return NumericConverter.getWordAsInt(byteArray, offset, Endianness.LittleEndian);
    }

    public static int getWordAsInt(byte[] byteArray, int offset, Endianness endianess) {
        int value = 0;
        byte[] bytes = NumericConverter.getWord(byteArray, offset, endianess);
        value |= bytes[0] << 8;
        value |= bytes[1] & 0xFF;
        return value &= 0xFFFF;
    }

    public static byte[] getLongWord(int value) {
        byte[] lo = NumericConverter.getWord(value >> 16, Endianness.LittleEndian);
        byte[] high = NumericConverter.getWord(value & 0xFFFF, Endianness.LittleEndian);
        return new byte[]{high[0], high[1], lo[0], lo[1]};
    }

    public static byte[] getWord(int value) {
        return NumericConverter.getWord(value, Endianness.LittleEndian);
    }

    public static byte[] getWord(int value, Endianness endianess) {
        byte[] result = new byte[]{(byte)(value >> 8 & 0xFF), (byte)(value & 0xFF)};
        if (endianess == Endianness.LittleEndian) {
            byte x = result[0];
            result[0] = result[1];
            result[1] = x;
        }
        return result;
    }

    public static byte[] getWord(byte[] byteArray, int offset) {
        return NumericConverter.getWord(byteArray, offset, Endianness.LittleEndian);
    }

    public static byte[] getWord(byte[] byteArray, int offset, Endianness endianess) {
        byte[] value = NumericConverter.getBytes(byteArray, offset, 2);
        if (endianess == Endianness.LittleEndian) {
            byte x = value[0];
            value[0] = value[1];
            value[1] = x;
        }
        return value;
    }

    public static byte getByte(byte[] byteArray, int offset) {
        return NumericConverter.getByte(byteArray, offset, Endianness.LittleEndian);
    }

    public static byte getByte(byte[] byteArray, int offset, Endianness endianess) {
        if (endianess == Endianness.LittleEndian) {
            return (byte)((byteArray[offset] & 0xF) << 4 | (byteArray[offset] & 0xF0) >> 4);
        }
        return byteArray[offset];
    }

    public static byte[] getBytes(byte[] byteArray, int offset, int len) {
        int l = len;
        int diff = offset + len - byteArray.length;
        byte[] bytes = new byte[l];
        if (diff < 0) {
            System.arraycopy(byteArray, offset, bytes, 0, len);
        } else {
            int i = 0;
            while (i < diff) {
                bytes[i] = 0;
                ++i;
            }
        }
        return bytes;
    }
}

