/*
 * Decompiled with CFR 0.152.
 */
package de.drazil.nerdsuite.toolchain;

import de.drazil.nerdsuite.log.Console;
import de.drazil.nerdsuite.toolchain.IToolchainStage;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.exec.OS;

public class ExternalRunnerToolchainStage
implements IToolchainStage<Object> {
    private String name;
    private boolean isRunning = false;
    private ProcessBuilder processbuilder;
    private Process process;

    public ExternalRunnerToolchainStage(String name, String ... parameters) {
        this(name, Arrays.asList(parameters));
    }

    public ExternalRunnerToolchainStage(String name, List<String> parameters) {
        this.name = name;
        this.processbuilder = new ProcessBuilder(this.patchStartCommand(parameters));
    }

    @Override
    public void start() {
        Console.println(this.name);
        for (String command : this.processbuilder.command()) {
            Console.print(command);
        }
        Console.println();
        try {
            this.process = this.processbuilder.start();
            BufferedReader br = new BufferedReader(new InputStreamReader(this.process.getInputStream()));
            String line = null;
            while ((line = br.readLine()) != null) {
                Console.println(line);
            }
            br.close();
            int errorCode = this.process.waitFor();
            if (errorCode == 1) {
                line = null;
                br = new BufferedReader(new InputStreamReader(this.process.getErrorStream()));
                while ((line = br.readLine()) != null) {
                    Console.println(line);
                }
                br.close();
                Console.println("External Process stopped with errors");
            } else if (errorCode == 0) {
                Console.println("External Process stopped normally");
            }
            this.process.destroy();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }

    @Override
    public boolean isRunning() {
        return this.isRunning;
    }

    @Override
    public Object getResult() {
        return null;
    }

    private List<String> patchStartCommand(List<String> parameters) {
        if (parameters != null && parameters.size() > 0) {
            int i = 0;
            while (i < parameters.size()) {
                String argument = parameters.get(i);
                if (OS.isFamilyMac() && argument.endsWith(".app")) {
                    parameters.add(i, "open");
                    parameters.add(++i + 1, "--args");
                }
                ++i;
            }
        }
        return parameters;
    }
}

