/*
 * Decompiled with CFR 0.152.
 */
package de.drazil.nerdsuite.toolchain;

import de.drazil.nerdsuite.basic.encode.CbmBasicEncoder;
import de.drazil.nerdsuite.log.Console;
import de.drazil.nerdsuite.model.BasicInstructions;
import de.drazil.nerdsuite.model.CharMap;
import de.drazil.nerdsuite.model.CharObject;
import de.drazil.nerdsuite.toolchain.IToolchainStage;
import de.drazil.nerdsuite.util.ArrayUtil;
import de.drazil.nerdsuite.util.NumericConverter;
import de.drazil.nerdsuite.widget.PlatformFactory;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.List;
import java.util.stream.Collectors;

public class BasicTokenizerStage
implements IToolchainStage<Object> {
    private String platform;
    private String content;
    private String fileName;
    private BasicInstructions basicInstructions;
    private String name;
    private boolean debug;

    public BasicTokenizerStage(String name, String platform, String content, BasicInstructions basicInstructions, String fileName, boolean debug) {
        this.platform = platform;
        this.content = content;
        this.fileName = fileName;
        this.name = name;
        this.debug = debug;
        this.basicInstructions = basicInstructions;
    }

    @Override
    public Object getResult() {
        return null;
    }

    @Override
    public boolean isRunning() {
        return false;
    }

    @Override
    public void start() {
        long startTime = System.currentTimeMillis();
        Console.println(String.valueOf(this.name) + (this.debug ? " in Debug Mode" : ""));
        CharMap charMap = PlatformFactory.getCharMap(this.platform);
        List<CharObject> charMapList = charMap.getCharMap().stream().filter(e -> e.isUpper()).collect(Collectors.toList());
        CbmBasicEncoder encoder = null;
        if (this.platform.equalsIgnoreCase("c64")) {
            encoder = new CbmBasicEncoder();
        }
        byte[] bytecode = encoder.encode(this.content.toUpperCase(), this.basicInstructions, charMapList, this.debug);
        byte[] payload = new byte[]{};
        payload = ArrayUtil.grow(payload, NumericConverter.getWord(2049));
        payload = ArrayUtil.grow(payload, bytecode);
        try {
            Files.write(new File(this.fileName).toPath(), payload, new OpenOption[0]);
            float diff = (float)(System.currentTimeMillis() - startTime) / 1000.0f;
            Console.printf("%s (%d bytes) written in %.2f seconds\n", this.fileName, payload.length, Float.valueOf(diff));
        }
        catch (IOException e1) {
            Console.printf("write file %s failed", this.fileName);
            e1.printStackTrace();
        }
    }
}

