/*
 * Decompiled with CFR 0.152.
 */
package de.drazil.nerdsuite.storagemedia;

import de.drazil.nerdsuite.storagemedia.IAttributes;
import java.util.ArrayList;
import java.util.List;

public class MediaEntry {
    private List<MediaEntry> childrenList = new ArrayList<MediaEntry>();
    private int id;
    private String fullName;
    private String name;
    private String type;
    private int size;
    private int track;
    private int sector;
    private IAttributes attributes;
    private String fontName;
    private MediaEntry parent;
    private boolean isDirectory;
    private boolean isRoot;
    private boolean isSystemDisk;
    private Object dataLocation;
    private Object userObject;
    private int contentOffset;

    public MediaEntry() {
    }

    public MediaEntry(int id, String fullName, String name, String type, int size, int track, int sector, Object dataLocation, IAttributes attributes) {
        this();
        this.id = id;
        this.fullName = fullName;
        this.name = name;
        this.type = type;
        this.size = size;
        this.track = track;
        this.sector = sector;
        this.dataLocation = dataLocation;
    }

    public int getChildrenCount() {
        return this.childrenList.size();
    }

    public boolean hasChildren() {
        return !this.childrenList.isEmpty();
    }

    public List<MediaEntry> getChildrenList() {
        return this.childrenList;
    }

    public void addChildrenEntry(MediaEntry entry) {
        this.childrenList.add(entry);
    }

    public void clear() {
        this.childrenList.clear();
    }

    public int getId() {
        return this.id;
    }

    public String getFullName() {
        return this.fullName;
    }

    public String getName() {
        return this.name;
    }

    public String getType() {
        return this.type;
    }

    public int getSize() {
        return this.size;
    }

    public int getTrack() {
        return this.track;
    }

    public int getSector() {
        return this.sector;
    }

    public IAttributes getAttributes() {
        return this.attributes;
    }

    public String getFontName() {
        return this.fontName;
    }

    public MediaEntry getParent() {
        return this.parent;
    }

    public boolean isDirectory() {
        return this.isDirectory;
    }

    public boolean isRoot() {
        return this.isRoot;
    }

    public boolean isSystemDisk() {
        return this.isSystemDisk;
    }

    public Object getDataLocation() {
        return this.dataLocation;
    }

    public Object getUserObject() {
        return this.userObject;
    }

    public int getContentOffset() {
        return this.contentOffset;
    }

    public void setChildrenList(List<MediaEntry> childrenList) {
        this.childrenList = childrenList;
    }

    public void setId(int id) {
        this.id = id;
    }

    public void setFullName(String fullName) {
        this.fullName = fullName;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setType(String type) {
        this.type = type;
    }

    public void setSize(int size) {
        this.size = size;
    }

    public void setTrack(int track) {
        this.track = track;
    }

    public void setSector(int sector) {
        this.sector = sector;
    }

    public void setAttributes(IAttributes attributes) {
        this.attributes = attributes;
    }

    public void setFontName(String fontName) {
        this.fontName = fontName;
    }

    public void setParent(MediaEntry parent) {
        this.parent = parent;
    }

    public void setDirectory(boolean isDirectory) {
        this.isDirectory = isDirectory;
    }

    public void setRoot(boolean isRoot) {
        this.isRoot = isRoot;
    }

    public void setSystemDisk(boolean isSystemDisk) {
        this.isSystemDisk = isSystemDisk;
    }

    public void setDataLocation(Object dataLocation) {
        this.dataLocation = dataLocation;
    }

    public void setUserObject(Object userObject) {
        this.userObject = userObject;
    }

    public void setContentOffset(int contentOffset) {
        this.contentOffset = contentOffset;
    }
}

