/*
 * Decompiled with CFR 0.152.
 */
package de.drazil.nerdsuite.storagemedia;

import com.google.common.collect.ComparisonChain;
import de.drazil.nerdsuite.storagemedia.IMediaContainer;
import de.drazil.nerdsuite.storagemedia.IMediaEntryWriter;
import de.drazil.nerdsuite.storagemedia.MediaEntry;
import de.drazil.nerdsuite.storagemedia.MediaFactory;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.net.SocketException;
import java.util.Collections;
import java.util.Comparator;
import org.apache.commons.net.ftp.FTPClient;
import org.apache.commons.net.ftp.FTPFile;

public class FtpMediaContainer
implements IMediaContainer {
    private FTPClient client;
    private MediaEntry root;
    private File file;

    public FtpMediaContainer(File file) {
        this.file = file;
        this.root = new MediaEntry();
        this.root.setName("");
        this.root.setFullName("");
        this.root.setRoot(true);
        this.root.setUserObject(file);
        this.root.setDirectory(true);
    }

    @Override
    public MediaEntry getRoot() {
        return this.root;
    }

    @Override
    public byte[] read(File file) throws Exception {
        try {
            this.client = new FTPClient();
            this.client.connect(file.getName());
        }
        catch (SocketException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return null;
    }

    @Override
    public boolean hasEntries(Object entry) {
        return true;
    }

    @Override
    public MediaEntry[] getEntries(Object parentEntry) {
        MediaEntry[] list = new MediaEntry[]{};
        MediaEntry mediaEntry = this.getRoot();
        if (parentEntry instanceof MediaEntry) {
            mediaEntry = (MediaEntry)parentEntry;
        }
        this.readEntries(mediaEntry);
        Collections.sort(mediaEntry.getChildrenList(), new Comparator<MediaEntry>(){

            @Override
            public int compare(MediaEntry me1, MediaEntry me2) {
                return ComparisonChain.start().compareTrueFirst(me1.isDirectory(), me2.isDirectory()).compare((Comparable)((Object)me1.getName()), (Comparable)((Object)me2.getName())).compare((Comparable)((Object)me1.getType()), (Comparable)((Object)me2.getType())).result();
            }
        });
        list = mediaEntry.getChildrenList().toArray(new MediaEntry[mediaEntry.getChildrenCount()]);
        return list;
    }

    @Override
    public void readEntries(MediaEntry parent) {
        try {
            FTPFile[] files;
            System.out.println(parent.getName());
            FTPFile[] fTPFileArray = files = this.client.listFiles(parent.getName());
            int n = files.length;
            int n2 = 0;
            while (n2 < n) {
                FTPFile file = fTPFileArray[n2];
                MediaEntry entry = new MediaEntry(1, file.getName(), String.valueOf(parent.getName()) + "/" + file.getName(), "", (int)file.getSize(), 0, 0, null, null);
                entry.setDirectory(file.getType() == 1);
                entry.setUserObject(this.file);
                MediaFactory.addChildEntry(parent, entry);
                ++n2;
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @Override
    public byte[] readContent(MediaEntry entry, IMediaEntryWriter writer) throws Exception {
        return null;
    }

    @Override
    public void exportEntry(MediaEntry entry, File file) throws Exception {
    }

    @Override
    public byte[] exportEntry(MediaEntry entry) throws Exception {
        byte[] data = null;
        try {
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            boolean b = this.client.retrieveFile(entry.getName(), (OutputStream)bos);
            data = bos.toByteArray();
            bos.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return data;
    }

    @Override
    public void getAvailabilityMap() {
    }
}

