/*
 * Decompiled with CFR 0.152.
 */
package de.drazil.nerdsuite.storagemedia;

import de.drazil.nerdsuite.storagemedia.AbstractBaseMediaContainer;
import de.drazil.nerdsuite.storagemedia.IMediaEntryWriter;
import de.drazil.nerdsuite.storagemedia.MediaEntry;
import de.drazil.nerdsuite.storagemedia.MediaFactory;
import de.drazil.nerdsuite.util.NumericConverter;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.text.StringEscapeUtils;

public class DSK_MediaContainer
extends AbstractBaseMediaContainer {
    private static final int SECTOR_SIZE = 512;
    private static final int RECORD_SIZE = 128;
    int[][] trackSizes = null;
    protected int directoryTrack = 2;
    private String diskInfo;
    private String creator;
    private int tracks;
    private int sides;
    private int diskType;
    private DiskFormat diskFormat;
    private int trackInfoBaseOffset = 256;
    private int directoryBaseOffset = this.trackInfoBaseOffset + 256;
    private int base;
    private int sectorInfobase;
    private String trackInfoText;
    private int sectorSize;
    private int sectorCount;
    private List<Integer> sectorIdList;

    public DSK_MediaContainer(File file) {
        super(file);
    }

    @Override
    protected void readHeader() {
        this.diskInfo = this.getString(0, 33, true);
        this.diskInfo = StringEscapeUtils.escapeJava((String)this.diskInfo);
        this.diskFormat = this.getDiskFormat(this.diskInfo);
        this.creator = this.getString(34, 47, true);
        this.tracks = this.getByte(48);
        this.sides = this.getByte(49);
        this.sectorInfobase = this.trackInfoBaseOffset + 24;
        this.sectorSize = this.getByte(this.trackInfoBaseOffset + 20);
        this.sectorCount = this.getByte(this.trackInfoBaseOffset + 21);
        this.diskType = this.getByte(this.sectorInfobase + 2);
        this.trackSizes = new int[this.tracks][this.sides];
        switch (this.diskFormat) {
            case Standard: {
                int s = 0;
                while (s < this.sides) {
                    int t = 0;
                    while (t < this.tracks) {
                        this.trackSizes[t][s] = this.getWord(50);
                        ++t;
                    }
                    ++s;
                }
                break;
            }
            case Extended: {
                int t = 0;
                while (t < this.tracks) {
                    int s = 0;
                    while (s < this.sides) {
                        this.trackSizes[t][s] = this.content[52 + (t + s * 2)] * 256;
                        ++s;
                    }
                    ++t;
                }
                break;
            }
        }
        this.base = this.directoryBaseOffset + (this.diskType == 65 ? 2 : 0) * this.trackSizes[0][0];
        System.out.printf("Directory Offset : $%05x\n", this.base);
        System.out.printf("DiskType         : %s\n", this.diskType == 65 ? "System Disk" : "Data Disk");
        System.out.printf("DiskInfo         : %s\n", this.diskInfo);
        System.out.printf("Creator          : %s\n", this.creator);
        System.out.printf("Tracks           : %02d\n", this.tracks);
        System.out.printf("Sides            : %02d\n", this.sides);
        System.out.printf("TrackSize        : $%05x / %02d\n", this.trackSizes[0][0], this.trackSizes[0][0]);
        this.sectorIdList = new ArrayList<Integer>();
        int tc = 0;
        while (tc < this.tracks) {
            int sc = 0;
            while (sc < this.sides) {
                this.sectorInfobase = this.trackInfoBaseOffset + 24;
                this.trackInfoText = this.getString(this.trackInfoBaseOffset, this.trackInfoBaseOffset + 11, true);
                System.out.printf("\n\nTrackInfo        : $%05x - %s\n", this.trackInfoBaseOffset, this.trackInfoText);
                System.out.printf("Unused           : 0c-0f  %04x %04x\n", this.getWord(this.trackInfoBaseOffset + 12), this.getWord(this.trackInfoBaseOffset + 14));
                System.out.printf("TrackNo          : %02d\n", this.getByte(this.trackInfoBaseOffset + 16));
                System.out.printf("SideNo           : %02d\n", this.getByte(this.trackInfoBaseOffset + 17));
                System.out.printf("Unused           : 12-13  %04x\n", this.getWord(this.trackInfoBaseOffset + 18));
                System.out.printf("SectorSize       : %02d\n", this.sectorSize);
                System.out.printf("SectorCount      : %02d\n", this.sectorCount);
                System.out.printf("GAP#3 Length     : %03d\n", this.getByte(this.trackInfoBaseOffset + 22));
                System.out.printf("Filler Byte      : %02d / %02x\n", this.getByte(this.trackInfoBaseOffset + 23), this.getByte(this.trackInfoBaseOffset + 23));
                System.out.printf("SectorInfo Start : $%05x\n", this.getByte(this.trackInfoBaseOffset + 20) * this.getByte(this.trackInfoBaseOffset + 21));
                int i = this.sectorInfobase;
                while (i < this.sectorInfobase + 8 * this.sectorCount) {
                    boolean md;
                    int track = this.getByte(i + 0);
                    int side = this.getByte(i + 1);
                    int id = this.getByte(i + 2);
                    int size = this.getByte(i + 3);
                    int SR1 = this.getByte(i + 4);
                    int SR2 = this.getByte(i + 5);
                    int dataLength = this.getWord(i + 6);
                    boolean en = (SR1 & 0x80) == 128;
                    boolean de = (SR1 & 0x20) == 32;
                    boolean nd = (SR1 & 4) == 4;
                    boolean ma = (SR1 & 1) == 1;
                    boolean cm = (SR2 & 0x20) == 32;
                    boolean dd = (SR2 & 0x20) == 32;
                    boolean bl = md = (SR2 & 1) == 1;
                    if (tc == 0) {
                        this.sectorIdList.add(id & 0xF);
                    }
                    System.out.printf("  Track: %02d Side: %01d Id: $%02x Size: %04d Byte DataLength: %d EN(%b) DE(%b) ND(%b) MA(%b) CM(%b) DD(%b) MD(%b)\n", track, side, id, 128 << size, dataLength, en, de, nd, ma, cm, dd, md);
                    i += 8;
                }
                this.trackInfoBaseOffset += this.trackSizes[tc][sc];
                ++sc;
            }
            ++tc;
        }
    }

    @Override
    public void readEntries(MediaEntry parent) {
        int tempBase = this.base;
        int currentDirectoryEntryOffset = this.base;
        int id = 0;
        boolean hasMoreEntries = true;
        ArrayList<Integer> contentOffsetList = null;
        while (hasMoreEntries) {
            MediaEntry entry = null;
            int userLevel = this.content[currentDirectoryEntryOffset] & 0xFF;
            String fileName = this.getString(currentDirectoryEntryOffset + 1, currentDirectoryEntryOffset + 8, false);
            String fileType = this.getString(currentDirectoryEntryOffset + 9, currentDirectoryEntryOffset + 11, false);
            int extent = this.content[currentDirectoryEntryOffset + 12] & 0xFF;
            int fileSize = this.getByte(currentDirectoryEntryOffset + 15) * 128;
            if (extent > 0) {
                for (MediaEntry me : parent.getChildrenList()) {
                    if (!me.getName().equals(fileName) || !me.getType().equals(fileType)) continue;
                    fileSize = me.getSize() + fileSize;
                    entry = me;
                    entry.setSize(fileSize);
                    this.addContentOffset(contentOffsetList, currentDirectoryEntryOffset);
                    break;
                }
            }
            String fullName = String.format("%1$s" + (StringUtils.isAsciiPrintable((CharSequence)fileType) ? ".%3$s" : "") + " (%2$4d K )", fileName, 1 + fileSize / 1024, fileType);
            if (this.isVisibleInCatalog(currentDirectoryEntryOffset) && extent == 0 && !StringUtils.isBlank((CharSequence)fileName)) {
                contentOffsetList = new ArrayList<Integer>();
                entry = new MediaEntry(id, fullName, fileName, fileType, fileSize, 0, 0, currentDirectoryEntryOffset + 16, null);
                entry.setUserObject(this.getContainer());
                entry.setDataLocation(contentOffsetList);
                this.addContentOffset(contentOffsetList, currentDirectoryEntryOffset);
                MediaFactory.addChildEntry(parent, entry);
            }
            if (entry != null) {
                entry.setFullName(fullName);
            }
            ++id;
            if (this.isEmptyEntry(currentDirectoryEntryOffset += 32, 16, 0) || this.isEmptyEntry(currentDirectoryEntryOffset, 16, 229)) {
                hasMoreEntries = true;
                currentDirectoryEntryOffset = tempBase = currentDirectoryEntryOffset - 16 + (tempBase + 512 - currentDirectoryEntryOffset) + 16;
            }
            if (currentDirectoryEntryOffset <= this.base + 2048) continue;
            hasMoreEntries = false;
        }
    }

    private int getSectorIndex(List<Integer> idList, int sector) {
        int id = -1;
        int i = 0;
        while (i < idList.size()) {
            if (idList.get(i) == sector) {
                id = i;
                break;
            }
            ++i;
        }
        return id;
    }

    private void addContentOffset(List<Integer> offsetList, int offset) {
        int i = offset + 16;
        while (i < offset + 32) {
            int v = this.content[i] & 0xFF;
            if (v == 0) break;
            offsetList.add(new Integer(v));
            ++i;
        }
    }

    @Override
    public byte[] readContent(MediaEntry entry, IMediaEntryWriter writer) throws Exception {
        List blockList = (List)entry.getDataLocation();
        System.out.println(entry.getFullName());
        int totalSize = 0;
        boolean finished = false;
        boolean isBinary = false;
        boolean checkedHeader = false;
        int i = 0;
        while (i < blockList.size()) {
            if (finished) break;
            int size = 128 << this.sectorSize;
            int block = (Integer)blockList.get(i) & 0xFF;
            int track = (block * 2 + 18) / this.sectorCount - (this.diskType == 65 ? 0 : 2);
            int sector = (block * 2 + 18) % this.sectorCount;
            int sectorIndex = this.getSectorIndex(this.sectorIdList, sector + 1);
            int trackOffset = 256 + this.trackSizes[track][0] * track;
            int sectorOffset = 256 + size * sectorIndex;
            int s = sector;
            while (s < sector + 2 && !finished) {
                int offset = trackOffset + sectorOffset;
                if (!checkedHeader) {
                    isBinary = this.hasHeader(this.content, offset) && i == 0;
                    if (isBinary) {
                        totalSize = this.getWord(offset + 24) + 128;
                        System.out.printf("Name  : %s\n", this.getString(offset + 1, offset + 8, true));
                        System.out.printf("Type  : %s\n", this.getString(offset + 9, offset + 11, true));
                        System.out.printf("Adress: %04x\n", this.getWord(offset + 21));
                        System.out.printf("Length: %04x\n", this.getWord(offset + 24));
                        System.out.printf("Length: %04x\n", this.getWord(offset + 64));
                    }
                    if (!isBinary) {
                        isBinary = !this.isAscii(this.content, offset, 128);
                        totalSize = entry.getSize();
                    }
                    checkedHeader = true;
                }
                if (isBinary) {
                    if (totalSize <= size) {
                        size = totalSize;
                        finished = true;
                    }
                } else {
                    boolean found = false;
                    int j = offset;
                    while (j < offset + size) {
                        if (this.content[j] == 26) {
                            found = true;
                            size = j - offset;
                            finished = true;
                            break;
                        }
                        ++j;
                    }
                    if (!found) {
                        size = 512;
                    }
                }
                writer.write(entry, offset, size, finished);
                System.out.printf("%02d %02x T:%02x S:%02x %05x size:%d \n", i, block, track, sector, offset, size);
                if ((sectorOffset += size * 2) > this.trackSizes[track][0]) {
                    sectorOffset = 768;
                } else if (sectorOffset == this.trackSizes[track][0]) {
                    sectorOffset += 256;
                }
                totalSize -= size;
                ++s;
            }
            ++i;
        }
        return null;
    }

    private boolean isVisibleInCatalog(int directoryOffset) {
        return (this.content[directoryOffset + 10] & 0x80) == 0 && this.content[directoryOffset] == 0;
    }

    private boolean isDeletable(int directoryOffset) {
        return (this.content[directoryOffset + 9] & 0x80) == 0;
    }

    private int getExtent(int directoryOffset) {
        return this.content[directoryOffset + 12];
    }

    private boolean hasHeader(byte[] content, int offset) {
        int checkSum = 0;
        int headerSum = 0;
        checkSum = NumericConverter.getWordAsInt(content, offset + 67);
        int i = offset;
        while (i < offset + 66) {
            headerSum += NumericConverter.getByteAsInt(content, i);
            ++i;
        }
        return checkSum == headerSum;
    }

    private boolean isAscii(byte[] content, int offset, int length) {
        boolean isAscii = true;
        int i = offset;
        while (i < offset + length) {
            if (!Character.isAlphabetic(content[i])) {
                isAscii = false;
                break;
            }
            ++i;
        }
        return isAscii;
    }

    private DiskFormat getDiskFormat(String diskInfo) {
        if (diskInfo.contains("EXTENDED CPC DSK")) {
            return DiskFormat.Extended;
        }
        if (diskInfo.contains("MV - CPCEMU")) {
            return DiskFormat.Standard;
        }
        return DiskFormat.Unkown;
    }

    static enum DiskFormat {
        Standard(0),
        Extended(2),
        Unkown(-1);

        private int directoryTrack;

        private DiskFormat(int directoryTrack) {
            this.directoryTrack = directoryTrack;
        }

        public int getDirectoryTrack() {
            return this.directoryTrack;
        }
    }
}

