/*
 * Decompiled with CFR 0.152.
 */
package de.drazil.nerdsuite.storagemedia;

import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.type.CollectionType;
import de.drazil.nerdsuite.model.AsciiMap;
import de.drazil.nerdsuite.storagemedia.AbstractBaseMediaContainer;
import de.drazil.nerdsuite.storagemedia.IMediaEntryWriter;
import de.drazil.nerdsuite.storagemedia.MediaEntry;
import de.drazil.nerdsuite.storagemedia.MediaFactory;
import java.io.File;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.core.runtime.Platform;
import org.osgi.framework.Bundle;

public abstract class CBMDiskImageContainer
extends AbstractBaseMediaContainer {
    private int sectorSize = 256;
    protected int directoryTrack = 18;
    protected int directorySectorInterleave = 1;
    protected int fileSectorInterleave = 1;
    private List<AsciiMap> list;
    protected int[] trackOffsets;
    private int bamOffset;
    private int currentDirTrack;
    private int currentDirEntryBaseOffset;
    private int currentDirectoryEntryOffset;
    private String name;
    private String diskId;
    private String dummy;
    private String dosType;
    private String diskName;

    public CBMDiskImageContainer(File file) {
        super(file);
    }

    @Override
    protected void readHeader() {
        this.bamOffset = this.trackOffsets[this.directoryTrack - 1];
        this.currentDirTrack = this.directoryTrack;
        this.currentDirectoryEntryOffset = this.currentDirEntryBaseOffset = this.bamOffset + this.sectorSize;
        this.name = this.getFilename(this.bamOffset + 144, 15, 10, false, true);
        this.diskId = String.valueOf(new String(Character.toChars(this.getChar(this.content[this.bamOffset + 162], false, true)))) + new String(Character.toChars(this.getChar(this.content[this.bamOffset + 163], false, true)));
        this.dummy = new String(Character.toChars(this.getChar(this.content[this.bamOffset + 164], false, true)));
        this.dosType = String.valueOf(new String(Character.toChars(this.getChar(this.content[this.bamOffset + 165], false, true)))) + new String(Character.toChars(this.getChar(this.content[this.bamOffset + 166], false, true)));
        this.diskName = String.valueOf(this.name) + "\uee20" + this.diskId + this.dummy + this.dosType;
        this.diskName = String.format("%1$4s", StringUtils.rightPad((String)this.diskName, (int)22, (String)"\uee20"));
    }

    @Override
    public void readEntries(MediaEntry parent) {
        while (this.currentDirTrack != 0) {
            this.currentDirTrack = this.content[this.currentDirectoryEntryOffset] & 0xFF;
            int nextSector = this.content[this.currentDirectoryEntryOffset + 1] & 0xFF;
            int id = 0;
            while (this.currentDirectoryEntryOffset < this.currentDirEntryBaseOffset + 256) {
                byte fileType = this.content[this.currentDirectoryEntryOffset + 2];
                if (this.content[this.currentDirectoryEntryOffset + 5] != 0 && (fileType & 7) != 0) {
                    String fileName = this.getFilename(this.currentDirectoryEntryOffset + 5, 15, 160);
                    int fileSize = this.getFileSize(this.currentDirectoryEntryOffset + 30);
                    byte fileTrack = this.content[this.currentDirectoryEntryOffset + 3];
                    byte fileSector = this.content[this.currentDirectoryEntryOffset + 4];
                    String fileTypeName = this.getFileType(fileType);
                    boolean isClosed = this.isClosed(fileType);
                    boolean isLocked = this.isLocked(fileType);
                    if (this.content[this.currentDirectoryEntryOffset + 2] != 0) {
                        String fullName = String.format("%2$s.%3$s (%1$3d Blocks )", fileSize, fileName, fileTypeName);
                        MediaEntry entry = new MediaEntry(id, fullName, fileName, fileTypeName, fileSize, fileTrack, fileSector, 0, null);
                        entry.setUserObject(this.getContainer());
                        MediaFactory.addChildEntry(parent, entry);
                    }
                }
                this.currentDirectoryEntryOffset += 32;
                ++id;
            }
            this.currentDirectoryEntryOffset = this.currentDirEntryBaseOffset = this.bamOffset + nextSector * this.sectorSize;
        }
    }

    @Override
    public byte[] readContent(MediaEntry entry, IMediaEntryWriter writer) throws Exception {
        if (!entry.getType().trim().equals("DEL")) {
            int fileTrack = entry.getTrack();
            int fileSector = entry.getSector();
            int copySize = 0;
            boolean hasMoreData = true;
            while (hasMoreData) {
                int fileSectorOffset = this.trackOffsets[fileTrack - 1] + fileSector * 256;
                fileTrack = this.content[fileSectorOffset] & 0xFF;
                fileSector = this.content[fileSectorOffset + 1] & 0xFF;
                hasMoreData = fileTrack != 0;
                copySize = (hasMoreData ? 254 : fileSector) & 0xFF;
                writer.write(entry, fileSectorOffset + 2, copySize, !hasMoreData);
                System.out.printf("Next:%05x %02d / %02d\n", fileSectorOffset, fileTrack, fileSector);
            }
        }
        return writer.getData();
    }

    private int getFileSize(int start) {
        return this.getWord(start);
    }

    private String getFilename(int start, int length, int skipByte, boolean shift, boolean invers) {
        StringBuilder sb = new StringBuilder();
        int i = start;
        while (i <= start + length) {
            byte c = this.content[i];
            if (c != skipByte) {
                sb.append(new String(Character.toChars(this.getChar(c & 0xFF, shift, invers))));
            }
            ++i;
        }
        return sb.toString();
    }

    private String getFilename(int start, int length, int skipByte) {
        StringBuilder sb = new StringBuilder();
        int i = start;
        while (i <= start + length) {
            byte c = this.content[i];
            if (Character.isLetter(c) || Character.isDigit(c) || Character.isWhitespace(c) || c == 32) {
                sb.append(new String(Character.toChars((char)c)));
            }
            ++i;
        }
        return sb.toString();
    }

    private boolean isLocked(byte type) {
        return (type & 0x40) == 64;
    }

    private boolean isClosed(byte type) {
        return (type & 0x80) == 128;
    }

    private String getFileType(byte type) {
        String fileType = "unkown";
        switch (type & 7) {
            case 0: {
                fileType = "DEL";
                break;
            }
            case 1: {
                fileType = "SEQ";
                break;
            }
            case 2: {
                fileType = "PRG";
                break;
            }
            case 3: {
                fileType = "USR";
                break;
            }
            case 4: {
                fileType = "REL";
            }
        }
        return fileType;
    }

    private int getChar(int c, boolean shift, boolean invers) {
        int mappedChar = 0;
        try {
            AsciiMap map;
            int cx;
            if (this.list == null) {
                Bundle bundle = Platform.getBundle((String)"de.drazil.nerdsuite");
                ObjectMapper mapper = new ObjectMapper();
                CollectionType listType = mapper.getTypeFactory().constructCollectionType(List.class, AsciiMap.class);
                this.list = (List)mapper.readValue(bundle.getEntry("configuration/petascii_map.json"), (JavaType)listType);
            }
            if ((cx = (map = this.list.stream().filter(le -> le.getId() == (c & 0xFF)).findFirst().get()).getScreenCode()) == 0) {
                System.out.println(String.valueOf(c) + " is empty");
            }
            mappedChar = (!shift ? 60928 : 61184) + cx | (invers ? 128 : 0);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return mappedChar;
    }
}

