/*
 * Decompiled with CFR 0.152.
 */
package de.drazil.nerdsuite.storagemedia;

import com.google.common.collect.ComparisonChain;
import de.drazil.nerdsuite.cpu.Endianness;
import de.drazil.nerdsuite.storagemedia.IMediaContainer;
import de.drazil.nerdsuite.storagemedia.IMediaEntryWriter;
import de.drazil.nerdsuite.storagemedia.MediaEntry;
import de.drazil.nerdsuite.util.BinaryFileHandler;
import de.drazil.nerdsuite.util.NumericConverter;
import java.io.File;
import java.io.FileOutputStream;
import java.util.Collections;
import java.util.Comparator;

public abstract class AbstractBaseMediaContainer
implements IMediaContainer {
    public byte[] content;
    private MediaEntry root;
    private File container;

    public AbstractBaseMediaContainer(File file) {
        this.container = file;
        this.root = new MediaEntry();
        this.root.setRoot(true);
        this.root.setUserObject(file);
    }

    public File getContainer() {
        return this.container;
    }

    @Override
    public MediaEntry[] getEntries(Object parentEntry) {
        MediaEntry[] list = new MediaEntry[]{};
        MediaEntry mediaEntry = this.getRoot();
        if (parentEntry instanceof MediaEntry) {
            mediaEntry = (MediaEntry)parentEntry;
        }
        this.readEntries(mediaEntry);
        Collections.sort(mediaEntry.getChildrenList(), new Comparator<MediaEntry>(){

            @Override
            public int compare(MediaEntry me1, MediaEntry me2) {
                return ComparisonChain.start().compareTrueFirst(me1.isDirectory(), me2.isDirectory()).compare((Comparable)((Object)me1.getName()), (Comparable)((Object)me2.getName())).compare((Comparable)((Object)me1.getType()), (Comparable)((Object)me2.getType())).result();
            }
        });
        list = mediaEntry.getChildrenList().toArray(new MediaEntry[mediaEntry.getChildrenCount()]);
        return list;
    }

    @Override
    public boolean hasEntries(Object entry) {
        boolean hasChildren = false;
        if (entry instanceof MediaEntry) {
            MediaEntry me = (MediaEntry)entry;
            hasChildren = me.hasChildren();
        }
        return hasChildren;
    }

    @Override
    public MediaEntry getRoot() {
        return this.root;
    }

    @Override
    public byte[] read(File file) throws Exception {
        this.getRoot().clear();
        this.content = BinaryFileHandler.readFile(file, 0);
        this.readHeader();
        return this.content;
    }

    protected int getWord(int start) {
        return this.getWord(start, Endianness.LittleEndian);
    }

    protected int getWord(int start, Endianness endianess) {
        return NumericConverter.getWordAsInt(this.content, start, endianess);
    }

    protected int getByte(int start) {
        return NumericConverter.getByteAsInt(this.content, start);
    }

    protected String getString(int start, int end, boolean skipCharCheck) {
        StringBuilder sb = new StringBuilder();
        int i = start;
        while (i <= end) {
            char c = (char)(this.content[i] & 0x7F);
            if (Character.isLetter(c) || Character.isDigit(c) || skipCharCheck) {
                sb.append(Character.toString(c));
            }
            ++i;
        }
        return sb.toString();
    }

    public boolean isEmptyEntry(int base, int maxCount) {
        byte lastValue = this.content[base];
        int count = 0;
        int i = base;
        while (i < base + maxCount) {
            if (i > 0) {
                count += this.content[i] == lastValue ? 1 : 0;
            }
            lastValue = this.content[i];
            ++i;
        }
        return count == maxCount;
    }

    public boolean isEmptyEntry(int base, int maxCount, int checkValue) {
        int count = 0;
        int i = base;
        while (i < base + maxCount) {
            count += (this.content[i] & 0xFF) == checkValue ? 1 : 0;
            ++i;
        }
        return count == maxCount;
    }

    @Override
    public void exportEntry(MediaEntry entry, File file) throws Exception {
        try {
            final FileOutputStream os = new FileOutputStream(file);
            this.readContent(entry, new IMediaEntryWriter(){

                @Override
                public void write(MediaEntry entry, int start, int len, boolean finished) throws Exception {
                    BinaryFileHandler.write(os, AbstractBaseMediaContainer.this.content, start, len, finished);
                }

                @Override
                public byte[] getData() {
                    return null;
                }
            });
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public byte[] exportEntry(MediaEntry entry) throws Exception {
        byte[] data = null;
        try {
            data = this.readContent(entry, new IMediaEntryWriter(){
                byte[] result = null;

                @Override
                public void write(MediaEntry entry, int start, int len, boolean finished) throws Exception {
                    if (this.result == null) {
                        this.result = new byte[len];
                        System.arraycopy(AbstractBaseMediaContainer.this.content, start, this.result, 0, len);
                    } else {
                        byte[] temp = new byte[this.result.length + len];
                        int tempLength = this.result.length;
                        System.arraycopy(this.result, 0, temp, 0, this.result.length);
                        this.result = temp;
                        System.arraycopy(AbstractBaseMediaContainer.this.content, start, this.result, tempLength, len);
                    }
                }

                @Override
                public byte[] getData() {
                    return this.result;
                }
            });
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return data;
    }

    protected abstract void readHeader();

    @Override
    public abstract byte[] readContent(MediaEntry var1, IMediaEntryWriter var2) throws Exception;

    @Override
    public abstract void readEntries(MediaEntry var1);

    @Override
    public void getAvailabilityMap() {
    }
}

