/*
 * Decompiled with CFR 0.152.
 */
package de.drazil.nerdsuite.storagemedia;

import de.drazil.nerdsuite.storagemedia.AbstractBaseMediaContainer;
import de.drazil.nerdsuite.storagemedia.IMediaEntryWriter;
import de.drazil.nerdsuite.storagemedia.MediaEntry;
import de.drazil.nerdsuite.storagemedia.MediaFactory;
import java.io.File;

public class ATR_MediaContainer
extends AbstractBaseMediaContainer {
    private int atariDiskId;
    private int diskImageSize;
    private int sectorSize;
    private int diskImageSizeHighPart;
    private long imageSize;
    private int diskFlag;
    private int firstTypicalSector;
    private int vtocStartOffset;
    private int typeCode;
    private int sectorCount;
    private int unusedSectorCount;
    private int directorySector;
    private int largeDiskCorrectionCount;

    public ATR_MediaContainer(File file) {
        super(file);
    }

    @Override
    protected void readHeader() {
        this.atariDiskId = this.getWord(0);
        this.diskImageSize = this.getWord(2);
        this.sectorSize = this.getWord(4);
        this.diskImageSizeHighPart = this.getByte(6);
        this.imageSize = (this.diskImageSizeHighPart << 16) + this.diskImageSize;
        this.diskFlag = this.getByte(8);
        this.firstTypicalSector = this.getWord(9);
        this.vtocStartOffset = 359;
        this.typeCode = this.content[this.vtocStartOffset];
        this.sectorCount = this.getWord(this.vtocStartOffset + 1);
        this.unusedSectorCount = this.getWord(this.vtocStartOffset + 3);
        this.directorySector = 360;
        this.largeDiskCorrectionCount = 3;
        this.getRoot().setSector(this.directorySector);
    }

    private int getSectorOffset(int sector) {
        return (this.sectorSize == 128 ? sector * this.sectorSize : this.largeDiskCorrectionCount * 128 + (sector - this.largeDiskCorrectionCount) * this.sectorSize) + 16;
    }

    @Override
    public void readEntries(MediaEntry parent) {
        int id = 1;
        boolean hasMoreEntries = true;
        int currentDirectorySectorOffset = this.getSectorOffset(parent.getSector());
        if (parent.isDirectory()) {
            currentDirectorySectorOffset -= 256;
        }
        int currentDirectoryEntryOffset = currentDirectorySectorOffset;
        while (hasMoreEntries) {
            int entryFlag = this.getByte(currentDirectoryEntryOffset);
            int entrySectorCount = this.getWord(currentDirectoryEntryOffset + 1);
            int entrySector = this.getWord(currentDirectoryEntryOffset + 3);
            String fileName = this.getString(currentDirectoryEntryOffset + 5, currentDirectoryEntryOffset + 12, false);
            String fileExtension = this.getString(currentDirectoryEntryOffset + 13, currentDirectoryEntryOffset + 15, false);
            int usedSectorBytes = this.getByte(currentDirectoryEntryOffset);
            if (entryFlag != 0 && entryFlag != 128) {
                String fullName = String.format("%1$s.%2$s (%3$3d )", fileName, fileExtension, entrySectorCount);
                MediaEntry entry = new MediaEntry(id, fullName, fileName, fileExtension, entrySectorCount, 0, 0, 0, null);
                entry.setDirectory((entryFlag & 0x10) == 16);
                entry.setUserObject(this.getContainer());
                entry.setSector(entrySector);
                MediaFactory.addChildEntry(parent, entry);
            }
            currentDirectoryEntryOffset += 16;
            if (id % 8 == 0) {
                currentDirectoryEntryOffset = currentDirectorySectorOffset += this.sectorSize;
            }
            boolean bl = hasMoreEntries = !this.isEmptyEntry(currentDirectoryEntryOffset, 16, 0) && ++id <= 64;
        }
    }

    @Override
    public byte[] readContent(MediaEntry entry, IMediaEntryWriter writer) throws Exception {
        int sector = entry.getSector() - 1;
        long sectorOffset = this.getSectorOffset(sector);
        int sectorSize = sector < 3 ? 128 : this.sectorSize;
        boolean hasMoreData = true;
        int sc = 0;
        while (hasMoreData) {
            boolean fileNo = false;
            int h = this.content[(int)(sectorOffset + (long)sectorSize - 3L)] << 8 & 0xFFFF;
            int l = this.content[(int)(sectorOffset + (long)sectorSize - 2L)] & 0xFF;
            long bytesToRead = this.content[(int)sectorOffset + sectorSize - 1] & 0xFF;
            hasMoreData = sc < entry.getSize() - 1;
            writer.write(entry, (int)sectorOffset, (int)bytesToRead, !hasMoreData);
            ++sc;
            sector = h + l - 1;
            sectorOffset = this.getSectorOffset(sector);
        }
        return null;
    }
}

