/*
 * Decompiled with CFR 0.152.
 */
package de.drazil.nerdsuite.sourceeditor;

import de.drazil.nerdsuite.Constants;
import de.drazil.nerdsuite.basic.encode.SourceRepositoryService;
import de.drazil.nerdsuite.configuration.Initializer;
import de.drazil.nerdsuite.handler.BrokerObject;
import de.drazil.nerdsuite.imaging.service.ServiceFactory;
import de.drazil.nerdsuite.log.Console;
import de.drazil.nerdsuite.model.BasicInstruction;
import de.drazil.nerdsuite.model.BasicInstructions;
import de.drazil.nerdsuite.model.BasicToken;
import de.drazil.nerdsuite.model.Project;
import de.drazil.nerdsuite.mouse.AdvancedMouseAdaper;
import de.drazil.nerdsuite.mouse.AdvancedMouseListenerAdapter;
import de.drazil.nerdsuite.sourceeditor.DocumentStyler;
import de.drazil.nerdsuite.sourceeditor.IDocument;
import de.drazil.nerdsuite.sourceeditor.Marker;
import de.drazil.nerdsuite.sourceeditor.MultiLineRule;
import de.drazil.nerdsuite.sourceeditor.SingleLineRule;
import de.drazil.nerdsuite.sourceeditor.Token;
import de.drazil.nerdsuite.sourceeditor.WordRule;
import de.drazil.nerdsuite.toolchain.BasicTokenizerStage;
import de.drazil.nerdsuite.toolchain.ExternalRunnerToolchainStage;
import de.drazil.nerdsuite.toolchain.Toolchain;
import de.drazil.nerdsuite.widget.CustomPopupDialog;
import de.drazil.nerdsuite.widget.ICharSelectionListener;
import de.drazil.nerdsuite.widget.PlatformFactory;
import de.drazil.nerdsuite.widget.SymbolPaletteChooser;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.inject.Inject;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.e4.core.di.annotations.Optional;
import org.eclipse.e4.ui.di.Focus;
import org.eclipse.e4.ui.di.Persist;
import org.eclipse.e4.ui.di.UIEventTopic;
import org.eclipse.e4.ui.model.application.MApplication;
import org.eclipse.e4.ui.model.application.ui.basic.MPart;
import org.eclipse.e4.ui.model.application.ui.basic.MTrimmedWindow;
import org.eclipse.e4.ui.services.EMenuService;
import org.eclipse.swt.custom.ExtendedModifyEvent;
import org.eclipse.swt.custom.ExtendedModifyListener;
import org.eclipse.swt.custom.LineBackgroundEvent;
import org.eclipse.swt.custom.LineBackgroundListener;
import org.eclipse.swt.custom.LineStyleListener;
import org.eclipse.swt.custom.StyleRange;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;

public class SourceEditorView
implements IDocument,
ICharSelectionListener {
    @Inject
    private MPart part;
    private StyledText styledText = null;
    private DocumentStyler documentStyler;
    private Project project;
    private String owner;
    private SourceRepositoryService srs;
    private BasicInstructions basicInstructions;
    private CustomPopupDialog popupDialog;
    private SymbolPaletteChooser symbolChooser;
    private boolean isOnString = false;
    private boolean isInDragMode = false;
    private AdvancedMouseAdaper ama;

    private DocumentStyler getBasicStyler(BasicInstructions basicInstructions, int version) {
        this.documentStyler = new DocumentStyler(this);
        this.documentStyler.addRule(new MultiLineRule(basicInstructions.getBlockComment()[0], basicInstructions.getBlockComment()[1], new Token("COMMENT_BLOCK")));
        this.documentStyler.addRule(new SingleLineRule(basicInstructions.getSingleLineComment(), Marker.EOL, new Token("COMMENT")));
        this.documentStyler.addRule(new SingleLineRule("//", Marker.EOL, new Token("COMMENT")));
        this.documentStyler.addRule(new SingleLineRule("@", Marker.LINE, new Token("DIRECTIVE")));
        this.documentStyler.addRule(new SingleLineRule(basicInstructions.getStringQuote(), basicInstructions.getStringQuote(), new Token("C64BASIC_STRING"), true));
        for (BasicInstruction bi : basicInstructions.getBasicInstructionList()) {
            block1: for (BasicToken bt : bi.getTokens()) {
                for (int v : bt.getVersion()) {
                    if (v != version) continue;
                    bi.setSelectedVersion(version);
                    bi.setSelectedTokenIndex(bi.getTokens().indexOf(bt));
                    continue block1;
                }
            }
        }
        List list = basicInstructions.getBasicInstructionList().stream().filter(e -> e.getSelectedVersion() == version).collect(Collectors.toList());
        for (BasicInstruction bi : list) {
            if (bi.isComment()) continue;
            this.documentStyler.addRule(new WordRule(bi, new Token("COMMAND")));
        }
        return this.documentStyler;
    }

    @Inject
    @Optional
    public void build(final @UIEventTopic(value="BuildAndRun") BrokerObject brokerObject) {
        if (brokerObject.getOwner().equalsIgnoreCase(this.owner)) {
            Display.getCurrent().asyncExec(new Runnable(){

                @Override
                public void run() {
                    String[] buildProcess = (String[])brokerObject.getTransferObject();
                    SourceEditorView.this.runToolchain(buildProcess);
                }
            });
        }
    }

    @Inject
    @Optional
    public void manageSave(@UIEventTopic(value="Save") BrokerObject brokerObject) {
        if (brokerObject.getOwner().equalsIgnoreCase(this.owner)) {
            this.save();
        }
    }

    private void runToolchain(String[] buildProcess) {
        Console.clear();
        String fileName = String.format("c:/Users/drazil/data/builds/%s.prg", this.project.getName());
        Toolchain toolChain = new Toolchain();
        toolChain.addToolchainStage(new BasicTokenizerStage("Run Basic Tokenizer", this.srs.getMetadata().getPlatform(), this.styledText.getText(), this.basicInstructions, fileName, "1".equals(buildProcess[0])));
        if ("1".equals(buildProcess[1])) {
            toolChain.addToolchainStage(new ExternalRunnerToolchainStage("Run Vice", "\"C:\\Users\\drazil\\applications\\WinVICE-2.4-x86\\x64sc.exe\"", fileName));
        }
        toolChain.start();
    }

    private void save() {
        System.out.println("save source");
        this.srs.setContent(this.styledText.getText());
        this.updateWorkspace(false);
        LocalDateTime ldt = LocalDateTime.now();
        Date d = Date.from(ldt.atZone(ZoneId.systemDefault()).toInstant());
        this.project.setChangedOn(d);
        this.srs.save(this.project);
        this.part.setDirty(false);
    }

    @Persist
    private void close() {
        this.save();
    }

    @PostConstruct
    public void postConstruct(final Composite parent, MApplication app, MTrimmedWindow window, EMenuService menuService) {
        Map pm = (Map)this.part.getObject();
        this.project = (Project)pm.get("project");
        this.owner = (String)pm.get("repositoryOwner");
        this.srs = ServiceFactory.getService(this.project.getId(), SourceRepositoryService.class);
        this.basicInstructions = PlatformFactory.getBasicInstructions(this.srs.getMetadata().getPlatform());
        int version = 20;
        String variant = this.srs.getMetadata().getVariant();
        version = variant.equals("V20") ? 20 : (variant.equals("V35") ? 35 : (variant.equals("V40") ? 40 : (variant.equals("V70") ? 70 : (variant.equals("V10") ? 100 : (variant.equals("SB1") ? 1000 : 0)))));
        this.part.setDirty(false);
        this.part.getTransientData().put("OWNER", this.owner);
        this.part.setTooltip("basic Source File");
        parent.setLayout((Layout)new FillLayout(768));
        this.styledText = new StyledText(parent, 768){

            public void paste() {
                super.paste();
                this.redraw();
            }
        };
        this.styledText.setText(this.srs.getContent() == null ? "" : this.srs.getContent());
        this.styledText.setBackground(Constants.SOURCE_EDITOR_BACKGROUND_COLOR);
        this.styledText.setForeground(Constants.SOURCE_EDITOR_FOREGROUND_COLOR);
        this.styledText.setFont(Constants.SourceCodePro_Mono);
        this.ama = new AdvancedMouseAdaper((Composite)this.styledText);
        this.ama.addMouseListener(new AdvancedMouseListenerAdapter(){

            @Override
            public void rightMouseButtonClicked(int modifierMask, final int x, final int y) {
                Display.getDefault().syncExec(new Runnable(){

                    @Override
                    public void run() {
                        int offset = (this).SourceEditorView.this.styledText.getOffsetAtPoint(new Point(x, y));
                        (this).SourceEditorView.this.styledText.setCaretOffset(offset);
                        SourceEditorView.this.closePupup();
                        (this).SourceEditorView.this.symbolChooser = new SymbolPaletteChooser((Composite)parent.getShell(), 0x20100000, PlatformFactory.getCharMap((this).SourceEditorView.this.srs.getMetadata().getPlatform()), PlatformFactory.getPlatformColors((this).SourceEditorView.this.srs.getMetadata().getPlatform()));
                        (this).SourceEditorView.this.symbolChooser.addCharSelectionListener(SourceEditorView.this);
                        (this).SourceEditorView.this.popupDialog = new CustomPopupDialog(parent.getShell(), (Composite)(this).SourceEditorView.this.symbolChooser);
                        (this).SourceEditorView.this.popupDialog.open();
                    }
                });
            }
        });
        this.documentStyler = this.getBasicStyler(this.basicInstructions, version);
        this.documentStyler.refreshMultilineComments(this.srs.getContent());
        this.styledText.addLineStyleListener((LineStyleListener)this.documentStyler);
        this.styledText.addLineBackgroundListener(new LineBackgroundListener(){

            public void lineGetBackground(LineBackgroundEvent event) {
                event.lineBackground = SourceEditorView.this.styledText.getLineAtOffset(SourceEditorView.this.styledText.getCaretOffset()) == SourceEditorView.this.styledText.getLineAtOffset(event.lineOffset) ? Constants.SOURCE_EDITOR_HIGHLIGHTED_BACKGROUND_COLOR : Constants.SOURCE_EDITOR_BACKGROUND_COLOR;
            }
        });
        this.styledText.addListener(9, new Listener(){

            public void handleEvent(Event event) {
                event.gc.setForeground(Constants.SOURCE_EDITOR_HIGHLIGHTED_FOREGROUND_COLOR);
                int line = SourceEditorView.this.styledText.getOffsetAtLine(SourceEditorView.this.styledText.getLineAtOffset(SourceEditorView.this.styledText.getCaretOffset()));
                Point topLeft = SourceEditorView.this.styledText.getLocationAtOffset(line);
                event.gc.drawRectangle(topLeft.x - 1, topLeft.y, SourceEditorView.this.styledText.getBounds().width, SourceEditorView.this.styledText.getLineHeight());
            }
        });
        this.styledText.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
            }
        });
        this.styledText.addExtendedModifyListener(new ExtendedModifyListener(){

            public void modifyText(ExtendedModifyEvent event) {
                SourceEditorView.this.documentStyler.refreshMultilineComments(SourceEditorView.this.styledText.getText());
                SourceEditorView.this.documentStyler.cleanupLines(SourceEditorView.this.getLineAtOffset(SourceEditorView.this.styledText.getCaretOffset()));
                SourceEditorView.this.styledText.redraw();
            }
        });
        this.styledText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                SourceEditorView.this.part.setDirty(true);
                SourceEditorView.this.documentStyler.refreshMultilineComments(SourceEditorView.this.styledText.getText());
                SourceEditorView.this.documentStyler.cleanupLines(SourceEditorView.this.getLineAtOffset(SourceEditorView.this.styledText.getCaretOffset()));
                SourceEditorView.this.styledText.redraw();
            }
        });
    }

    @Override
    public void charSelected(int charIndex, char unicodeChar, int repeatitionCount) {
        this.styledText.insert(StringUtils.repeat((char)unicodeChar, (int)repeatitionCount));
        this.documentStyler.refreshMultilineComments(this.styledText.getText());
        this.documentStyler.cleanupLines(this.getLineAtOffset(this.styledText.getCaretOffset()));
        this.styledText.setCaretOffset(this.styledText.getCaretOffset() + 1);
        this.styledText.redraw();
    }

    @Override
    public String getText() {
        return this.styledText.getText();
    }

    @Override
    public int getCurrentCharOffset() {
        return this.styledText.getCaretOffset();
    }

    @Override
    public int getFirstVisibleLineIndex() {
        return this.styledText.getTopIndex();
    }

    @Override
    public int getFirstVisibleLineOffset() {
        return this.styledText.getOffsetAtLine(this.getFirstVisibleLineIndex());
    }

    @Override
    public int getLineOffsetAtlineIndex(int lineIndex) {
        return this.styledText.getOffsetAtLine(lineIndex);
    }

    @Override
    public int getLineCount() {
        return this.styledText.getLineCount();
    }

    @Override
    public int getVisibleLineCount() {
        int vlc = this.styledText.getClientArea().height / this.styledText.getLineHeight();
        return vlc > this.getLineCount() ? this.getLineCount() : vlc;
    }

    @Override
    public String getLineAtIndex(int index) {
        return this.styledText.getLine(index);
    }

    @Override
    public int getLineAtOffset(int offset) {
        return this.styledText.getLineAtOffset(offset);
    }

    @Override
    public int getCurrentLineIndex() {
        return this.styledText.getLineAtOffset(this.styledText.getCaretOffset());
    }

    @Override
    public int getCharOffsetAtCurrentLine() {
        return this.getCharOffsetAtLine(this.getCurrentLineIndex());
    }

    @Override
    public int getCharOffsetAtLine(int lineIndex) {
        return this.styledText.getOffsetAtLine(lineIndex);
    }

    @Override
    public void addOrReplaceStyleRanges(int start, int length, StyleRange[] styleRanges) {
        this.styledText.replaceStyleRanges(start, length, styleRanges);
    }

    @Override
    public void setStyleRanges(StyleRange[] styleRanges) {
        this.styledText.setStyleRanges(styleRanges);
    }

    @Override
    public void redraw() {
        this.styledText.redraw();
    }

    @PreDestroy
    public void dispose() {
    }

    @Focus
    public void setFocus() {
    }

    private void updateWorkspace(boolean addProject) {
        Initializer.getConfiguration().updateWorkspace(this.project, addProject, false);
    }

    private void closePupup() {
        if (this.symbolChooser != null) {
            this.symbolChooser.removeCharSelectionListener(null);
            this.popupDialog.close();
        }
    }

    static enum WordBounds {
        Begin,
        End;

    }
}

