/*
 * Decompiled with CFR 0.152.
 */
package de.drazil.nerdsuite.sourceeditor;

import de.drazil.nerdsuite.sourceeditor.BaseRule;
import de.drazil.nerdsuite.sourceeditor.DocumentPartition;
import de.drazil.nerdsuite.sourceeditor.Marker;
import de.drazil.nerdsuite.sourceeditor.Token;

public class SingleLineRule
extends BaseRule {
    public SingleLineRule(String prefix, Token token) {
        super(prefix, null, Marker.WHITE_SPACE, token, false);
        this.setPriority(20);
    }

    public SingleLineRule(String prefix, Marker marker, Token token) {
        super(prefix, null, marker, token, false);
        this.setPriority(marker == Marker.EOL ? 10 : (marker == Marker.WHITE_SPACE ? 20 : 99));
    }

    public SingleLineRule(String prefix, String suffix, Token token, boolean skipSurroundings) {
        super(prefix, suffix, Marker.PARTITION, token, skipSurroundings);
        this.setPriority(30);
    }

    @Override
    public DocumentPartition hasMatch(String text, int offset) {
        int matchPrefixIndex;
        DocumentPartition range = null;
        if (this.getMarker() == Marker.LINE) {
            int matchIndex = text.indexOf(this.getPrefix(), 0);
            if (offset == matchIndex) {
                int len = text.length() - matchIndex;
                range = new DocumentPartition(offset, len);
            }
        } else if (this.getMarker() == Marker.EOL) {
            int matchIndex = text.indexOf(this.getPrefix(), offset);
            if (offset == matchIndex) {
                int len = text.length() - matchIndex;
                range = new DocumentPartition(offset, len);
            }
        } else if (this.getMarker() == Marker.PARTITION && (matchPrefixIndex = text.indexOf(this.getPrefix(), offset)) != -1) {
            int len = this.getPrefix().length();
            int matchSuffixIndex = text.indexOf(this.getSuffix(), matchPrefixIndex + len);
            len = matchSuffixIndex != -1 ? matchSuffixIndex + this.getSuffix().length() - matchPrefixIndex : text.length() - matchPrefixIndex;
            range = new DocumentPartition(matchPrefixIndex, len);
        }
        return range;
    }
}

