/*
 * Decompiled with CFR 0.152.
 */
package de.drazil.nerdsuite.sourceeditor;

import de.drazil.nerdsuite.Constants;
import de.drazil.nerdsuite.model.StyleRangeCacheEntry;
import de.drazil.nerdsuite.sourceeditor.DocumentPartition;
import de.drazil.nerdsuite.sourceeditor.IDocument;
import de.drazil.nerdsuite.sourceeditor.IRule;
import de.drazil.nerdsuite.sourceeditor.MultiLineRule;
import de.drazil.nerdsuite.sourceeditor.SingleLineRule;
import de.drazil.nerdsuite.sourceeditor.ValueRule;
import de.drazil.nerdsuite.sourceeditor.WordRule;
import de.drazil.nerdsuite.util.SwtUtil;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.swt.custom.LineStyleEvent;
import org.eclipse.swt.custom.LineStyleListener;
import org.eclipse.swt.custom.StyleRange;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.TextStyle;
import org.eclipse.swt.widgets.Display;

public class DocumentStyler
implements LineStyleListener {
    private static final String MULTI_LINE_RULE = "MultiLineRule";
    private static final String SINGLE_LINE_RULE = "SingleLineRule";
    private static final String WORD_RULE = "WordRule";
    private static final String CONSTANT_RULE = "ConstantRule";
    private static final String PATTERN_RULE = "PatternRule";
    private List<StyleRange> styleRangeMultiline;
    private List<StyleRangeCacheEntry> styleRangeCache;
    private Map<String, TextStyle> styleMap;
    private Map<String, List<IRule>> ruleMap;
    private IDocument document = null;
    private static Color[] braceDepthColors = new Color[]{new Color((Device)Display.getCurrent(), SwtUtil.toRGB("#C0392B")), new Color((Device)Display.getCurrent(), SwtUtil.toRGB("#F5B7B1")), new Color((Device)Display.getCurrent(), SwtUtil.toRGB("#9B59B6")), new Color((Device)Display.getCurrent(), SwtUtil.toRGB("#1ABC9C")), new Color((Device)Display.getCurrent(), SwtUtil.toRGB("#3498DB")), new Color((Device)Display.getCurrent(), SwtUtil.toRGB("#AAB7B8")), new Color((Device)Display.getCurrent(), SwtUtil.toRGB("#E74C3C")), new Color((Device)Display.getCurrent(), SwtUtil.toRGB("#F1C40F")), new Color((Device)Display.getCurrent(), SwtUtil.toRGB("#F39C12")), new Color((Device)Display.getCurrent(), SwtUtil.toRGB("#129CF3"))};

    public DocumentStyler(IDocument document) {
        this.document = document;
        System.out.println("linefeed length:" + System.getProperty("line.separator").toCharArray().length);
        this.ruleMap = new HashMap<String, List<IRule>>();
        this.styleRangeCache = new ArrayList<StyleRangeCacheEntry>();
        this.styleMap = new HashMap<String, TextStyle>();
        this.styleMap.put("PETME642YASCII", Constants.TEXTSTYLE_PetMe642Y_ASCII);
        this.styleMap.put("PETME2YASCII", Constants.TEXTSTYLE_PetMe2Y_ASCII);
        this.styleMap.put("C64BASIC_STRING", Constants.TEXTSTYLE_C64_ASCII);
        this.styleMap.put("Atari_BASIC_STRING", Constants.TEXTSTYLE_ATARI_ASCII);
        this.styleMap.put("COMMENT", Constants.TEXTSTYLE_COMMENT);
        this.styleMap.put("COMMENT_BLOCK", Constants.TEXTSTYLE_ILLEGAL_OPCODE);
        this.styleMap.put("COMMAND", Constants.TEXTSTYLE_COMMAND);
        this.styleMap.put("STRING", Constants.TEXTSTYLE_STRING);
        this.styleMap.put("DECIMAL", Constants.TEXTSTYLE_DECIMAL);
        this.styleMap.put("HEXADECIMAL", Constants.TEXTSTYLE_HEXADECIMAL);
        this.styleMap.put("ADRESS", Constants.TEXTSTYLE_HEXADECIMAL);
        this.styleMap.put("BINARY", Constants.TEXTSTYLE_BINARY);
        this.styleMap.put("LABEL", Constants.TEXTSTYLE_LABEL);
        this.styleMap.put("DIRECTIVE", Constants.TEXTSTYLE_DIRECTIVE);
        this.styleMap.put("OPCODE", Constants.TEXTSTYLE_OPCODE);
        this.styleMap.put("ILLEGAL_OPCODE", Constants.TEXTSTYLE_ILLEGAL_OPCODE);
        this.styleMap.put("UNSTABLE_ILLEGAL_OPCODE", Constants.TEXTSTYLE_UNSTABLE_ILLEGAL_OPCODE);
    }

    public void refreshMultilineComments(String text) {
        this.styleRangeMultiline = new ArrayList<StyleRange>();
        int matchIndexPrefix = 0;
        int offset = 0;
        while ((matchIndexPrefix = text.indexOf("/*", offset)) != -1) {
            StyleRange styleRange;
            int matchIndexSuffix = text.indexOf("*/", offset += matchIndexPrefix + 2);
            if (matchIndexSuffix != -1) {
                styleRange = new StyleRange(matchIndexPrefix, matchIndexSuffix + 2 - matchIndexPrefix, Constants.DEFAULT_COMMENT_COLOR, null);
                this.styleRangeMultiline.add(styleRange);
                offset += matchIndexSuffix + 2;
                continue;
            }
            styleRange = new StyleRange(matchIndexPrefix, text.length(), Constants.DEFAULT_COMMENT_COLOR, null);
            this.styleRangeMultiline.add(styleRange);
        }
    }

    public void cleanupLines(int lineNo) {
        while (this.styleRangeCache.size() > lineNo) {
            this.styleRangeCache.remove(this.styleRangeCache.size() - 1);
        }
    }

    public void lineGetStyle(LineStyleEvent event) {
        StyleRangeCacheEntry styleRangeCacheEntry = null;
        int lineOffset = event.lineOffset;
        int lineNo = this.document.getLineAtOffset(lineOffset);
        if (lineNo < this.styleRangeCache.size()) {
            styleRangeCacheEntry = this.styleRangeCache.get(lineNo);
        }
        System.out.printf("%d  %d\n", lineOffset, lineNo);
        if (styleRangeCacheEntry == null) {
            styleRangeCacheEntry = new StyleRangeCacheEntry();
            ArrayList<StyleRange> styleRangeList = new ArrayList<StyleRange>();
            styleRangeCacheEntry.setStyleRangeList(styleRangeList);
            styleRangeCacheEntry.setLineIndex(lineNo);
            styleRangeCacheEntry.setLineOffset(lineOffset);
            for (StyleRange sr : this.styleRangeMultiline) {
                styleRangeList.add(sr);
            }
            this.parseText(this.ruleMap.get(SINGLE_LINE_RULE), lineOffset, event.lineText.toLowerCase(), styleRangeList, null, false);
            this.parseText(this.ruleMap.get(WORD_RULE), lineOffset, event.lineText.toLowerCase(), styleRangeList, null, false);
            this.parseText(this.ruleMap.get(CONSTANT_RULE), lineOffset, event.lineText.toLowerCase(), styleRangeList, null, true);
            this.parseBraces(lineOffset, event.lineText.toLowerCase(), styleRangeList, null);
            styleRangeList.sort(new Comparator<StyleRange>(){

                @Override
                public int compare(StyleRange o1, StyleRange o2) {
                    return Integer.compare(o1.start, o2.start);
                }
            });
            if (lineNo < this.styleRangeCache.size()) {
                this.styleRangeCache.add(lineNo, styleRangeCacheEntry);
            } else {
                this.styleRangeCache.add(styleRangeCacheEntry);
            }
        }
        event.styles = styleRangeCacheEntry.getStyleRangeList().toArray(new StyleRange[styleRangeCacheEntry.getStyleRangeList().size()]);
    }

    private void parseBraces(int lineOffset, String text, List<StyleRange> styleRangeList, Color backgroundColor) {
        int openBracesCount = 0;
        int closedBracesCount = 0;
        int braceDepth = 0;
        boolean hasBalancedBraces = false;
        int i = 0;
        while (i < text.length()) {
            StyleRange styleRange;
            if (text.charAt(i) == '(' && !this.isInExistingStyleRange(lineOffset, i, 1, styleRangeList)) {
                styleRange = new StyleRange(lineOffset + i, 1, braceDepthColors[braceDepth], null);
                styleRangeList.add(styleRange);
                ++openBracesCount;
                ++braceDepth;
            }
            if (text.charAt(i) == ')' && !this.isInExistingStyleRange(lineOffset, i, 1, styleRangeList)) {
                styleRange = new StyleRange(lineOffset + i, 1, braceDepthColors[--braceDepth], null);
                styleRangeList.add(styleRange);
                ++closedBracesCount;
            }
            hasBalancedBraces = (openBracesCount + closedBracesCount) % 2 == 0;
            ++i;
        }
    }

    private void parseText(List<IRule> ruleList, int lineOffset, String text, List<StyleRange> styleRangeList, Color backgroundColor, boolean b) {
        if (ruleList == null) {
            return;
        }
        int lo = lineOffset;
        int offset = 0;
        int len = 0;
        boolean hasMatch = false;
        if (b) {
            boolean bl = false;
        }
        while (offset < text.length()) {
            hasMatch = false;
            for (IRule rule : ruleList) {
                DocumentPartition partition = rule.hasMatch(text, offset);
                if (partition == null) continue;
                if (this.isInExistingStyleRange(lo, partition.getOffset(), partition.getLen(), styleRangeList)) break;
                len = partition.getLen();
                offset = partition.getOffset();
                Color c = null;
                c = rule.getTokenControl() == 0 ? Constants.COMMAND_COLOR : (rule.getTokenControl() == 1 ? Constants.FUNCTION_COLOR : (rule.getTokenControl() == 2 ? Constants.OPERATOR_COLOR : (rule.getTokenControl() == 3 ? Constants.CONSTANT_COLOR : (rule.getTokenControl() == 4 ? Constants.BRIGHT_ORANGE : this.styleMap.get((Object)rule.getToken().getKey()).foreground))));
                if (rule.getToken().getKey().equals("C64BASIC_STRING")) {
                    ++offset;
                    len -= 2;
                }
                StyleRange styleRange = new StyleRange(lo + offset, len, c, null);
                styleRange.font = this.styleMap.get((Object)rule.getToken().getKey()).font;
                styleRangeList.add(styleRange);
                hasMatch = true;
                if (!rule.getToken().getKey().equals("C64BASIC_STRING")) break;
                --offset;
                len += 2;
                break;
            }
            if (hasMatch) {
                offset += len;
                continue;
            }
            ++offset;
        }
    }

    private boolean isInExistingStyleRange(int offset, int start, int len, List<StyleRange> styleRangeList) {
        for (StyleRange sr : styleRangeList) {
            if (offset + start < sr.start || offset + start + len > sr.start + sr.length) continue;
            return true;
        }
        return false;
    }

    public void addRule(IRule rule) {
        if (rule instanceof MultiLineRule) {
            this._addRule(MULTI_LINE_RULE, rule);
        } else if (rule instanceof SingleLineRule) {
            this._addRule(SINGLE_LINE_RULE, rule);
        } else if (rule instanceof WordRule) {
            WordRule wr = (WordRule)rule;
            if (rule.getTokenControl() != 4) {
                this._addRule(WORD_RULE, rule);
            } else {
                this._addRule(CONSTANT_RULE, rule);
            }
        } else if (rule instanceof ValueRule) {
            this._addRule(PATTERN_RULE, rule);
        }
    }

    private void _addRule(String ruleName, IRule rule) {
        List<IRule> ruleList = this.ruleMap.get(ruleName);
        if (ruleList == null) {
            ruleList = new ArrayList<IRule>();
            this.ruleMap.put(ruleName, ruleList);
        }
        ruleList.add(rule);
    }
}

