/*
 * Decompiled with CFR 0.152.
 */
package de.drazil.nerdsuite.sourceeditor;

import de.drazil.nerdsuite.model.SourceRules;
import de.drazil.nerdsuite.sourceeditor.IRule;
import de.drazil.nerdsuite.sourceeditor.Marker;
import de.drazil.nerdsuite.sourceeditor.Token;

public abstract class BaseRule
implements IRule {
    protected boolean hasMatch;
    protected boolean hasMore = false;
    protected char[] prefixBuffer;
    protected char[] suffixBuffer;
    protected boolean foundPrefix = false;
    protected boolean foundSuffix = false;
    private String prefix;
    private String suffix;
    private Marker marker;
    private Token token;
    private int priority;
    public int offset;
    public boolean skipSurroundings;

    public BaseRule(SourceRules sourceRule) {
    }

    public BaseRule(String prefix, String suffix, Marker marker, Token token, boolean skipSurroundings) {
        this.setPrefix(prefix);
        this.setSuffix(suffix);
        this.setToken(token);
        this.setMarker(marker);
        this.skipSurroundings = skipSurroundings;
        this.reset();
    }

    public String getPrefixBufferString(char c, int index) {
        return this.getBufferString(this.prefixBuffer, c, index);
    }

    public String getSuffixBufferString(char c, int index) {
        return this.getBufferString(this.suffixBuffer, c, index);
    }

    private String getBufferString(char[] buffer, char c, int index) {
        if (index >= buffer.length) {
            System.arraycopy(buffer, 1, buffer, 0, buffer.length - 1);
        }
        buffer[index < buffer.length ? index : buffer.length - 1] = c;
        return String.valueOf(buffer);
    }

    @Override
    public void reset() {
        this.prefixBuffer = this.createCharArray(this.getPrefix());
        this.suffixBuffer = this.createCharArray(this.getSuffix());
    }

    private char[] createCharArray(String pattern) {
        if (pattern == null) {
            return new char[0];
        }
        return new char[pattern.length()];
    }

    @Override
    public boolean skipSurroundings() {
        return this.skipSurroundings;
    }

    @Override
    public int getTokenControl() {
        return -1;
    }

    @Override
    public String getPrefix() {
        return this.prefix;
    }

    public void setPrefix(String prefix) {
        this.prefix = prefix;
    }

    @Override
    public String getSuffix() {
        return this.suffix;
    }

    public void setSuffix(String suffix) {
        this.suffix = suffix;
    }

    @Override
    public Marker getMarker() {
        return this.marker;
    }

    public void setMarker(Marker marker) {
        this.marker = marker;
    }

    @Override
    public Token getToken() {
        return this.token;
    }

    public void setToken(Token token) {
        this.token = token;
    }

    @Override
    public int getPriority() {
        return this.priority;
    }

    public void setPriority(int priority) {
        this.priority = priority;
    }

    @Override
    public int getOffset() {
        return this.offset;
    }

    public void setOffset(int offset) {
        this.offset = offset;
    }

    public boolean isSkipSurroundings() {
        return this.skipSurroundings;
    }

    public void setSkipSurroundings(boolean skipSurroundings) {
        this.skipSurroundings = skipSurroundings;
    }
}

