/*
 * Decompiled with CFR 0.152.
 */
package de.drazil.nerdsuite.network;

import java.io.IOException;
import java.io.InputStream;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.util.Arrays;

public class TcpHandler {
    private Socket tcpSocket = null;
    private String ip;
    private int port;

    public TcpHandler(String ip, int port) {
        this.ip = ip;
        this.port = port;
    }

    public int openSocket() {
        InetSocketAddress socketAddress = new InetSocketAddress(this.ip, this.port);
        int returnValue = 0;
        try {
            if (this.tcpSocket == null) {
                this.tcpSocket = new Socket();
                this.tcpSocket.connect(socketAddress, 2000);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
            returnValue = -1;
        }
        return returnValue;
    }

    public InputStream getInputStream() throws IOException {
        return this.tcpSocket.getInputStream();
    }

    public int closeSocket() {
        int returnValue = 0;
        try {
            if (this.tcpSocket != null && this.tcpSocket.isConnected()) {
                this.tcpSocket.close();
                this.tcpSocket = null;
            }
        }
        catch (IOException e) {
            e.printStackTrace();
            returnValue = -1;
        }
        return returnValue;
    }

    public Response write(byte[] data) {
        Response response = new Response();
        response.setStatus(0);
        try {
            this.tcpSocket.getOutputStream().write(data);
            InputStream is = this.tcpSocket.getInputStream();
            int bytesToRead = is.available();
            byte[] result = new byte[bytesToRead];
            is.read(result);
            response.setResult(result);
            System.out.println(new String(result));
        }
        catch (IOException e) {
            e.printStackTrace();
            response.setStatus(-1);
        }
        return response;
    }

    public byte[] buildCommand(byte[] ... data) {
        int targetLength = 0;
        byte[][] byArray = data;
        int n = data.length;
        int n2 = 0;
        while (n2 < n) {
            byte[] source = byArray[n2];
            targetLength += source.length;
            ++n2;
        }
        byte[] target = new byte[targetLength];
        int targetPos = 0;
        byte[][] byArray2 = data;
        int n3 = data.length;
        int n4 = 0;
        while (n4 < n3) {
            byte[] source = byArray2[n4];
            System.arraycopy(source, 0, target, targetPos, source.length);
            targetPos += source.length;
            ++n4;
        }
        return target;
    }

    public static class Response {
        private int status;
        private byte[] result;

        public int getStatus() {
            return this.status;
        }

        public byte[] getResult() {
            return this.result;
        }

        public void setStatus(int status) {
            this.status = status;
        }

        public void setResult(byte[] result) {
            this.result = result;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Response)) {
                return false;
            }
            Response other = (Response)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (this.getStatus() != other.getStatus()) {
                return false;
            }
            return Arrays.equals(this.getResult(), other.getResult());
        }

        protected boolean canEqual(Object other) {
            return other instanceof Response;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + this.getStatus();
            result = result * 59 + Arrays.hashCode(this.getResult());
            return result;
        }

        public String toString() {
            return "TcpHandler.Response(status=" + this.getStatus() + ", result=" + Arrays.toString(this.getResult()) + ")";
        }
    }
}

