/*
 * Decompiled with CFR 0.152.
 */
package de.drazil.nerdsuite.mouse;

import de.drazil.nerdsuite.mouse.IMeasuringListener;
import java.util.ArrayList;
import java.util.List;

public class MeasuringController {
    private List<IMeasuringListener> list = new ArrayList<IMeasuringListener>();
    private long triggerMillis;
    private volatile Thread thread;
    private Measure measure;
    private volatile boolean running = false;
    private int timerId = -1;
    private Object payload;

    public void setTriggerMillis(long triggerMillis) {
        this.triggerMillis = triggerMillis;
    }

    public void start(int id, Object payload) {
        if (this.triggerMillis != -1L) {
            this.timerId = id;
            this.payload = payload;
            this.running = true;
            this.measure = new Measure(System.currentTimeMillis(), this.triggerMillis);
            this.thread = new Thread(this.measure);
            this.thread.start();
        }
    }

    public void stop() {
        this.running = false;
        this.thread = null;
    }

    public void addMeasuringListener(IMeasuringListener listener) {
        this.list.add(listener);
    }

    public void removeMeasuringListener(IMeasuringListener listener) {
        this.list.remove(listener);
    }

    private void fireTriggerTimeReached(long triggerMillis) {
        this.list.forEach(l2 -> l2.onTriggerTimeReached(triggerMillis, this.timerId, this.payload));
    }

    private class Measure
    implements Runnable {
        private long startMillies;
        private long triggerMillis;

        public Measure(long startMillies, long triggerMillis) {
            this.startMillies = startMillies;
            this.triggerMillis = triggerMillis;
        }

        @Override
        public synchronized void run() {
            Thread currentMeasurment = Thread.currentThread();
            if (MeasuringController.this.running) {
                while (currentMeasurment == MeasuringController.this.thread) {
                    long diff = System.currentTimeMillis() - this.startMillies;
                    if (!MeasuringController.this.running || diff <= this.triggerMillis) continue;
                    MeasuringController.this.fireTriggerTimeReached(this.triggerMillis);
                    MeasuringController.this.stop();
                }
            }
        }
    }

    public static enum Trigger {
        LEFT,
        MIDDLE,
        RIGHT;

    }
}

