/*
 * Decompiled with CFR 0.152.
 */
package de.drazil.nerdsuite.mouse;

import de.drazil.nerdsuite.mouse.AdvancedMouseAdapterEvent;
import de.drazil.nerdsuite.mouse.IAdvancedMouseListener;
import de.drazil.nerdsuite.mouse.IAdvancedMouseMoveListener;
import de.drazil.nerdsuite.mouse.IAdvancedMouseTrackListener;
import de.drazil.nerdsuite.mouse.IAdvancedMouseWheelListener;
import de.drazil.nerdsuite.mouse.IMeasuringListener;
import de.drazil.nerdsuite.mouse.MeasuringController;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.MouseMoveListener;
import org.eclipse.swt.events.MouseTrackListener;
import org.eclipse.swt.events.MouseWheelListener;
import org.eclipse.swt.widgets.Composite;

public class AdvancedMouseAdaper
implements IMeasuringListener {
    public static final int MOUSE_BUTTON_LEFT = 1;
    public static final int MOUSE_BUTTON_MIDDLE = 2;
    public static final int MOUSE_BUTTON_RIGHT = 3;
    public static final int SET_LEFT_BUTTON_PRESSED = 1;
    public static final int SET_LEFT_BUTTON_RELEASED = 2;
    public static final int SET_MIDDLE_BUTTON_PRESSED = 4;
    public static final int SET_MIDDLE_BUTTON_RELEASED = 8;
    public static final int SET_RIGHT_BUTTON_PRESSED = 16;
    public static final int SET_RIGHT_BUTTON_RELEASED = 32;
    public static final int SET_MOUSE_MOVE = 64;
    public static final int SET_MOUSE_DRAGGED = 128;
    public static final int SET_MOUSE_DROPPED = 256;
    private int mouseState = 34;
    private InternalMouseAdapter lma = null;
    private int leftClickTimeStart = 0;
    private int middleClickTimeStart = 0;
    private int rightClickTimeStart = 0;
    private int leftClickTimeMillis = 800;
    private int leftDoubleClickTimeMillis = 800;
    private int leftTimesClickTimeMillis = 1200;
    private int rightClickTimeMillis = 800;
    private int rightDoubleClickTimeMillis = 800;
    private int rightTimesClickTimeMillis = 1200;
    private boolean mouseActionEnabled = true;
    private boolean canDragDelayed = false;
    private boolean isAlreadyDragging = false;
    private List<IAdvancedMouseListener> mouseListenerList = null;
    private List<IAdvancedMouseMoveListener> mouseMoveListenerList = null;
    private List<IAdvancedMouseTrackListener> mouseTrackListenerList = null;
    private List<IAdvancedMouseWheelListener> mouseWheelListenerList = null;
    private Map<String, MeasuringController> measuringControllerMap = null;

    public AdvancedMouseAdaper(Composite composite) {
        this.lma = new InternalMouseAdapter(composite, this);
        this.mouseListenerList = new ArrayList<IAdvancedMouseListener>();
        this.mouseMoveListenerList = new ArrayList<IAdvancedMouseMoveListener>();
        this.mouseTrackListenerList = new ArrayList<IAdvancedMouseTrackListener>();
        this.mouseWheelListenerList = new ArrayList<IAdvancedMouseWheelListener>();
        this.measuringControllerMap = new HashMap<String, MeasuringController>();
    }

    public void enableDelayTrigger(MeasuringController.Trigger trigger, long delay) {
        MeasuringController mc = null;
        if (trigger == MeasuringController.Trigger.LEFT && delay != -1L) {
            mc = new MeasuringController();
            mc.setTriggerMillis(delay);
            mc.addMeasuringListener(this);
            this.measuringControllerMap.put(MeasuringController.Trigger.LEFT.toString(), mc);
        }
        if (trigger == MeasuringController.Trigger.MIDDLE && delay != -1L) {
            mc = new MeasuringController();
            mc.setTriggerMillis(delay);
            mc.addMeasuringListener(this);
            this.measuringControllerMap.put(MeasuringController.Trigger.MIDDLE.toString(), mc);
        }
        if (trigger == MeasuringController.Trigger.RIGHT && delay != -1L) {
            mc = new MeasuringController();
            mc.setTriggerMillis(delay);
            mc.addMeasuringListener(this);
            this.measuringControllerMap.put(MeasuringController.Trigger.RIGHT.toString(), mc);
        }
    }

    public void stopDelayTrigger(MeasuringController.Trigger trigger) {
        MeasuringController mc;
        if (trigger == MeasuringController.Trigger.LEFT && (mc = this.measuringControllerMap.get(MeasuringController.Trigger.LEFT.toString())) != null) {
            mc.stop();
        }
        if (trigger == MeasuringController.Trigger.MIDDLE && (mc = this.measuringControllerMap.get(MeasuringController.Trigger.MIDDLE.toString())) != null) {
            mc.stop();
        }
        if (trigger == MeasuringController.Trigger.RIGHT && (mc = this.measuringControllerMap.get(MeasuringController.Trigger.RIGHT.toString())) != null) {
            mc.stop();
        }
    }

    public void addMouseListener(IAdvancedMouseListener l) {
        this.mouseListenerList.add(l);
    }

    public void removeMouseListener(IAdvancedMouseListener l) {
        this.mouseListenerList.remove(l);
    }

    public void addMouseMoveListener(IAdvancedMouseMoveListener l) {
        this.mouseMoveListenerList.add(l);
    }

    public void removeMouseMoveListener(IAdvancedMouseMoveListener l) {
        this.mouseMoveListenerList.remove(l);
    }

    public void addMouseTrackListener(IAdvancedMouseTrackListener l) {
        this.mouseTrackListenerList.add(l);
    }

    public void removeMouseTrackListener(IAdvancedMouseTrackListener l) {
        this.mouseTrackListenerList.remove(l);
    }

    public void addMouseWheelListener(IAdvancedMouseWheelListener l) {
        this.mouseWheelListenerList.add(l);
    }

    public void removeMouseWheelListener(IAdvancedMouseWheelListener l) {
        this.mouseWheelListenerList.remove(l);
    }

    @Override
    public void onTriggerTimeReached(long triggerTime, int timerId, Object payload) {
        this.canDragDelayed = true;
        AdvancedMouseAdapterEvent amae = (AdvancedMouseAdapterEvent)payload;
        this.fireMouseButtonPressedDelayed(amae.getButton(), amae.getModifierMask(), amae.getX(), amae.getY());
    }

    public void fireMouseButtonPressed(MouseButton button, int modifierMask, int x, int y) {
        if (this.isMouseActionEnabled()) {
            this.mouseListenerList.forEach(ml -> {
                if (button == MouseButton.Left) {
                    MeasuringController mc = this.measuringControllerMap.get(MeasuringController.Trigger.LEFT.toString());
                    if (mc != null) {
                        mc.start(1, new AdvancedMouseAdapterEvent(button, modifierMask, x, y));
                    }
                    ml.leftMouseButtonPressed(modifierMask, x, y);
                } else if (button == MouseButton.Middle) {
                    MeasuringController mc = this.measuringControllerMap.get(MeasuringController.Trigger.MIDDLE.toString());
                    if (mc != null) {
                        mc.start(1, new AdvancedMouseAdapterEvent(button, modifierMask, x, y));
                    }
                    ml.middleMouseButtonPressed(modifierMask, x, y);
                } else if (button == MouseButton.Right) {
                    MeasuringController mc = this.measuringControllerMap.get(MeasuringController.Trigger.RIGHT.toString());
                    if (mc != null) {
                        mc.start(1, new AdvancedMouseAdapterEvent(button, modifierMask, x, y));
                    }
                    ml.rightMouseButtonPressed(modifierMask, x, y);
                }
            });
        }
    }

    public void fireMouseButtonReleased(MouseButton button, int modifierMask, int x, int y) {
        if (this.isMouseActionEnabled()) {
            this.canDragDelayed = false;
            this.isAlreadyDragging = false;
            this.mouseListenerList.forEach(ml -> {
                if (button == MouseButton.Left) {
                    MeasuringController mc = this.measuringControllerMap.get(MeasuringController.Trigger.LEFT.toString());
                    if (mc != null) {
                        mc.stop();
                    }
                    ml.leftMouseButtonReleased(modifierMask, x, y);
                } else if (button == MouseButton.Middle) {
                    MeasuringController mc = this.measuringControllerMap.get(MeasuringController.Trigger.MIDDLE.toString());
                    if (mc != null) {
                        mc.stop();
                    }
                    ml.middleMouseButtonReleased(modifierMask, x, y);
                } else if (button == MouseButton.Right) {
                    MeasuringController mc = this.measuringControllerMap.get(MeasuringController.Trigger.RIGHT.toString());
                    if (mc != null) {
                        mc.stop();
                    }
                    ml.rightMouseButtonReleased(modifierMask, x, y);
                }
            });
        }
    }

    public void fireMouseButtonTimesClicked(MouseButton button, int modifierMask, int x, int y, int count) {
        if (this.isMouseActionEnabled()) {
            this.mouseListenerList.forEach(ml -> {
                if (button == MouseButton.Left) {
                    ml.leftMouseButtonTimesClicked(modifierMask, x, y, count);
                } else if (button != MouseButton.Middle && button == MouseButton.Right) {
                    ml.rightMouseButtonTimesClicked(modifierMask, x, y, count);
                }
            });
        }
    }

    public void fireMouseButtonPressedDelayed(MouseButton button, int modifierMask, int x, int y) {
        if (this.isMouseActionEnabled()) {
            this.mouseListenerList.forEach(ml -> {
                if (button == MouseButton.Left) {
                    ml.leftMouseButtonPressedDelayed(modifierMask, x, y);
                } else if (button == MouseButton.Middle) {
                    ml.middleMouseButtonPressedDelayed(modifierMask, x, y);
                } else if (button == MouseButton.Right) {
                    ml.rightMouseButtonPressedDelayed(modifierMask, x, y);
                }
            });
        }
    }

    public void fireMouseButtonClicked(MouseButton button, int modifierMask, int x, int y) {
        if (this.isMouseActionEnabled()) {
            this.mouseListenerList.forEach(ml -> {
                if (button == MouseButton.Left) {
                    ml.leftMouseButtonClicked(modifierMask, x, y);
                } else if (button != MouseButton.Middle && button == MouseButton.Right) {
                    ml.rightMouseButtonClicked(modifierMask, x, y);
                }
            });
        }
    }

    public void fireMouseButtonDoubleClicked(MouseButton button, int modifierMask, int x, int y) {
        if (this.isMouseActionEnabled()) {
            this.mouseListenerList.forEach(ml -> {
                if (button == MouseButton.Left) {
                    ml.leftMouseButtonDoubleClicked(modifierMask, x, y);
                } else if (button != MouseButton.Middle && button == MouseButton.Right) {
                    ml.rightMouseButtonDoubleClicked(modifierMask, x, y);
                }
            });
        }
    }

    public void fireMouseTrack(MouseTrack mouseTrack, int modifierMask, int x, int y) {
        if (this.isMouseActionEnabled()) {
            this.mouseTrackListenerList.forEach(ml -> {
                if (mouseTrack == MouseTrack.Enter) {
                    ml.mouseEnter(modifierMask, x, y);
                } else if (mouseTrack == MouseTrack.Exit) {
                    ml.mouseExit(modifierMask, x, y);
                }
            });
        }
    }

    public void fireMouseMove(MouseMove move, int modifierMask, int x, int y) {
        if (this.isMouseActionEnabled()) {
            this.mouseMoveListenerList.forEach(ml -> {
                if (move == MouseMove.Move) {
                    ml.mouseMove(modifierMask, x, y);
                } else if (move == MouseMove.Drag) {
                    if (this.canDragDelayed && !this.isAlreadyDragging) {
                        System.out.println("drag delayed");
                        ml.mouseDraggedDelayed(modifierMask, x, y);
                    } else {
                        this.stopDelayTrigger(MeasuringController.Trigger.LEFT);
                        System.out.println("drag normal");
                        this.canDragDelayed = false;
                        this.isAlreadyDragging = true;
                        ml.mouseDragged(modifierMask, x, y);
                    }
                } else if (move == MouseMove.Drop) {
                    ml.mouseDropped(modifierMask, x, y);
                }
            });
        }
    }

    public void fireMouseScrolled(int modifierMask, int x, int y, int count) {
        if (this.isMouseActionEnabled()) {
            this.mouseWheelListenerList.forEach(ml -> ml.mouseScrolled(modifierMask, x, y, count));
        }
    }

    public int getLeftClickTimeMillis() {
        return this.leftClickTimeMillis;
    }

    public void setLeftClickTimeMillis(int leftClickTimeMillis) {
        this.leftClickTimeMillis = leftClickTimeMillis;
    }

    public int getLeftDoubleClickTimeMillis() {
        return this.leftDoubleClickTimeMillis;
    }

    public void setLeftDoubleClickTimeMillis(int leftDoubleClickTimeMillis) {
        this.leftDoubleClickTimeMillis = leftDoubleClickTimeMillis;
    }

    public int getLeftTimesClickTimeMillis() {
        return this.leftTimesClickTimeMillis;
    }

    public void setLeftTimesClickTimeMillis(int leftTimesClickTimeMillis) {
        this.leftTimesClickTimeMillis = leftTimesClickTimeMillis;
    }

    public int getRightClickTimeMillis() {
        return this.rightClickTimeMillis;
    }

    public void setRightClickTimeMillis(int rightClickTimeMillis) {
        this.rightClickTimeMillis = rightClickTimeMillis;
    }

    public int getRightDoubleClickTimeMillis() {
        return this.rightDoubleClickTimeMillis;
    }

    public void setRightDoubleClickTimeMillis(int rightDoubleClickTimeMillis) {
        this.rightDoubleClickTimeMillis = rightDoubleClickTimeMillis;
    }

    public int getRightTimesClickTimeMillis() {
        return this.rightTimesClickTimeMillis;
    }

    public void setRightTimesClickTimeMillis(int rightTimesClickTimeMillis) {
        this.rightTimesClickTimeMillis = rightTimesClickTimeMillis;
    }

    public boolean isMouseActionEnabled() {
        return this.mouseActionEnabled;
    }

    public void setMouseActionEnabled(boolean mouseActionEnabled) {
        this.mouseActionEnabled = mouseActionEnabled;
    }

    private final class InternalMouseAdapter
    implements MouseMoveListener,
    MouseTrackListener,
    MouseWheelListener,
    MouseListener {
        public InternalMouseAdapter(Composite composite, AdvancedMouseAdaper advancedMouseAdapter) {
            composite.addMouseListener((MouseListener)this);
            composite.addMouseMoveListener((MouseMoveListener)this);
            composite.addMouseTrackListener((MouseTrackListener)this);
            composite.addMouseWheelListener((MouseWheelListener)this);
        }

        public void mouseDoubleClick(MouseEvent e) {
        }

        public void mouseDown(MouseEvent e) {
            int modifierMask = this.getModifierMask(e);
            if (e.button == 1) {
                AdvancedMouseAdaper.this.leftClickTimeStart = e.time;
                this.setMouseState(1, true);
                this.setMouseState(2, false);
                AdvancedMouseAdaper.this.fireMouseButtonPressed(MouseButton.Left, modifierMask, e.x, e.y);
            } else if (e.button == 2) {
                AdvancedMouseAdaper.this.middleClickTimeStart = e.time;
                this.setMouseState(4, true);
                this.setMouseState(8, false);
                AdvancedMouseAdaper.this.fireMouseButtonPressed(MouseButton.Middle, modifierMask, e.x, e.y);
            } else if (e.button == 3) {
                AdvancedMouseAdaper.this.rightClickTimeStart = e.time;
                this.setMouseState(16, true);
                this.setMouseState(32, false);
                AdvancedMouseAdaper.this.fireMouseButtonPressed(MouseButton.Right, modifierMask, e.x, e.y);
            }
        }

        public void mouseEnter(MouseEvent e) {
            int modifierMask = this.getModifierMask(e);
            AdvancedMouseAdaper.this.fireMouseTrack(MouseTrack.Enter, modifierMask, e.x, e.y);
        }

        public void mouseExit(MouseEvent e) {
            int modifierMask = this.getModifierMask(e);
            AdvancedMouseAdaper.this.fireMouseTrack(MouseTrack.Exit, modifierMask, e.x, e.y);
        }

        public void mouseHover(MouseEvent e) {
        }

        public void mouseMove(MouseEvent e) {
            int modifierMask = this.getModifierMask(e);
            this.setMouseState(64, true);
            if (this.isMouseState(65, true)) {
                this.setMouseState(128, true);
                this.setMouseState(256, false);
                AdvancedMouseAdaper.this.fireMouseMove(MouseMove.Drag, modifierMask, e.x, e.y);
            } else {
                AdvancedMouseAdaper.this.fireMouseMove(MouseMove.Move, modifierMask, e.x, e.y);
            }
            this.setMouseState(64, false);
        }

        public void mouseScrolled(MouseEvent e) {
            if ((e.stateMask & 0x40000) == 262144) {
                AdvancedMouseAdaper.this.fireMouseScrolled(this.getModifierMask(e), e.x, e.y, e.count);
            }
        }

        public void mouseUp(MouseEvent e) {
            int modifierMask = this.getModifierMask(e);
            if (this.isMouseState(128, true)) {
                this.setMouseState(256, true);
                this.setMouseState(128, false);
                AdvancedMouseAdaper.this.fireMouseMove(MouseMove.Drop, modifierMask, e.x, e.y);
            }
            if (e.button == 1) {
                this.setMouseState(2, true);
                this.setMouseState(1, false);
                int diff = e.time - AdvancedMouseAdaper.this.leftClickTimeStart;
                if (diff < AdvancedMouseAdaper.this.leftClickTimeMillis && e.count == 1) {
                    AdvancedMouseAdaper.this.fireMouseButtonClicked(MouseButton.Left, modifierMask, e.x, e.y);
                }
                if (diff < AdvancedMouseAdaper.this.leftDoubleClickTimeMillis && e.count == 2) {
                    AdvancedMouseAdaper.this.fireMouseButtonDoubleClicked(MouseButton.Left, modifierMask, e.x, e.y);
                }
                if (diff < AdvancedMouseAdaper.this.leftTimesClickTimeMillis) {
                    AdvancedMouseAdaper.this.fireMouseButtonTimesClicked(MouseButton.Left, modifierMask, e.x, e.y, e.count);
                }
                AdvancedMouseAdaper.this.fireMouseButtonReleased(MouseButton.Left, modifierMask, e.x, e.y);
            } else if (e.button == 2) {
                this.setMouseState(8, true);
                this.setMouseState(4, false);
                AdvancedMouseAdaper.this.fireMouseButtonReleased(MouseButton.Middle, modifierMask, e.x, e.y);
            } else if (e.button == 3) {
                this.setMouseState(32, true);
                this.setMouseState(16, false);
                int diff = e.time - AdvancedMouseAdaper.this.rightClickTimeStart;
                if (diff < AdvancedMouseAdaper.this.rightClickTimeMillis && e.count == 1) {
                    AdvancedMouseAdaper.this.fireMouseButtonClicked(MouseButton.Right, modifierMask, e.x, e.y);
                }
                if (diff < AdvancedMouseAdaper.this.rightDoubleClickTimeMillis && e.count == 2) {
                    AdvancedMouseAdaper.this.fireMouseButtonDoubleClicked(MouseButton.Right, modifierMask, e.x, e.y);
                }
                if (diff < AdvancedMouseAdaper.this.rightTimesClickTimeMillis) {
                    AdvancedMouseAdaper.this.fireMouseButtonTimesClicked(MouseButton.Right, modifierMask, e.x, e.y, e.count);
                }
                AdvancedMouseAdaper.this.fireMouseButtonReleased(MouseButton.Right, modifierMask, e.x, e.y);
            }
        }

        private int getModifierMask(MouseEvent e) {
            return e.stateMask & SWT.MODIFIER_MASK;
        }

        private void setMouseState(int state, boolean set) {
            AdvancedMouseAdaper.this.mouseState = set ? (AdvancedMouseAdaper.this.mouseState |= state) : (AdvancedMouseAdaper.this.mouseState &= state ^ 0xFF);
            AdvancedMouseAdaper.this.mouseState &= 0xFF;
        }

        private boolean isMouseState(int state, boolean set) {
            if (set) {
                return (AdvancedMouseAdaper.this.mouseState & state) == state;
            }
            return (AdvancedMouseAdaper.this.mouseState & (state ^ 0xFF) & 0xFF) == 0;
        }
    }

    public static enum MouseButton {
        Left,
        Middle,
        Right;

    }

    private static enum MouseMove {
        Drag,
        DragDelayed,
        Drop,
        Move;

    }

    private static enum MouseTrack {
        Enter,
        Exit;

    }
}

