/*
 * Decompiled with CFR 0.152.
 */
package de.drazil.nerdsuite.model;

import de.drazil.nerdsuite.enums.ValueType;
import de.drazil.nerdsuite.util.NumericConverter;

public class Value {
    private int value;
    private ValueType valueType;

    public Value(String hexValue) {
        this(hexValue, ValueType.WORD);
    }

    public Value(String hexValue, ValueType valueType) {
        this(Integer.parseInt(hexValue, 16));
    }

    public Value(int value) {
        this(value, ValueType.WORD);
    }

    public Value(int value, ValueType valueType) {
        this.setValue(value);
        this.setValueType(valueType);
    }

    public Value add(int x) {
        return new Value(this.value + x);
    }

    public Value sub(int x) {
        return new Value(this.value - x);
    }

    public Value sub(Value x) {
        return this.sub(x.getValue());
    }

    public Value add(Value x) {
        return this.add(x.getValue());
    }

    public boolean matches(Value x) {
        return this.value == x.getValue();
    }

    public void clear() {
        this.value = 0;
    }

    public ValueType getValueType() {
        return this.valueType;
    }

    public void setValueType(ValueType valueType) {
        this.valueType = valueType;
    }

    public int getLowByte() {
        return this.value & 0xFF;
    }

    public int getHighByte() {
        return this.value >> 8 & 0xFF;
    }

    public int getLowNibble() {
        return this.value & 0xF;
    }

    public int getHighNibble() {
        return this.value >> 4 & 0xF;
    }

    public int getLowWord() {
        return this.value & 0xFFFF;
    }

    public int getHighWord() {
        return this.value >> 16 & 0xFFFF;
    }

    public String toString() {
        String value = "";
        switch (this.valueType) {
            case DWORD: {
                value = NumericConverter.toHexString(this.value, 8);
                break;
            }
            case HIGHWORD: {
                value = NumericConverter.toHexString(this.getHighWord(), 4);
                break;
            }
            case LOWWORD: {
                value = NumericConverter.toHexString(this.getLowWord(), 4);
                break;
            }
            case WORD: {
                value = NumericConverter.toHexString(this.value, 4);
                break;
            }
            case HIGHBYTE: {
                value = NumericConverter.toHexString(this.getHighByte(), 2);
                break;
            }
            case LOWBYTE: {
                value = NumericConverter.toHexString(this.getLowByte(), 2);
                break;
            }
            case BYTE: {
                value = NumericConverter.toHexString(this.value, 2);
                break;
            }
            case HIGHNIBBLE: {
                value = NumericConverter.toHexString(this.getHighNibble(), 2);
                break;
            }
            case LOWNIBBLE: {
                value = NumericConverter.toHexString(this.getLowNibble(), 2);
            }
        }
        return value;
    }

    public int getValue() {
        return this.value;
    }

    public void setValue(int value) {
        this.value = value;
    }
}

