/*
 * Decompiled with CFR 0.152.
 */
package de.drazil.nerdsuite.model;

import de.drazil.nerdsuite.model.AbstractInstruction;
import de.drazil.nerdsuite.model.Opcode;
import java.util.ArrayList;
import java.util.List;

public class CpuInstruction
extends AbstractInstruction {
    private List<String> alias;
    private String type;
    private String flags;
    private String category;
    private boolean illegal;
    private boolean stable = true;
    private List<Opcode> opcodeList;

    public CpuInstruction() {
        this.opcodeList = new ArrayList<Opcode>();
    }

    @Override
    public int getIconIndex() {
        int index = -1;
        index = this.isIllegal() && !this.isStable() ? 3 : (this.isIllegal() ? 2 : 1);
        return index;
    }

    public CpuInstruction(List<String> alias, String type, String flags, String category, boolean illegal, boolean stable, List<Opcode> opcodeList) {
        this.alias = alias;
        this.type = type;
        this.flags = flags;
        this.category = category;
        this.illegal = illegal;
        this.stable = stable;
        this.opcodeList = opcodeList;
    }

    public List<String> getAlias() {
        return this.alias;
    }

    public String getType() {
        return this.type;
    }

    public String getFlags() {
        return this.flags;
    }

    public String getCategory() {
        return this.category;
    }

    public boolean isIllegal() {
        return this.illegal;
    }

    public boolean isStable() {
        return this.stable;
    }

    public List<Opcode> getOpcodeList() {
        return this.opcodeList;
    }

    public void setAlias(List<String> alias) {
        this.alias = alias;
    }

    public void setType(String type) {
        this.type = type;
    }

    public void setFlags(String flags) {
        this.flags = flags;
    }

    public void setCategory(String category) {
        this.category = category;
    }

    public void setIllegal(boolean illegal) {
        this.illegal = illegal;
    }

    public void setStable(boolean stable) {
        this.stable = stable;
    }

    public void setOpcodeList(List<Opcode> opcodeList) {
        this.opcodeList = opcodeList;
    }

    public String toString() {
        return "CpuInstruction(alias=" + this.getAlias() + ", type=" + this.getType() + ", flags=" + this.getFlags() + ", category=" + this.getCategory() + ", illegal=" + this.isIllegal() + ", stable=" + this.isStable() + ", opcodeList=" + this.getOpcodeList() + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof CpuInstruction)) {
            return false;
        }
        CpuInstruction other = (CpuInstruction)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.isIllegal() != other.isIllegal()) {
            return false;
        }
        if (this.isStable() != other.isStable()) {
            return false;
        }
        List<String> this$alias = this.getAlias();
        List<String> other$alias = other.getAlias();
        if (this$alias == null ? other$alias != null : !((Object)this$alias).equals(other$alias)) {
            return false;
        }
        String this$type = this.getType();
        String other$type = other.getType();
        if (this$type == null ? other$type != null : !this$type.equals(other$type)) {
            return false;
        }
        String this$flags = this.getFlags();
        String other$flags = other.getFlags();
        if (this$flags == null ? other$flags != null : !this$flags.equals(other$flags)) {
            return false;
        }
        String this$category = this.getCategory();
        String other$category = other.getCategory();
        if (this$category == null ? other$category != null : !this$category.equals(other$category)) {
            return false;
        }
        List<Opcode> this$opcodeList = this.getOpcodeList();
        List<Opcode> other$opcodeList = other.getOpcodeList();
        return !(this$opcodeList == null ? other$opcodeList != null : !((Object)this$opcodeList).equals(other$opcodeList));
    }

    protected boolean canEqual(Object other) {
        return other instanceof CpuInstruction;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isIllegal() ? 79 : 97);
        result = result * 59 + (this.isStable() ? 79 : 97);
        List<String> $alias = this.getAlias();
        result = result * 59 + ($alias == null ? 43 : ((Object)$alias).hashCode());
        String $type = this.getType();
        result = result * 59 + ($type == null ? 43 : $type.hashCode());
        String $flags = this.getFlags();
        result = result * 59 + ($flags == null ? 43 : $flags.hashCode());
        String $category = this.getCategory();
        result = result * 59 + ($category == null ? 43 : $category.hashCode());
        List<Opcode> $opcodeList = this.getOpcodeList();
        result = result * 59 + ($opcodeList == null ? 43 : ((Object)$opcodeList).hashCode());
        return result;
    }
}

