/*
 * Decompiled with CFR 0.152.
 */
package de.drazil.nerdsuite.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import de.drazil.nerdsuite.model.BasicToken;
import de.drazil.nerdsuite.model.IWordMatcher;
import de.drazil.nerdsuite.sourceeditor.DocumentPartition;
import java.util.List;

public class BasicInstruction
implements IWordMatcher {
    private String instruction;
    private String description;
    private String purpose;
    private boolean includesOpenBrace;
    @JsonProperty(required=false)
    private boolean isComment;
    private int minParameters;
    private int maxParameters;
    private List<String> inParameter;
    private List<BasicToken> tokens;
    private String outValue;
    @JsonIgnore
    private int currentParameter = 0;
    @JsonIgnore
    private int offset = 0;
    @JsonIgnore
    private int selectedTokenIndex = 0;
    @JsonIgnore
    private int selectedVersion = 0;

    @JsonIgnore
    public void reset() {
        this.currentParameter = 0;
    }

    @Override
    @JsonIgnore
    public DocumentPartition hasMatch(String text, int offset) {
        DocumentPartition partition = null;
        if (text.charAt(offset) == this.instruction.charAt(0) && this.purpose.equals("C")) {
            partition = new DocumentPartition(offset, 1);
        } else {
            int matchIndex = text.indexOf(this.instruction, offset);
            if (offset == matchIndex) {
                int len = this.instruction.length();
                if (this.includesOpenBrace) {
                    --len;
                }
                partition = new DocumentPartition(offset, len);
            }
        }
        return partition;
    }

    @Override
    @JsonIgnore
    public int getTokenControl() {
        if (this.purpose.equals("I")) {
            return 0;
        }
        if (this.purpose.equals("F")) {
            return 1;
        }
        if (this.purpose.equals("O")) {
            return 2;
        }
        if (this.purpose.equals("C")) {
            return 3;
        }
        if (this.purpose.equals("R")) {
            return 4;
        }
        return 0;
    }

    public String getInstruction() {
        return this.instruction;
    }

    public String getDescription() {
        return this.description;
    }

    public String getPurpose() {
        return this.purpose;
    }

    public boolean isIncludesOpenBrace() {
        return this.includesOpenBrace;
    }

    public boolean isComment() {
        return this.isComment;
    }

    public int getMinParameters() {
        return this.minParameters;
    }

    public int getMaxParameters() {
        return this.maxParameters;
    }

    public List<String> getInParameter() {
        return this.inParameter;
    }

    public List<BasicToken> getTokens() {
        return this.tokens;
    }

    public String getOutValue() {
        return this.outValue;
    }

    public int getCurrentParameter() {
        return this.currentParameter;
    }

    public int getOffset() {
        return this.offset;
    }

    public int getSelectedTokenIndex() {
        return this.selectedTokenIndex;
    }

    public int getSelectedVersion() {
        return this.selectedVersion;
    }

    public void setInstruction(String instruction) {
        this.instruction = instruction;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public void setPurpose(String purpose) {
        this.purpose = purpose;
    }

    public void setIncludesOpenBrace(boolean includesOpenBrace) {
        this.includesOpenBrace = includesOpenBrace;
    }

    @JsonProperty(required=false)
    public void setComment(boolean isComment) {
        this.isComment = isComment;
    }

    public void setMinParameters(int minParameters) {
        this.minParameters = minParameters;
    }

    public void setMaxParameters(int maxParameters) {
        this.maxParameters = maxParameters;
    }

    public void setInParameter(List<String> inParameter) {
        this.inParameter = inParameter;
    }

    public void setTokens(List<BasicToken> tokens) {
        this.tokens = tokens;
    }

    public void setOutValue(String outValue) {
        this.outValue = outValue;
    }

    @JsonIgnore
    public void setCurrentParameter(int currentParameter) {
        this.currentParameter = currentParameter;
    }

    @JsonIgnore
    public void setOffset(int offset) {
        this.offset = offset;
    }

    @JsonIgnore
    public void setSelectedTokenIndex(int selectedTokenIndex) {
        this.selectedTokenIndex = selectedTokenIndex;
    }

    @JsonIgnore
    public void setSelectedVersion(int selectedVersion) {
        this.selectedVersion = selectedVersion;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof BasicInstruction)) {
            return false;
        }
        BasicInstruction other = (BasicInstruction)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.isIncludesOpenBrace() != other.isIncludesOpenBrace()) {
            return false;
        }
        if (this.isComment() != other.isComment()) {
            return false;
        }
        if (this.getMinParameters() != other.getMinParameters()) {
            return false;
        }
        if (this.getMaxParameters() != other.getMaxParameters()) {
            return false;
        }
        if (this.getCurrentParameter() != other.getCurrentParameter()) {
            return false;
        }
        if (this.getOffset() != other.getOffset()) {
            return false;
        }
        if (this.getSelectedTokenIndex() != other.getSelectedTokenIndex()) {
            return false;
        }
        if (this.getSelectedVersion() != other.getSelectedVersion()) {
            return false;
        }
        String this$instruction = this.getInstruction();
        String other$instruction = other.getInstruction();
        if (this$instruction == null ? other$instruction != null : !this$instruction.equals(other$instruction)) {
            return false;
        }
        String this$description = this.getDescription();
        String other$description = other.getDescription();
        if (this$description == null ? other$description != null : !this$description.equals(other$description)) {
            return false;
        }
        String this$purpose = this.getPurpose();
        String other$purpose = other.getPurpose();
        if (this$purpose == null ? other$purpose != null : !this$purpose.equals(other$purpose)) {
            return false;
        }
        List<String> this$inParameter = this.getInParameter();
        List<String> other$inParameter = other.getInParameter();
        if (this$inParameter == null ? other$inParameter != null : !((Object)this$inParameter).equals(other$inParameter)) {
            return false;
        }
        List<BasicToken> this$tokens = this.getTokens();
        List<BasicToken> other$tokens = other.getTokens();
        if (this$tokens == null ? other$tokens != null : !((Object)this$tokens).equals(other$tokens)) {
            return false;
        }
        String this$outValue = this.getOutValue();
        String other$outValue = other.getOutValue();
        return !(this$outValue == null ? other$outValue != null : !this$outValue.equals(other$outValue));
    }

    protected boolean canEqual(Object other) {
        return other instanceof BasicInstruction;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isIncludesOpenBrace() ? 79 : 97);
        result = result * 59 + (this.isComment() ? 79 : 97);
        result = result * 59 + this.getMinParameters();
        result = result * 59 + this.getMaxParameters();
        result = result * 59 + this.getCurrentParameter();
        result = result * 59 + this.getOffset();
        result = result * 59 + this.getSelectedTokenIndex();
        result = result * 59 + this.getSelectedVersion();
        String $instruction = this.getInstruction();
        result = result * 59 + ($instruction == null ? 43 : $instruction.hashCode());
        String $description = this.getDescription();
        result = result * 59 + ($description == null ? 43 : $description.hashCode());
        String $purpose = this.getPurpose();
        result = result * 59 + ($purpose == null ? 43 : $purpose.hashCode());
        List<String> $inParameter = this.getInParameter();
        result = result * 59 + ($inParameter == null ? 43 : ((Object)$inParameter).hashCode());
        List<BasicToken> $tokens = this.getTokens();
        result = result * 59 + ($tokens == null ? 43 : ((Object)$tokens).hashCode());
        String $outValue = this.getOutValue();
        result = result * 59 + ($outValue == null ? 43 : $outValue.hashCode());
        return result;
    }

    public String toString() {
        return "BasicInstruction(instruction=" + this.getInstruction() + ", description=" + this.getDescription() + ", purpose=" + this.getPurpose() + ", includesOpenBrace=" + this.isIncludesOpenBrace() + ", isComment=" + this.isComment() + ", minParameters=" + this.getMinParameters() + ", maxParameters=" + this.getMaxParameters() + ", inParameter=" + this.getInParameter() + ", tokens=" + this.getTokens() + ", outValue=" + this.getOutValue() + ", currentParameter=" + this.getCurrentParameter() + ", offset=" + this.getOffset() + ", selectedTokenIndex=" + this.getSelectedTokenIndex() + ", selectedVersion=" + this.getSelectedVersion() + ")";
    }
}

