/*
 * Decompiled with CFR 0.152.
 */
package de.drazil.nerdsuite.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import de.drazil.nerdsuite.model.IWordMatcher;
import de.drazil.nerdsuite.sourceeditor.DocumentPartition;

public class BasicDirective
implements IWordMatcher {
    private String name;
    private int offset = 0;

    public BasicDirective(String name) {
        this.name = name;
    }

    @Override
    public DocumentPartition hasMatch(String text, int offset) {
        DocumentPartition partition = null;
        int matchIndex = text.indexOf(this.name, offset);
        if (offset == matchIndex) {
            int len = this.name.length();
            partition = new DocumentPartition(offset, len);
        }
        return partition;
    }

    @Override
    @JsonIgnore
    public int getTokenControl() {
        return 4;
    }

    public String getName() {
        return this.name;
    }

    public int getOffset() {
        return this.offset;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setOffset(int offset) {
        this.offset = offset;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof BasicDirective)) {
            return false;
        }
        BasicDirective other = (BasicDirective)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getOffset() != other.getOffset()) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        return !(this$name == null ? other$name != null : !this$name.equals(other$name));
    }

    protected boolean canEqual(Object other) {
        return other instanceof BasicDirective;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getOffset();
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        return result;
    }

    public String toString() {
        return "BasicDirective(name=" + this.getName() + ", offset=" + this.getOffset() + ")";
    }
}

