/*
 * Decompiled with CFR 0.152.
 */
package de.drazil.nerdsuite.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import de.drazil.nerdsuite.model.BitMask;
import de.drazil.nerdsuite.model.Value;
import java.util.List;

public class Address {
    @JsonIgnore
    private Value value;
    private String address;
    private String constName;
    private String description;
    @JsonProperty(value="readBitMask")
    private List<BitMask> readBitMaskList;
    @JsonProperty(value="writeBitMask")
    private List<BitMask> writeBitMaskList;

    public Address(String address, String constName, String description) {
        this.address = address;
        this.constName = constName;
        this.description = description;
    }

    @JsonIgnore
    public int getAddressValue() {
        return Integer.parseInt(this.address, 16);
    }

    public boolean matches(int value) {
        return this.getAddressValue() == value;
    }

    public boolean hasWriteBitmaskConfiguration() {
        return this.writeBitMaskList != null && this.writeBitMaskList.size() > 0;
    }

    public boolean hasReadBitmaskConfiguration() {
        return this.readBitMaskList != null && this.readBitMaskList.size() > 0;
    }

    public Address() {
    }

    public Value getValue() {
        return this.value;
    }

    public String getAddress() {
        return this.address;
    }

    public String getConstName() {
        return this.constName;
    }

    public String getDescription() {
        return this.description;
    }

    public List<BitMask> getReadBitMaskList() {
        return this.readBitMaskList;
    }

    public List<BitMask> getWriteBitMaskList() {
        return this.writeBitMaskList;
    }

    @JsonIgnore
    public void setValue(Value value) {
        this.value = value;
    }

    public void setAddress(String address) {
        this.address = address;
    }

    public void setConstName(String constName) {
        this.constName = constName;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    @JsonProperty(value="readBitMask")
    public void setReadBitMaskList(List<BitMask> readBitMaskList) {
        this.readBitMaskList = readBitMaskList;
    }

    @JsonProperty(value="writeBitMask")
    public void setWriteBitMaskList(List<BitMask> writeBitMaskList) {
        this.writeBitMaskList = writeBitMaskList;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Address)) {
            return false;
        }
        Address other = (Address)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Value this$value = this.getValue();
        Value other$value = other.getValue();
        if (this$value == null ? other$value != null : !this$value.equals(other$value)) {
            return false;
        }
        String this$address = this.getAddress();
        String other$address = other.getAddress();
        if (this$address == null ? other$address != null : !this$address.equals(other$address)) {
            return false;
        }
        String this$constName = this.getConstName();
        String other$constName = other.getConstName();
        if (this$constName == null ? other$constName != null : !this$constName.equals(other$constName)) {
            return false;
        }
        String this$description = this.getDescription();
        String other$description = other.getDescription();
        if (this$description == null ? other$description != null : !this$description.equals(other$description)) {
            return false;
        }
        List<BitMask> this$readBitMaskList = this.getReadBitMaskList();
        List<BitMask> other$readBitMaskList = other.getReadBitMaskList();
        if (this$readBitMaskList == null ? other$readBitMaskList != null : !((Object)this$readBitMaskList).equals(other$readBitMaskList)) {
            return false;
        }
        List<BitMask> this$writeBitMaskList = this.getWriteBitMaskList();
        List<BitMask> other$writeBitMaskList = other.getWriteBitMaskList();
        return !(this$writeBitMaskList == null ? other$writeBitMaskList != null : !((Object)this$writeBitMaskList).equals(other$writeBitMaskList));
    }

    protected boolean canEqual(Object other) {
        return other instanceof Address;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Value $value = this.getValue();
        result = result * 59 + ($value == null ? 43 : $value.hashCode());
        String $address = this.getAddress();
        result = result * 59 + ($address == null ? 43 : $address.hashCode());
        String $constName = this.getConstName();
        result = result * 59 + ($constName == null ? 43 : $constName.hashCode());
        String $description = this.getDescription();
        result = result * 59 + ($description == null ? 43 : $description.hashCode());
        List<BitMask> $readBitMaskList = this.getReadBitMaskList();
        result = result * 59 + ($readBitMaskList == null ? 43 : ((Object)$readBitMaskList).hashCode());
        List<BitMask> $writeBitMaskList = this.getWriteBitMaskList();
        result = result * 59 + ($writeBitMaskList == null ? 43 : ((Object)$writeBitMaskList).hashCode());
        return result;
    }

    public String toString() {
        return "Address(value=" + this.getValue() + ", address=" + this.getAddress() + ", constName=" + this.getConstName() + ", description=" + this.getDescription() + ", readBitMaskList=" + this.getReadBitMaskList() + ", writeBitMaskList=" + this.getWriteBitMaskList() + ")";
    }
}

