/*
 * Decompiled with CFR 0.152.
 */
package de.drazil.nerdsuite.lexer;

import de.drazil.nerdsuite.lexer.LexicalRule;
import de.drazil.nerdsuite.lexer.Token;
import de.drazil.nerdsuite.lexer.Type;
import java.text.StringCharacterIterator;
import java.util.ArrayList;
import java.util.List;

public class MetaCodeLexer {
    private static String content = "@set _debug=true\n@set x=1\n10 print\"hallo\":a=1\n@if _debug\n20 poke 53280,1:poke 53281,0\n30 print\"das ist ein test\"\n@end\n40 aff_34=1:   b=2:c=3\n @asm name='test'\nlda #$01\nsta$d020\n  @end   ";

    public static String getAtom(String s, int i) {
        int j;
        for (j = i; j < s.length(); ++j) {
            if (Character.isLetter(s.charAt(j)) || Character.isDigit(s.charAt(j))) {
                continue;
            }
            System.out.println(">" + s.substring(i, j) + "<");
            return s.substring(i, j);
        }
        return s.substring(i, j);
    }

    public static String getContent(String s, int i) {
        int j;
        for (j = i; j < s.length(); ++j) {
            if (Character.isLetter(s.charAt(j)) || Character.isDigit(s.charAt(j)) || Character.isWhitespace(s.charAt(j))) {
                continue;
            }
            return s.substring(i, j);
        }
        return s.substring(i, j);
    }

    public static String getQuotedContent(String s, int i, char quote) {
        int j;
        for (j = i; j < s.length(); ++j) {
            if (s.charAt(j) != quote) {
                continue;
            }
            return s.substring(i, j);
        }
        return s.substring(i, j);
    }

    private static void addElement(List<Token> result, String input, int start, int end) {
        if (end > start) {
            int length = end - start;
            String s = input.substring(start, start + length);
            if (s.matches(LexicalRule.HEX_VALUE_BYTE.getValue())) {
                result.add(new Token(Type.HEX, start, length));
            } else if (s.matches(LexicalRule.HEX_ADRESS_WORD.getValue())) {
                result.add(new Token(Type.HEX, start, length));
            } else if (s.matches(LexicalRule.HEX_ADRESS_BYTE.getValue())) {
                result.add(new Token(Type.HEX, start, length));
            } else if (s.matches(LexicalRule.IDENTIFIER.getValue())) {
                result.add(new Token(Type.IDENTIFIER, start, length));
            } else if (s.matches(LexicalRule.INT_VALUE_BYTE.getValue())) {
                result.add(new Token(Type.INT, start, length));
            } else if (s.matches(LexicalRule.BIN_VALUE_BYTE.getValue())) {
                result.add(new Token(Type.BIN, start, length));
            } else if (s.matches(LexicalRule.INTEGER.getValue())) {
                result.add(new Token(Type.INT, start, length));
            }
        }
    }

    public static List<Token> lex(String input) {
        int lastIndex = 0;
        ArrayList<Token> result = new ArrayList<Token>();
        StringCharacterIterator ci = new StringCharacterIterator(input);
        char ch = ci.first();
        while (ch != '\uffff') {
            switch (ch) {
                case '@': {
                    MetaCodeLexer.addElement(result, input, lastIndex, ci.getIndex());
                    int i = ci.getIndex();
                    lastIndex = i + 1;
                    result.add(new Token(Type.AT, i, 1));
                    break;
                }
                case ':': {
                    MetaCodeLexer.addElement(result, input, lastIndex, ci.getIndex());
                    int i = ci.getIndex();
                    lastIndex = i + 1;
                    result.add(new Token(Type.COLON, i, 1));
                    break;
                }
                case ',': {
                    MetaCodeLexer.addElement(result, input, lastIndex, ci.getIndex());
                    int i = ci.getIndex();
                    lastIndex = i + 1;
                    result.add(new Token(Type.COMMA, i, 1));
                    break;
                }
                case '.': {
                    MetaCodeLexer.addElement(result, input, lastIndex, ci.getIndex());
                    int i = ci.getIndex();
                    lastIndex = i + 1;
                    result.add(new Token(Type.POINT, i, 1));
                    break;
                }
                case '\t': 
                case '\n': 
                case '\r': 
                case ' ': {
                    MetaCodeLexer.addElement(result, input, lastIndex, ci.getIndex());
                    int i = ci.getIndex();
                    lastIndex = i + 1;
                    result.add(new Token(Type.WHITESPACE, i, 1));
                    break;
                }
                case '=': {
                    MetaCodeLexer.addElement(result, input, lastIndex, ci.getIndex());
                    int i = ci.getIndex();
                    lastIndex = i + 1;
                    result.add(new Token(Type.EQUAL, i, 1));
                    break;
                }
                case ';': {
                    MetaCodeLexer.addElement(result, input, lastIndex, ci.getIndex());
                    int i = ci.getIndex();
                    lastIndex = i + 1;
                    result.add(new Token(Type.SEMICOLON, i, 1));
                    break;
                }
                case '\'': {
                    MetaCodeLexer.addElement(result, input, lastIndex, ci.getIndex());
                    int i = ci.getIndex();
                    lastIndex = i + 1;
                    result.add(new Token(Type.SINGLE_QUOTE, i, 1));
                    break;
                }
                case '\"': {
                    MetaCodeLexer.addElement(result, input, lastIndex, ci.getIndex());
                    int i = ci.getIndex();
                    lastIndex = i + 1;
                    result.add(new Token(Type.DOUBLE_QUOTE, i, 1));
                    break;
                }
                case '{': {
                    MetaCodeLexer.addElement(result, input, lastIndex, ci.getIndex());
                    int i = ci.getIndex();
                    lastIndex = i + 1;
                    result.add(new Token(Type.OPEN_BRACE_CURLY, i, 1));
                    break;
                }
                case '}': {
                    MetaCodeLexer.addElement(result, input, lastIndex, ci.getIndex());
                    int i = ci.getIndex();
                    lastIndex = i + 1;
                    result.add(new Token(Type.CLOSE_BRACE_CURLY, i, 1));
                }
            }
            ch = ci.next();
        }
        return result;
    }

    public static void main(String[] argv) {
        List<Token> tokens = MetaCodeLexer.lex(content);
        for (Token t : tokens) {
            System.out.println(t + " > " + content.substring(t.getOffset(), t.getOffset() + t.getLength()));
        }
    }
}

