/*
 * Decompiled with CFR 0.152.
 */
package de.drazil.nerdsuite.lexer;

public class LexicalRule {
    public static final LexicalRule IDENTIFIER = new LexicalRule("[a-zA-Z_][a-zA-Z_0-9]*");
    public static final LexicalRule INTEGER = new LexicalRule("[0-9]*");
    public static final LexicalRule ALPHANUMERIC = new LexicalRule("[a-zA-Z0-9]*");
    public static final LexicalRule HEX = new LexicalRule("[0-9a-fA-F]*");
    public static final LexicalRule HEX_ADRESS_BYTE = new LexicalRule("\\$[0-9a-fA-F]{2}");
    public static final LexicalRule HEX_ADRESS_WORD = new LexicalRule("\\$[0-9a-fA-F]{4}");
    public static final LexicalRule HEX_VALUE_BYTE = new LexicalRule("#\\$[0-9a-fA-F]{2}");
    public static final LexicalRule INT_VALUE_BYTE = new LexicalRule("#[0-9]{1,5}");
    public static final LexicalRule BIN_VALUE_BYTE = new LexicalRule("#\\$[0-1]{8}");
    public static final LexicalRule PROPERTY = new LexicalRule("\\$\\{[a-zA-Z]{1}([a-zA-Z0-9]*)?\\}");
    public static final LexicalRule PLUS = new LexicalRule("+");
    public static final LexicalRule MINUS = new LexicalRule("-");
    public static final LexicalRule SLASH = new LexicalRule("/");
    public static final LexicalRule BACKSLASH = new LexicalRule("\\");
    public static final LexicalRule STAR = new LexicalRule("*");
    public static final LexicalRule PERCENT = new LexicalRule("%");
    public static final LexicalRule XOR = new LexicalRule("^");
    public static final LexicalRule AMPERSAND = new LexicalRule("&");
    public static final LexicalRule PIPE = new LexicalRule("|");
    public static final LexicalRule HASH = new LexicalRule("#");
    public static final LexicalRule TRUE = new LexicalRule("true");
    public static final LexicalRule FALSE = new LexicalRule("false");
    public static final LexicalRule OPEN_BRACE = new LexicalRule("[");
    public static final LexicalRule CLOSED_BRACE = new LexicalRule("]");
    public static final LexicalRule OPEN_ROUND_BRACE = new LexicalRule("(");
    public static final LexicalRule CLOSED_ROUND_BRACE = new LexicalRule(")");
    public static final LexicalRule OPEN_CURLY_BRACE = new LexicalRule("{");
    public static final LexicalRule CLOSED_CURLY_BRACE = new LexicalRule("}");
    public static final LexicalRule LESS_THAN = new LexicalRule("<");
    public static final LexicalRule LESS_THAN_EQUAL = new LexicalRule("<=");
    public static final LexicalRule GREATER_THAN = new LexicalRule(">");
    public static final LexicalRule GREATER_THAN_EQUAL = new LexicalRule("=>");
    public static final LexicalRule EQUAL = new LexicalRule("=");
    public static final LexicalRule COMPARE = new LexicalRule("==");
    public static final LexicalRule SEMI = new LexicalRule(";");
    public static final LexicalRule COLON = new LexicalRule(":");
    public static final LexicalRule COMMA = new LexicalRule(",");
    public static final LexicalRule DOUBLE_QUOTE = new LexicalRule("\"");
    public static final LexicalRule SINGLE_QUOTE = new LexicalRule("'");
    public static final LexicalRule WHITESPACE = new LexicalRule("[\n\r\t ]+");
    public static final LexicalRule DATA = new LexicalRule(".*");
    private String value;

    public String getValue() {
        return this.value;
    }

    public void setValue(String value) {
        this.value = value;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof LexicalRule)) {
            return false;
        }
        LexicalRule other = (LexicalRule)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$value = this.getValue();
        String other$value = other.getValue();
        return !(this$value == null ? other$value != null : !this$value.equals(other$value));
    }

    protected boolean canEqual(Object other) {
        return other instanceof LexicalRule;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $value = this.getValue();
        result = result * 59 + ($value == null ? 43 : $value.hashCode());
        return result;
    }

    public String toString() {
        return "LexicalRule(value=" + this.getValue() + ")";
    }

    public LexicalRule(String value) {
        this.value = value;
    }

    public LexicalRule() {
    }
}

