/*
 * Decompiled with CFR 0.152.
 */
package de.drazil.nerdsuite.imaging.service;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import de.drazil.nerdsuite.configuration.Initializer;
import de.drazil.nerdsuite.imaging.service.IService;
import de.drazil.nerdsuite.imaging.service.ITileManagementListener;
import de.drazil.nerdsuite.imaging.service.ITileUpdateListener;
import de.drazil.nerdsuite.imaging.service.ServiceFactory;
import de.drazil.nerdsuite.model.GraphicMetadata;
import de.drazil.nerdsuite.model.Project;
import de.drazil.nerdsuite.util.FileUtil;
import de.drazil.nerdsuite.widget.Layer;
import de.drazil.nerdsuite.widget.Tile;
import de.drazil.nerdsuite.widget.TileContainer;
import java.io.File;
import java.io.FileWriter;
import java.io.Writer;
import java.text.DateFormat;
import java.util.List;
import org.eclipse.swt.graphics.Rectangle;

public class TileRepositoryService
implements IService {
    private String owner = null;
    private Rectangle selection;
    private TileContainer container = new TileContainer();

    public TileRepositoryService getReferenceRepository() {
        TileRepositoryService service = null;
        if (ServiceFactory.checkService(this.getMetadata().getReferenceId())) {
            service = ServiceFactory.getService(this.getMetadata().getReferenceId(), TileRepositoryService.class);
        }
        return service;
    }

    public void init(int tileCount) {
        this.container.addInitialTiles(tileCount);
    }

    public boolean hasReference() {
        return this.getReferenceRepository() != null;
    }

    public List<Tile> getTileList() {
        return this.container.getTileList();
    }

    public void setMetadata(GraphicMetadata metadata) {
        this.container.setMetadata(metadata);
    }

    public GraphicMetadata getMetadata() {
        return this.container.getMetadata();
    }

    public String getSelectedTileName() {
        return this.getSelectedTile().getName();
    }

    public String getTileName(int index) {
        return this.getTile(index).getName();
    }

    public Tile getSelectedTile() {
        return this.container.getSelectedTile();
    }

    public Layer getActiveLayerFromSelectedTile() {
        return this.getSelectedTile().getActiveLayer();
    }

    public Layer getActiveLayerFromTile(int index) {
        return this.getTile(index).getActiveLayer();
    }

    public int getSelectedTileIndex() {
        return this.getSelectedTileIndex(false);
    }

    public int getSelectedTileIndex(boolean natural) {
        return this.container.getSelectedTileIndex(natural);
    }

    public void setSelectedTileIndex(int index) {
        this.container.setSelectedTileIndex(index);
    }

    public void setSelectedTileIndexList(List<Integer> tileIndexList) {
        this.container.setSelectedTileIndexList(tileIndexList);
    }

    public List<Integer> getSelectedTileIndexList() {
        return this.container.getSelectedTileIndexList();
    }

    public void moveTile(int from, int to) {
        this.container.moveTile(from, to);
    }

    public void setDirty(boolean dirty) {
        this.container.setDirty(dirty);
    }

    public int getSize() {
        return this.container.getSize();
    }

    public Tile getTile(int index) {
        return this.container.getTile(index);
    }

    public Tile getTile(int index, boolean naturalOrder) {
        return this.container.getTile(index, naturalOrder);
    }

    public int getTileIndex(int index) {
        return this.container.getTileIndex(index);
    }

    public Tile addTile() {
        return this.container.addTile();
    }

    public void addTileManagementListener(ITileManagementListener ... listeners) {
        this.container.addTileManagementListener(listeners);
    }

    public void addTileUpdateListener(ITileUpdateListener ... listeners) {
        this.container.addTileUpdateListener(listeners);
    }

    public void redrawTileViewer(List<Integer> selectedTileIndexList, int action, boolean temporary) {
        this.container.redrawTileViewer(selectedTileIndexList, action, temporary);
    }

    public TileContainer load(String id) {
        return this.load(id, false);
    }

    public TileContainer load(String id, boolean isReference) {
        ObjectMapper mapper = new ObjectMapper();
        mapper.enable(new JsonParser.Feature[]{JsonParser.Feature.ALLOW_COMMENTS});
        try {
            Project project = Initializer.getConfiguration().getWorkspace().getProjectById(id);
            File file = FileUtil.getFileFromProject(project);
            this.container = (TileContainer)mapper.readValue(file, TileContainer.class);
            String referenceId = this.container.getMetadata().getReferenceId();
            if (referenceId != null) {
                Project referenceProject = Initializer.getConfiguration().getWorkspace().getProjectById(referenceId);
                TileRepositoryService referenceRepository = ServiceFactory.getService(referenceId, TileRepositoryService.class);
                referenceRepository.load(referenceProject.getId(), true);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return this.container;
    }

    public void save(Project project) {
        try {
            File file = FileUtil.getFileFromProject(project);
            FileWriter fw = new FileWriter(file);
            fw.write(TileRepositoryService.getHeaderText(project, this.container.getMetadata()));
            ObjectMapper mapper2 = new ObjectMapper();
            mapper2.enable(SerializationFeature.INDENT_OUTPUT);
            mapper2.writeValue((Writer)fw, (Object)this.container);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static String getHeaderText(Project project, GraphicMetadata metadata) {
        String s = String.format("// Nerdsuite Project by drazil 2017-2022\n// Projectname_____: %s\n// Created on______: %s\n// Changed on______: %s\n", project.getName(), DateFormat.getDateInstance(3).format(project.getCreatedOn()), DateFormat.getDateInstance(3).format(project.getChangedOn()));
        return s;
    }

    public String getOwner() {
        return this.owner;
    }

    @Override
    public void setOwner(String owner) {
        this.owner = owner;
    }

    public Rectangle getSelection() {
        return this.selection;
    }

    public void setSelection(Rectangle selection) {
        this.selection = selection;
    }
}

