/*
 * Decompiled with CFR 0.152.
 */
package de.drazil.nerdsuite.imaging.service;

import de.drazil.nerdsuite.enums.TileAction;
import de.drazil.nerdsuite.imaging.service.AbstractImagingService;
import de.drazil.nerdsuite.imaging.service.TileRepositoryService;
import de.drazil.nerdsuite.widget.Tile;
import org.eclipse.swt.graphics.Rectangle;

public class ShiftService
extends AbstractImagingService {
    public static final int UP = 1;
    public static final int DOWN = 2;
    public static final int LEFT = 3;
    public static final int RIGHT = 4;

    @Override
    public void each(int action, int tileIndex, Tile tile, TileRepositoryService repositoryService, TileAction tileAction) {
        int[] content = tile.getActiveLayer().getContent();
        int[] brush = tile.getActiveLayer().getBrush();
        Rectangle selection = this.service.getSelection();
        int tileWidth = this.conf.getTileWidth();
        int loops = tile.isMulticolorEnabled() ? 2 : 1;
        this.shift(action, content, tileWidth, selection, loops);
        if (brush != null && brush.length > 0) {
            this.shift(action, brush, tileWidth, selection, loops);
        }
    }

    private void shift(int action, int[] data, int tileWidth, Rectangle selection, int loops) {
        block11: {
            block13: {
                block12: {
                    block10: {
                        if (action != 1) break block10;
                        int x = selection.x;
                        while (x < selection.x + selection.width) {
                            int b = data[x + selection.y * tileWidth];
                            int y = selection.y;
                            while (y < selection.y + selection.height - 1) {
                                data[x + y * tileWidth] = data[x + (y + 1) * tileWidth];
                                ++y;
                            }
                            data[x + this.conf.getTileWidth() * (selection.y + selection.height - 1)] = b;
                            ++x;
                        }
                        break block11;
                    }
                    if (action != 2) break block12;
                    int x = selection.x;
                    while (x < selection.x + selection.width) {
                        int b = data[x + tileWidth * (selection.y + selection.height - 1)];
                        int y = selection.y + selection.height - 1;
                        while (y > selection.y) {
                            data[x + y * tileWidth] = data[x + (y - 1) * tileWidth];
                            --y;
                        }
                        data[x + selection.y * tileWidth] = b;
                        ++x;
                    }
                    break block11;
                }
                if (action != 3) break block13;
                int l = 0;
                while (l < loops) {
                    int y = selection.y;
                    while (y < selection.y + selection.height) {
                        int b = data[selection.x + y * tileWidth];
                        int x = selection.x;
                        while (x < selection.x + selection.width - 1) {
                            data[x + y * tileWidth] = data[x + 1 + y * tileWidth];
                            ++x;
                        }
                        data[selection.x + selection.width + y * this.conf.getTileWidth() - 1] = b;
                        ++y;
                    }
                    ++l;
                }
                break block11;
            }
            if (action != 4) break block11;
            int l = 0;
            while (l < loops) {
                int y = selection.y;
                while (y < selection.y + selection.height) {
                    int b = data[selection.x + selection.width + y * tileWidth - 1];
                    int x = selection.x + selection.width - 1;
                    while (x > selection.x) {
                        data[x + y * tileWidth] = data[x - 1 + y * tileWidth];
                        --x;
                    }
                    data[selection.x + y * tileWidth] = b;
                    ++y;
                }
                ++l;
            }
        }
    }
}

