/*
 * Decompiled with CFR 0.152.
 */
package de.drazil.nerdsuite.imaging.service;

import de.drazil.nerdsuite.imaging.service.IService;
import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import java.util.Map;

public class ServiceFactory {
    private static final String COMMON = "COMMON";
    private static Map<String, Map<String, IService>> serviceOwnerMap = new HashMap<String, Map<String, IService>>();

    private ServiceFactory() {
    }

    public static boolean checkService(String id) {
        return serviceOwnerMap.containsKey(id);
    }

    public static <S extends IService> S getCommonService(Class<? super S> serviceClass) {
        return ServiceFactory.getService(COMMON, serviceClass);
    }

    public static <S extends IService> S getService(String owner, Class<? super S> serviceClass) {
        String name;
        Map<String, IService> serviceCacheMap = ServiceFactory.getServiceCacheMap(owner);
        IService service = serviceCacheMap.get(name = serviceClass.getName());
        if (service == null) {
            try {
                service = (IService)serviceClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                service.setOwner(owner);
                serviceCacheMap.put(name, service);
            }
            catch (InstantiationException ex) {
                ex.printStackTrace();
            }
            catch (IllegalAccessException ex) {
                ex.printStackTrace();
            }
            catch (InvocationTargetException ex) {
                ex.printStackTrace();
            }
            catch (NoSuchMethodException ex) {
                ex.printStackTrace();
            }
        }
        return (S)service;
    }

    public static void addService(String owner, IService service, boolean override) {
        String name;
        Map<String, IService> serviceCacheMap = ServiceFactory.getServiceCacheMap(owner);
        IService s = serviceCacheMap.get(name = service.getClass().getName());
        if (s != null && override || s == null) {
            serviceCacheMap.put(name, service);
        }
        service.setOwner(owner);
    }

    public static Map<String, IService> getServiceCacheMap(String owner) {
        Map<String, IService> serviceCacheMap = serviceOwnerMap.get(owner);
        if (serviceCacheMap == null) {
            serviceCacheMap = new HashMap<String, IService>();
            serviceOwnerMap.put(owner, serviceCacheMap);
        }
        return serviceCacheMap;
    }
}

